/*
 * Decompiled with CFR 0.152.
 */
package org.drools.brms.client.modeldriven;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.drools.brms.client.modeldriven.brl.DSLSentence;
import org.drools.brms.client.modeldriven.brl.PortableObject;

public class SuggestionCompletionEngine
implements PortableObject {
    public static final String TYPE_COLLECTION = "Collection";
    public static final String TYPE_COMPARABLE = "Comparable";
    public static final String TYPE_STRING = "String";
    public static final String TYPE_NUMERIC = "Numeric";
    private static final String[] STANDARD_CONNECTIVES = new String[]{"|| ==", "|| !=", "&& !="};
    private static final String[] STRING_CONNECTIVES = new String[]{"|| ==", "|| !=", "&& !=", "&& matches", "|| matches"};
    private static final String[] COMPARABLE_CONNECTIVES = new String[]{"|| ==", "|| !=", "&& !=", "&& >", "&& <", "|| >", "|| <", "&& >=", "&& <=", "|| <=", "|| >="};
    private static final String[] COLLECTION_CONNECTIVES = new String[]{"|| ==", "|| !=", "&& !=", "|| contains", "&& contains", "|| excludes", "&& excludes"};
    private static final String[] STANDARD_OPERATORS = new String[]{"==", "!="};
    private static final String[] COMPARABLE_OPERATORS = new String[]{"==", "!=", "<", ">", "<=", ">="};
    private static final String[] STRING_OPERATORS = new String[]{"==", "!=", "matches"};
    private static final String[] COLLECTION_OPERATORS = new String[]{"contains", "excludes", "==", "!="};
    private static final String[] CONDITIONAL_ELEMENTS = new String[]{"not", "exists", "or"};
    public String[] factTypes;
    public Map fieldsForType;
    public Map fieldTypes;
    public Map globalTypes = new HashMap();
    public Map dataEnumLists = new HashMap();
    public DSLSentence[] conditionDSLSentences = new DSLSentence[0];
    public DSLSentence[] actionDSLSentences = new DSLSentence[0];

    public String[] getConditionalElements() {
        return CONDITIONAL_ELEMENTS;
    }

    public DSLSentence[] getDSLConditions() {
        return this.conditionDSLSentences;
    }

    public DSLSentence[] getDSLActions() {
        return this.actionDSLSentences;
    }

    public String[] getConnectiveOperatorCompletions(String factType, String fieldName) {
        String type = (String)this.fieldTypes.get(factType + "." + fieldName);
        if (type == null) {
            return STANDARD_CONNECTIVES;
        }
        if (type.equals(TYPE_STRING)) {
            return STRING_CONNECTIVES;
        }
        if (type.equals(TYPE_COMPARABLE) || type.equals(TYPE_NUMERIC)) {
            return COMPARABLE_CONNECTIVES;
        }
        if (type.equals(TYPE_COLLECTION)) {
            return COLLECTION_CONNECTIVES;
        }
        return STANDARD_CONNECTIVES;
    }

    public String[] getFactTypes() {
        return this.factTypes;
    }

    public String[] getFieldCompletions(String factType) {
        return (String[])this.fieldsForType.get(factType);
    }

    public String[] getOperatorCompletions(String factType, String fieldName) {
        String type = (String)this.fieldTypes.get(factType + "." + fieldName);
        if (type == null) {
            return STANDARD_OPERATORS;
        }
        if (type.equals(TYPE_STRING)) {
            return STRING_OPERATORS;
        }
        if (type.equals(TYPE_COMPARABLE) || type.equals(TYPE_NUMERIC)) {
            return COMPARABLE_OPERATORS;
        }
        if (type.equals(TYPE_COLLECTION)) {
            return COLLECTION_OPERATORS;
        }
        return STANDARD_OPERATORS;
    }

    public String getFieldType(String factType, String fieldName) {
        return (String)this.fieldTypes.get(factType + "." + fieldName);
    }

    public boolean isGlobalVariable(String variable) {
        return this.globalTypes.containsKey(variable);
    }

    public String[] getFieldCompletionsForGlobalVariable(String varName) {
        String type = (String)this.globalTypes.get(varName);
        return (String[])this.fieldsForType.get(type);
    }

    private String[] toStringArray(Set set) {
        String[] f = new String[set.size()];
        int i = 0;
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            f[i] = (String)iter.next();
            ++i;
        }
        return f;
    }

    public String[] getGlobalVariables() {
        return this.toStringArray(this.globalTypes.keySet());
    }
}

