/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.drools.RuntimeDroolsException;
import org.drools.base.accumulators.AccumulateFunction;
import org.drools.compiler.Dialect;
import org.drools.compiler.DialectConfiguration;
import org.drools.compiler.DialectRegistry;
import org.drools.util.ChainedProperties;

public class PackageBuilderConfiguration {
    private static final String ACCUMULATE_FUNCTION_PREFIX = "drools.accumulate.function.";
    private Map dialects;
    private DialectRegistry dialectRegistry;
    private String defaultDialect;
    private ClassLoader classLoader;
    private ChainedProperties chainedProperties;
    private Map accumulateFunctions;

    public PackageBuilderConfiguration(Properties properties) {
        this.init(null, properties);
    }

    public PackageBuilderConfiguration(ClassLoader classLoader, Properties properties) {
        this.init(classLoader, properties);
    }

    public PackageBuilderConfiguration() {
        this.init(null, null);
    }

    private void init(ClassLoader classLoader, Properties properties) {
        if (classLoader == null && (classLoader = Thread.currentThread().getContextClassLoader()) == null) {
            classLoader = this.getClass().getClassLoader();
        }
        this.setClassLoader(classLoader);
        this.chainedProperties = new ChainedProperties(this.classLoader, "packagebuilder.conf");
        if (properties != null) {
            this.chainedProperties.addProperties(properties);
        }
        this.dialects = new HashMap();
        this.chainedProperties.mapStartsWith(this.dialects, "drools.dialect", false);
        this.setDefaultDialect((String)this.dialects.remove("drools.dialect.default"));
        this.dialectRegistry = this.buildDialectRegistry();
        this.buildAccumulateFunctionsMap();
    }

    public ChainedProperties getChainedProperties() {
        return this.chainedProperties;
    }

    public DialectRegistry buildDialectRegistry() {
        DialectRegistry registry = new DialectRegistry();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Iterator it = this.dialects.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String str = (String)entry.getKey();
            String dialectName = str.substring(str.lastIndexOf(".") + 1);
            String dialectClass = (String)entry.getValue();
            try {
                Class<?> cls = classLoader.loadClass(dialectClass);
                DialectConfiguration dialectConf = (DialectConfiguration)cls.newInstance();
                dialectConf.init(this);
                registry.addDialectConfiguration(dialectName, dialectConf);
            }
            catch (Exception e) {
                throw new RuntimeDroolsException("Unable to load dialect '" + dialectClass + ":" + dialectName + "'", (Throwable)e);
            }
        }
        return registry;
    }

    public DialectRegistry getDialectRegistry() {
        return this.dialectRegistry;
    }

    public Dialect getDefaultDialect() {
        return this.dialectRegistry.getDialectConfiguration(this.defaultDialect).getDialect();
    }

    public void setDefaultDialect(String defaultDialect) {
        this.defaultDialect = defaultDialect;
    }

    public DialectConfiguration getDialectConfiguration(String name) {
        return this.dialectRegistry.getDialectConfiguration(name);
    }

    public void setDialectConfiguration(String name, DialectConfiguration configuration) {
        this.dialectRegistry.addDialectConfiguration(name, configuration);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        if (classLoader != null) {
            this.classLoader = classLoader;
        }
    }

    private void buildAccumulateFunctionsMap() {
        this.accumulateFunctions = new HashMap();
        HashMap temp = new HashMap();
        this.chainedProperties.mapStartsWith(temp, ACCUMULATE_FUNCTION_PREFIX, true);
        Iterator it = temp.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String identifier = ((String)entry.getKey()).trim().substring(ACCUMULATE_FUNCTION_PREFIX.length());
            this.accumulateFunctions.put(identifier, entry.getValue());
        }
    }

    public Map getAccumulateFunctionsMap() {
        return Collections.unmodifiableMap(this.accumulateFunctions);
    }

    public void addAccumulateFunction(String identifier, String className) {
        this.accumulateFunctions.put(identifier, className);
    }

    public void addAccumulateFunction(String identifier, Class clazz) {
        this.accumulateFunctions.put(identifier, clazz.getName());
    }

    public AccumulateFunction getAccumulateFunction(String identifier) {
        String className = (String)this.accumulateFunctions.get(identifier);
        if (className == null) {
            throw new RuntimeDroolsException("No accumulator function found for identifier: " + identifier);
        }
        try {
            Class<?> clazz = this.classLoader.loadClass(className);
            return (AccumulateFunction)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeDroolsException("Error loading accumulator function for identifier " + identifier + ". Class " + className + " not found", (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new RuntimeDroolsException("Error loading accumulator function for identifier " + identifier + ". Class " + className + " not found", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeDroolsException("Error loading accumulator function for identifier " + identifier + ". Class " + className + " not found", (Throwable)e);
        }
    }
}

