/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler;

import com.thoughtworks.xstream.XStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.drools.compiler.PackageBuilder;
import org.drools.compiler.ParserError;
import org.drools.ruleflow.common.core.Process;
import org.drools.ruleflow.core.Connection;
import org.drools.ruleflow.core.MilestoneNode;
import org.drools.ruleflow.core.Node;
import org.drools.ruleflow.core.RuleFlowProcess;
import org.drools.ruleflow.core.RuleFlowProcessValidationError;
import org.drools.ruleflow.core.Split;
import org.drools.ruleflow.core.impl.RuleFlowProcessImpl;
import org.drools.ruleflow.core.impl.RuleFlowProcessValidatorImpl;

public class ProcessBuilder {
    private PackageBuilder packageBuilder;
    private final List processes = new ArrayList();
    private final List errors = new ArrayList();

    public ProcessBuilder(PackageBuilder packageBuilder) {
        this.packageBuilder = packageBuilder;
    }

    public Process[] getProcesses() {
        return this.processes.toArray(new Process[this.processes.size()]);
    }

    public List getErrors() {
        return this.errors;
    }

    public void addProcess(Process process) {
        block3: {
            block4: {
                if (!(process instanceof RuleFlowProcess)) break block3;
                RuleFlowProcessValidatorImpl validator = RuleFlowProcessValidatorImpl.getInstance();
                RuleFlowProcessValidationError[] errors = validator.validateProcess((RuleFlowProcess)process);
                if (errors.length == 0) break block4;
                for (int i = 0; i < errors.length; ++i) {
                    this.errors.add(new ParserError(errors[i].toString(), -1, -1));
                }
                break block3;
            }
            this.processes.add(process);
            String rules = this.generateRules(process);
            if (rules == null || rules.length() == 0) break block3;
            try {
                this.packageBuilder.addPackageFromDrl(new StringReader(rules));
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
    }

    public void addProcessFromFile(Reader reader) throws Exception {
        XStream stream = new XStream();
        stream.setMode(1002);
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader newLoader = this.getClass().getClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(newLoader);
            RuleFlowProcess process = (RuleFlowProcess)stream.fromXML(reader);
            this.addProcess((Process)process);
        }
        catch (Exception t) {
            t.printStackTrace();
            throw t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
        reader.close();
    }

    private String generateRules(Process process) {
        String result = "";
        if (process instanceof RuleFlowProcessImpl) {
            RuleFlowProcessImpl ruleFlow = (RuleFlowProcessImpl)process;
            List imports = ruleFlow.getImports();
            if (imports != null) {
                Iterator iterator = imports.iterator();
                while (iterator.hasNext()) {
                    result = result + "import " + iterator.next() + ";\n";
                }
            }
            Node[] nodes = ruleFlow.getNodes();
            for (int i = 0; i < nodes.length; ++i) {
                if (nodes[i] instanceof Split) {
                    Split split = (Split)nodes[i];
                    if (split.getType() != 2 && split.getType() != 3) continue;
                    Iterator iterator = split.getOutgoingConnections().iterator();
                    while (iterator.hasNext()) {
                        Connection connection = (Connection)iterator.next();
                        result = result + this.createSplitRule(process, connection, split.getConstraint(connection).getConstraint());
                    }
                    continue;
                }
                if (!(nodes[i] instanceof MilestoneNode)) continue;
                MilestoneNode milestone = (MilestoneNode)nodes[i];
                result = result + this.createMilestoneRule(process, milestone);
            }
        }
        return result;
    }

    private String createSplitRule(Process process, Connection connection, String constraint) {
        return "rule \"RuleFlow-" + process.getId() + "-" + connection.getFrom().getId() + "-" + connection.getTo().getId() + "\" \n" + "      ruleflow-group \"DROOLS_SYSTEM\" \n" + "    when \n" + "      " + constraint + "\n" + "    then \n" + "end \n\n";
    }

    private String createMilestoneRule(Process process, MilestoneNode milestone) {
        return "rule \"RuleFlow-" + process.getId() + "-" + milestone.getId() + "\" \n" + "      ruleflow-group \"DROOLS_SYSTEM\" \n" + "    when \n" + "      " + milestone.getConstraint() + "\n" + "    then \n" + "end \n\n";
    }
}

