/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.drools.RuntimeDroolsException;
import org.drools.base.ClassFieldExtractorCache;
import org.drools.base.ClassObjectType;
import org.drools.base.FieldFactory;
import org.drools.base.ValueType;
import org.drools.base.evaluators.Operator;
import org.drools.compiler.Dialect;
import org.drools.compiler.RuleError;
import org.drools.facttemplates.FactTemplate;
import org.drools.facttemplates.FactTemplateFieldExtractor;
import org.drools.facttemplates.FactTemplateObjectType;
import org.drools.lang.MVELDumper;
import org.drools.lang.descr.AndDescr;
import org.drools.lang.descr.BaseDescr;
import org.drools.lang.descr.FieldBindingDescr;
import org.drools.lang.descr.FieldConstraintDescr;
import org.drools.lang.descr.LiteralRestrictionDescr;
import org.drools.lang.descr.OrDescr;
import org.drools.lang.descr.PatternDescr;
import org.drools.lang.descr.PredicateDescr;
import org.drools.lang.descr.QualifiedIdentifierRestrictionDescr;
import org.drools.lang.descr.RestrictionConnectiveDescr;
import org.drools.lang.descr.RestrictionDescr;
import org.drools.lang.descr.ReturnValueRestrictionDescr;
import org.drools.lang.descr.VariableRestrictionDescr;
import org.drools.rule.AbstractCompositeConstraint;
import org.drools.rule.AbstractCompositeRestriction;
import org.drools.rule.AndCompositeRestriction;
import org.drools.rule.AndConstraint;
import org.drools.rule.Declaration;
import org.drools.rule.LiteralConstraint;
import org.drools.rule.LiteralRestriction;
import org.drools.rule.MultiRestrictionFieldConstraint;
import org.drools.rule.OrCompositeRestriction;
import org.drools.rule.OrConstraint;
import org.drools.rule.Pattern;
import org.drools.rule.PatternSource;
import org.drools.rule.PredicateConstraint;
import org.drools.rule.ReturnValueConstraint;
import org.drools.rule.ReturnValueRestriction;
import org.drools.rule.RuleConditionElement;
import org.drools.rule.VariableConstraint;
import org.drools.rule.VariableRestriction;
import org.drools.rule.builder.PredicateBuilder;
import org.drools.rule.builder.ReturnValueBuilder;
import org.drools.rule.builder.RuleBuildContext;
import org.drools.rule.builder.RuleConditionBuilder;
import org.drools.rule.builder.dialect.mvel.MVELDialect;
import org.drools.spi.Constraint;
import org.drools.spi.Evaluator;
import org.drools.spi.Extractor;
import org.drools.spi.FieldExtractor;
import org.drools.spi.FieldValue;
import org.drools.spi.ObjectType;
import org.drools.spi.Restriction;

public class PatternBuilder
implements RuleConditionBuilder {
    public RuleConditionElement build(RuleBuildContext context, BaseDescr descr) {
        return this.build(context, descr, null);
    }

    public RuleConditionElement build(RuleBuildContext context, BaseDescr descr, Pattern prefixPattern) {
        Pattern pattern;
        PatternDescr patternDescr = (PatternDescr)descr;
        if (patternDescr.getObjectType() == null || patternDescr.getObjectType().equals("")) {
            context.getErrors().add(new RuleError(context.getRule(), patternDescr, null, "ObjectType not correctly defined"));
            return null;
        }
        FactTemplateObjectType objectType = null;
        FactTemplate factTemplate = context.getPkg().getFactTemplate(patternDescr.getObjectType());
        if (factTemplate != null) {
            objectType = new FactTemplateObjectType(factTemplate);
        } else {
            try {
                Class userProvidedClass = context.getDialect().getTypeResolver().resolveType(patternDescr.getObjectType());
                objectType = new ClassObjectType(userProvidedClass);
            }
            catch (ClassNotFoundException e) {
                context.getErrors().add(new RuleError(context.getRule(), patternDescr, null, "Unable to resolve ObjectType '" + patternDescr.getObjectType() + "'"));
                return null;
            }
        }
        if (patternDescr.getIdentifier() != null && !patternDescr.getIdentifier().equals("")) {
            if (context.getDeclarationResolver().isDuplicated(patternDescr.getIdentifier())) {
                context.getErrors().add(new RuleError(context.getRule(), patternDescr, null, "Duplicate declaration for variable '" + patternDescr.getIdentifier() + "' in the rule '" + context.getRule().getName() + "'"));
            }
            pattern = new Pattern(context.getNextPatternId(), 0, (ObjectType)objectType, patternDescr.getIdentifier(), patternDescr.isInternalFact());
        } else {
            pattern = new Pattern(context.getNextPatternId(), 0, (ObjectType)objectType, null);
        }
        context.getBuildStack().push(pattern);
        Iterator it = patternDescr.getDescrs().iterator();
        while (it.hasNext()) {
            Object object = it.next();
            this.buildConstraint(context, pattern, object, null);
        }
        if (patternDescr.getSource() != null) {
            RuleConditionBuilder builder = context.getDialect().getBuilder(patternDescr.getSource().getClass());
            PatternSource source = (PatternSource)builder.build(context, patternDescr.getSource());
            pattern.setSource(source);
        }
        context.getBuildStack().pop();
        return pattern;
    }

    private void buildConstraint(RuleBuildContext context, Pattern pattern, Object constraint, AbstractCompositeConstraint container) {
        if (constraint instanceof FieldBindingDescr) {
            this.build(context, pattern, (FieldBindingDescr)constraint);
        } else if (constraint instanceof FieldConstraintDescr) {
            this.build(context, pattern, (FieldConstraintDescr)constraint, container);
        } else if (constraint instanceof PredicateDescr) {
            this.build(context, pattern, (PredicateDescr)constraint, container);
        } else if (constraint instanceof AndDescr) {
            AndConstraint and = new AndConstraint();
            Iterator it = ((AndDescr)constraint).getDescrs().iterator();
            while (it.hasNext()) {
                this.buildConstraint(context, pattern, it.next(), (AbstractCompositeConstraint)and);
            }
            if (container == null) {
                pattern.addConstraint((Constraint)and);
            } else {
                container.addConstraint((Constraint)and);
            }
        } else if (constraint instanceof OrDescr) {
            OrConstraint or = new OrConstraint();
            Iterator it = ((OrDescr)constraint).getDescrs().iterator();
            while (it.hasNext()) {
                this.buildConstraint(context, pattern, it.next(), (AbstractCompositeConstraint)or);
            }
            if (container == null) {
                pattern.addConstraint((Constraint)or);
            } else {
                container.addConstraint((Constraint)or);
            }
        } else {
            context.getErrors().add(new RuleError(context.getRule(), (BaseDescr)constraint, null, "This is a bug: unable to build constraint descriptor: '" + constraint + "' in rule '" + context.getRule().getName() + "'"));
        }
    }

    private void build(RuleBuildContext context, Pattern pattern, FieldConstraintDescr fieldConstraintDescr, AbstractCompositeConstraint container) {
        FieldExtractor extractor;
        String fieldName = fieldConstraintDescr.getFieldName();
        if (fieldName.indexOf(91) > -1) {
            this.rewriteToEval(context, pattern, fieldConstraintDescr, container);
            return;
        }
        if (fieldName.indexOf(46) > -1) {
            String[] identifiers = fieldName.split("\\.");
            if (identifiers.length == 2 && (pattern.getDeclaration() != null && identifiers[0].equals(pattern.getDeclaration().getIdentifier()) || "this".equals(identifiers[0]))) {
                fieldName = identifiers[1];
            } else {
                this.rewriteToEval(context, pattern, fieldConstraintDescr, container);
                return;
            }
        }
        if ((extractor = this.getFieldExtractor(context, fieldConstraintDescr, pattern.getObjectType(), fieldName, false)) == null) {
            if (fieldConstraintDescr.getFieldName().startsWith("this.")) {
                this.rewriteToEval(context, pattern, fieldConstraintDescr, container);
                return;
            }
            context.getErrors().add(new RuleError(context.getRule(), fieldConstraintDescr, null, "Unable to create Field Extractor for '" + fieldName + "' of '" + pattern.getObjectType().toString() + "' in rule '" + context.getRule().getName() + "'"));
            return;
        }
        Restriction restriction = this.createRestriction(context, pattern, fieldConstraintDescr, fieldConstraintDescr.getRestriction(), extractor);
        if (restriction == null) {
            return;
        }
        MultiRestrictionFieldConstraint constraint = null;
        if (restriction instanceof AbstractCompositeRestriction) {
            constraint = new MultiRestrictionFieldConstraint(extractor, restriction);
        } else if (restriction instanceof LiteralRestriction) {
            constraint = new LiteralConstraint(extractor, (LiteralRestriction)restriction);
        } else if (restriction instanceof VariableRestriction) {
            constraint = new VariableConstraint(extractor, (VariableRestriction)restriction);
        } else if (restriction instanceof ReturnValueRestriction) {
            constraint = new ReturnValueConstraint(extractor, (ReturnValueRestriction)restriction);
        } else {
            context.getErrors().add(new RuleError(context.getRule(), fieldConstraintDescr, null, "This is a bug: Unkown restriction type '" + restriction.getClass() + "' for pattern '" + pattern.getObjectType().toString() + "' in rule '" + context.getRule().getName() + "'"));
        }
        if (container == null) {
            pattern.addConstraint((Constraint)constraint);
        } else {
            container.addConstraint((Constraint)constraint);
        }
    }

    private void rewriteToEval(RuleBuildContext context, Pattern pattern, FieldConstraintDescr fieldConstraintDescr, AbstractCompositeConstraint container) {
        Dialect dialect = context.getDialect();
        MVELDialect mvelDialect = (MVELDialect)context.getDialect("mvel");
        boolean strictMode = mvelDialect.isStrictMode();
        mvelDialect.setStrictMode(false);
        context.setDialect(mvelDialect);
        PredicateDescr predicateDescr = new PredicateDescr();
        MVELDumper dumper = new MVELDumper();
        predicateDescr.setContent(dumper.dump(fieldConstraintDescr));
        this.build(context, pattern, predicateDescr, container);
        mvelDialect.setStrictMode(strictMode);
        context.setDialect(dialect);
    }

    private Restriction createRestriction(RuleBuildContext context, Pattern pattern, FieldConstraintDescr fieldConstraintDescr, RestrictionConnectiveDescr top, FieldExtractor extractor) {
        Restriction[] restrictions = new Restriction[top.getRestrictions().size()];
        int index = 0;
        Iterator it = top.getRestrictions().iterator();
        while (it.hasNext()) {
            RestrictionDescr restrictionDescr = (RestrictionDescr)it.next();
            if (restrictionDescr instanceof RestrictionConnectiveDescr) {
                restrictions[index++] = this.createRestriction(context, pattern, fieldConstraintDescr, (RestrictionConnectiveDescr)restrictionDescr, extractor);
                continue;
            }
            restrictions[index] = this.buildRestriction(context, pattern, extractor, fieldConstraintDescr, restrictionDescr);
            if (restrictions[index] == null) {
                context.getErrors().add(new RuleError(context.getRule(), fieldConstraintDescr, null, "Unable to create restriction '" + restrictionDescr.toString() + "' for field '" + fieldConstraintDescr.getFieldName() + "' in the rule '" + context.getRule().getName() + "'"));
            }
            ++index;
        }
        if (restrictions.length > 1) {
            AndCompositeRestriction composite = null;
            if (top.getConnective() == 0) {
                composite = new AndCompositeRestriction(restrictions);
            } else if (top.getConnective() == 1) {
                composite = new OrCompositeRestriction(restrictions);
            } else {
                context.getErrors().add(new RuleError(context.getRule(), fieldConstraintDescr, null, "This is a bug: Impossible to create a composite restriction for connective: " + top.getConnective() + "' for field '" + fieldConstraintDescr.getFieldName() + "' in the rule '" + context.getRule().getName() + "'"));
            }
            return composite;
        }
        if (restrictions.length == 1) {
            return restrictions[0];
        }
        context.getErrors().add(new RuleError(context.getRule(), fieldConstraintDescr, null, "This is a bug: trying to create a restriction for an empty restriction list for field '" + fieldConstraintDescr.getFieldName() + "' in the rule '" + context.getRule().getName() + "'"));
        return null;
    }

    private void build(RuleBuildContext context, Pattern pattern, FieldBindingDescr fieldBindingDescr) {
        if (context.getDeclarationResolver().isDuplicated(fieldBindingDescr.getIdentifier())) {
            context.getErrors().add(new RuleError(context.getRule(), fieldBindingDescr, null, "Duplicate declaration for variable '" + fieldBindingDescr.getIdentifier() + "' in the rule '" + context.getRule().getName() + "'"));
            return;
        }
        FieldExtractor extractor = this.getFieldExtractor(context, fieldBindingDescr, pattern.getObjectType(), fieldBindingDescr.getFieldName(), true);
        if (extractor == null) {
            return;
        }
        pattern.addDeclaration(fieldBindingDescr.getIdentifier(), (Extractor)extractor);
    }

    private void build(RuleBuildContext context, Pattern pattern, PredicateDescr predicateDescr, AbstractCompositeConstraint container) {
        Dialect.AnalysisResult analysis = context.getDialect().analyzeExpression(context, predicateDescr, predicateDescr.getContent());
        if (analysis == null) {
            return;
        }
        List[] usedIdentifiers = analysis.getBoundIdentifiers();
        ArrayList<Declaration> tupleDeclarations = new ArrayList<Declaration>();
        ArrayList<Declaration> factDeclarations = new ArrayList<Declaration>();
        int size = usedIdentifiers[0].size();
        for (int i = 0; i < size; ++i) {
            Declaration decl = context.getDeclarationResolver().getDeclaration((String)usedIdentifiers[0].get(i));
            if (decl.getPattern() == pattern) {
                factDeclarations.add(decl);
                continue;
            }
            tupleDeclarations.add(decl);
        }
        this.createImplicitBindings(context, pattern, analysis.getNotBoundedIdentifiers(), factDeclarations);
        Declaration[] previousDeclarations = tupleDeclarations.toArray(new Declaration[tupleDeclarations.size()]);
        Declaration[] localDeclarations = factDeclarations.toArray(new Declaration[factDeclarations.size()]);
        String[] requiredGlobals = usedIdentifiers[1].toArray(new String[usedIdentifiers[1].size()]);
        PredicateConstraint predicateConstraint = new PredicateConstraint(null, previousDeclarations, localDeclarations, requiredGlobals);
        if (container == null) {
            pattern.addConstraint((Constraint)predicateConstraint);
        } else {
            container.addConstraint((Constraint)predicateConstraint);
        }
        PredicateBuilder builder = context.getDialect().getPredicateBuilder();
        builder.build(context, usedIdentifiers, previousDeclarations, localDeclarations, predicateConstraint, predicateDescr);
    }

    private void createImplicitBindings(RuleBuildContext context, Pattern pattern, List unboundIdentifiers, List factDeclarations) {
        int size = unboundIdentifiers.size();
        for (int i = 0; i < size; ++i) {
            String identifier = (String)unboundIdentifiers.get(i);
            Declaration declaration = this.createDeclarationObject(context, identifier, pattern);
            if (declaration == null) continue;
            factDeclarations.add(declaration);
        }
    }

    private Declaration createDeclarationObject(RuleBuildContext context, String identifier, Pattern pattern) {
        FieldBindingDescr implicitBinding = new FieldBindingDescr(identifier, identifier);
        FieldExtractor extractor = this.getFieldExtractor(context, implicitBinding, pattern.getObjectType(), implicitBinding.getFieldName(), false);
        if (extractor == null) {
            return null;
        }
        Declaration declaration = new Declaration(identifier, (Extractor)extractor, pattern);
        return declaration;
    }

    private Restriction buildRestriction(RuleBuildContext context, Pattern pattern, FieldExtractor extractor, FieldConstraintDescr fieldConstraintDescr, RestrictionDescr restrictionDescr) {
        LiteralRestriction restriction = null;
        if (restrictionDescr instanceof LiteralRestrictionDescr) {
            restriction = this.buildRestriction(context, extractor, fieldConstraintDescr, (LiteralRestrictionDescr)restrictionDescr);
        } else if (restrictionDescr instanceof QualifiedIdentifierRestrictionDescr) {
            restriction = this.buildRestriction(context, extractor, fieldConstraintDescr, (QualifiedIdentifierRestrictionDescr)restrictionDescr);
        } else if (restrictionDescr instanceof VariableRestrictionDescr) {
            restriction = this.buildRestriction(context, extractor, fieldConstraintDescr, (VariableRestrictionDescr)restrictionDescr);
        } else if (restrictionDescr instanceof ReturnValueRestrictionDescr) {
            restriction = this.buildRestriction(context, pattern, extractor, fieldConstraintDescr, (ReturnValueRestrictionDescr)restrictionDescr);
        }
        return restriction;
    }

    private VariableRestriction buildRestriction(RuleBuildContext context, FieldExtractor extractor, FieldConstraintDescr fieldConstraintDescr, VariableRestrictionDescr variableRestrictionDescr) {
        Evaluator evaluator;
        if (variableRestrictionDescr.getIdentifier() == null || variableRestrictionDescr.getIdentifier().equals("")) {
            context.getErrors().add(new RuleError(context.getRule(), variableRestrictionDescr, null, "Identifier not defined for binding field '" + fieldConstraintDescr.getFieldName() + "'"));
            return null;
        }
        Declaration declaration = context.getDeclarationResolver().getDeclaration(variableRestrictionDescr.getIdentifier());
        if (declaration == null) {
            Pattern thisPattern = (Pattern)context.getBuildStack().peek();
            Declaration implicit = this.createDeclarationObject(context, variableRestrictionDescr.getIdentifier(), thisPattern);
            if (implicit != null) {
                declaration = implicit;
            } else {
                context.getErrors().add(new RuleError(context.getRule(), variableRestrictionDescr, null, "Unable to return Declaration for identifier '" + variableRestrictionDescr.getIdentifier() + "'"));
                return null;
            }
        }
        if ((evaluator = this.getEvaluator(context, variableRestrictionDescr, extractor.getValueType(), variableRestrictionDescr.getEvaluator())) == null) {
            return null;
        }
        return new VariableRestriction(extractor, declaration, evaluator);
    }

    private LiteralRestriction buildRestriction(RuleBuildContext context, FieldExtractor extractor, FieldConstraintDescr fieldConstraintDescr, LiteralRestrictionDescr literalRestrictionDescr) {
        FieldValue field = null;
        try {
            field = FieldFactory.getFieldValue((String)literalRestrictionDescr.getText(), (ValueType)extractor.getValueType());
        }
        catch (Exception e) {
            context.getErrors().add(new RuleError(context.getRule(), literalRestrictionDescr, e, "Unable to create a Field value of type  '" + extractor.getValueType() + "' and value '" + literalRestrictionDescr.getText() + "'"));
        }
        if (field == null) {
            return null;
        }
        Evaluator evaluator = this.getEvaluator(context, literalRestrictionDescr, extractor.getValueType(), literalRestrictionDescr.getEvaluator());
        if (evaluator == null) {
            return null;
        }
        return new LiteralRestriction(field, evaluator, extractor);
    }

    private Restriction buildRestriction(RuleBuildContext context, FieldExtractor extractor, FieldConstraintDescr fieldConstraintDescr, QualifiedIdentifierRestrictionDescr qiRestrictionDescr) {
        FieldValue field = null;
        String[] parts = qiRestrictionDescr.getText().split("\\.");
        if (parts.length == 2) {
            Declaration implicit = null;
            if ("this".equals(parts[0])) {
                implicit = this.createDeclarationObject(context, parts[1], (Pattern)context.getBuildStack().peek());
            } else {
                Declaration decl = context.getDeclarationResolver().getDeclaration(parts[0]);
                if (decl != null) {
                    if (decl.isPatternDeclaration()) {
                        implicit = this.createDeclarationObject(context, parts[1], decl.getPattern());
                    } else {
                        context.getErrors().add(new RuleError(context.getRule(), qiRestrictionDescr, "", "Not possible to directly access the property '" + parts[1] + "' of declaration '" + parts[0] + "' since it is not a pattern"));
                        return null;
                    }
                }
            }
            if (implicit != null) {
                Evaluator evaluator = this.getEvaluator(context, qiRestrictionDescr, extractor.getValueType(), qiRestrictionDescr.getEvaluator());
                if (evaluator == null) {
                    return null;
                }
                return new VariableRestriction(extractor, implicit, evaluator);
            }
        }
        int lastDot = qiRestrictionDescr.getText().lastIndexOf(46);
        String className = qiRestrictionDescr.getText().substring(0, lastDot);
        String fieldName = qiRestrictionDescr.getText().substring(lastDot + 1);
        try {
            Class staticClass = context.getDialect().getTypeResolver().resolveType(className);
            field = FieldFactory.getFieldValue((Object)staticClass.getField(fieldName).get(null), (ValueType)extractor.getValueType());
        }
        catch (ClassNotFoundException e) {
        }
        catch (Exception e) {
            context.getErrors().add(new RuleError(context.getRule(), qiRestrictionDescr, e, "Unable to create a Field value of type  '" + extractor.getValueType() + "' and value '" + qiRestrictionDescr.getText() + "'"));
        }
        if (field == null) {
            return null;
        }
        Evaluator evaluator = this.getEvaluator(context, qiRestrictionDescr, extractor.getValueType(), qiRestrictionDescr.getEvaluator());
        if (evaluator == null) {
            return null;
        }
        return new LiteralRestriction(field, evaluator, extractor);
    }

    private ReturnValueRestriction buildRestriction(RuleBuildContext context, Pattern pattern, FieldExtractor extractor, FieldConstraintDescr fieldConstraintDescr, ReturnValueRestrictionDescr returnValueRestrictionDescr) {
        Dialect.AnalysisResult analysis = context.getDialect().analyzeExpression(context, returnValueRestrictionDescr, returnValueRestrictionDescr.getContent());
        List[] usedIdentifiers = analysis.getBoundIdentifiers();
        ArrayList<Declaration> tupleDeclarations = new ArrayList<Declaration>();
        ArrayList<Declaration> factDeclarations = new ArrayList<Declaration>();
        int size = usedIdentifiers[0].size();
        for (int i = 0; i < size; ++i) {
            Declaration declaration = context.getDeclarationResolver().getDeclaration((String)usedIdentifiers[0].get(i));
            if (declaration.getPattern() == pattern) {
                factDeclarations.add(declaration);
                continue;
            }
            tupleDeclarations.add(declaration);
        }
        this.createImplicitBindings(context, pattern, analysis.getNotBoundedIdentifiers(), factDeclarations);
        Evaluator evaluator = this.getEvaluator(context, returnValueRestrictionDescr, extractor.getValueType(), returnValueRestrictionDescr.getEvaluator());
        if (evaluator == null) {
            return null;
        }
        Declaration[] previousDeclarations = tupleDeclarations.toArray(new Declaration[tupleDeclarations.size()]);
        Declaration[] localDeclarations = factDeclarations.toArray(new Declaration[factDeclarations.size()]);
        String[] requiredGlobals = usedIdentifiers[1].toArray(new String[usedIdentifiers[1].size()]);
        ReturnValueRestriction returnValueRestriction = new ReturnValueRestriction(extractor, previousDeclarations, localDeclarations, requiredGlobals, evaluator);
        ReturnValueBuilder builder = context.getDialect().getReturnValueBuilder();
        builder.build(context, usedIdentifiers, previousDeclarations, localDeclarations, returnValueRestriction, returnValueRestrictionDescr);
        return returnValueRestriction;
    }

    private FieldExtractor getFieldExtractor(RuleBuildContext context, BaseDescr descr, ObjectType objectType, String fieldName, boolean reportError) {
        FactTemplateFieldExtractor extractor;
        block4: {
            extractor = null;
            if (objectType.getValueType() == ValueType.FACTTEMPLATE_TYPE) {
                FactTemplate factTemplate = ((FactTemplateObjectType)objectType).getFactTemplate();
                extractor = new FactTemplateFieldExtractor(factTemplate, factTemplate.getFieldTemplateIndex(fieldName));
            } else {
                try {
                    ClassLoader classloader = context.getPkg().getPackageCompilationData().getClassLoader();
                    context.getDialect().getClassFieldExtractorCache();
                    extractor = ClassFieldExtractorCache.getExtractor((Class)((ClassObjectType)objectType).getClassType(), (String)fieldName, (ClassLoader)classloader);
                }
                catch (RuntimeDroolsException e) {
                    if (!reportError) break block4;
                    context.getErrors().add(new RuleError(context.getRule(), descr, (Object)e, "Unable to create Field Extractor for '" + fieldName + "'"));
                }
            }
        }
        return extractor;
    }

    private Evaluator getEvaluator(RuleBuildContext context, BaseDescr descr, ValueType valueType, String evaluatorString) {
        Evaluator evaluator = valueType.getEvaluator(Operator.determineOperator((String)evaluatorString));
        if (evaluator == null) {
            context.getErrors().add(new RuleError(context.getRule(), descr, null, "Unable to determine the Evaluator for  '" + valueType + "' and '" + evaluatorString + "'"));
        }
        return evaluator;
    }
}

