/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder.dialect.java;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.drools.base.accumulators.AccumulateFunction;
import org.drools.base.accumulators.JavaAccumulatorFunctionExecutor;
import org.drools.compiler.Dialect;
import org.drools.lang.descr.AccumulateDescr;
import org.drools.lang.descr.BaseDescr;
import org.drools.lang.descr.PatternDescr;
import org.drools.rule.Accumulate;
import org.drools.rule.Declaration;
import org.drools.rule.Pattern;
import org.drools.rule.RuleConditionElement;
import org.drools.rule.builder.AccumulateBuilder;
import org.drools.rule.builder.PatternBuilder;
import org.drools.rule.builder.RuleBuildContext;
import org.drools.rule.builder.dialect.java.AbstractJavaBuilder;
import org.drools.rule.builder.dialect.java.JavaAnalysisResult;
import org.drools.rule.builder.dialect.java.parser.JavaLocalDeclarationDescr;
import org.drools.spi.Accumulator;

public class JavaAccumulateBuilder
extends AbstractJavaBuilder
implements AccumulateBuilder {
    public RuleConditionElement build(RuleBuildContext context, BaseDescr descr) {
        return this.build(context, descr, null);
    }

    public RuleConditionElement build(RuleBuildContext context, BaseDescr descr, Pattern prefixPattern) {
        AccumulateDescr accumDescr = (AccumulateDescr)descr;
        PatternBuilder patternBuilder = (PatternBuilder)context.getDialect().getBuilder(PatternDescr.class);
        Pattern sourcePattern = (Pattern)patternBuilder.build(context, accumDescr.getInputPattern());
        if (sourcePattern == null) {
            return null;
        }
        Accumulate accumulate = null;
        if (accumDescr.isExternalFunction()) {
            JavaAnalysisResult analysis = (JavaAnalysisResult)context.getDialect().analyzeBlock(context, accumDescr, accumDescr.getExpression());
            List[] usedIdentifiers = analysis.getBoundIdentifiers();
            ArrayList<Declaration> tupleDeclarations = new ArrayList<Declaration>();
            int size = usedIdentifiers[0].size();
            for (int i = 0; i < size; ++i) {
                tupleDeclarations.add(context.getDeclarationResolver().getDeclaration((String)usedIdentifiers[0].get(i)));
            }
            Declaration[] previousDeclarations = tupleDeclarations.toArray(new Declaration[tupleDeclarations.size()]);
            String[] requiredGlobals = usedIdentifiers[1].toArray(new String[usedIdentifiers[1].size()]);
            Declaration[] sourceDeclArr = sourcePattern.getOuterDeclarations().values().toArray(new Declaration[0]);
            String className = "accumulateExpression" + context.getNextId();
            Map map = this.createVariableContext(className, accumDescr.getExpression(), context, previousDeclarations, sourceDeclArr, requiredGlobals);
            AccumulateFunction function = context.getConfiguration().getAccumulateFunction(accumDescr.getFunctionIdentifier());
            JavaAccumulatorFunctionExecutor accumulator = new JavaAccumulatorFunctionExecutor(function);
            accumulate = new Accumulate(sourcePattern, previousDeclarations, sourceDeclArr, (Accumulator)accumulator);
            this.generatTemplates("returnValueMethod", "returnValueInvoker", context, className, map, accumulator, accumDescr);
        } else {
            String className = "Accumulate" + context.getNextId();
            accumDescr.setClassName(className);
            JavaAnalysisResult initCodeAnalysis = (JavaAnalysisResult)context.getDialect().analyzeBlock(context, accumDescr, accumDescr.getInitCode());
            Dialect.AnalysisResult actionCodeAnalysis = context.getDialect().analyzeBlock(context, accumDescr, accumDescr.getActionCode());
            Dialect.AnalysisResult resultCodeAnalysis = context.getDialect().analyzeExpression(context, accumDescr, accumDescr.getResultCode());
            ArrayList requiredDeclarations = new ArrayList(initCodeAnalysis.getBoundIdentifiers()[0]);
            requiredDeclarations.addAll(actionCodeAnalysis.getBoundIdentifiers()[0]);
            requiredDeclarations.addAll(resultCodeAnalysis.getBoundIdentifiers()[0]);
            ArrayList requiredGlobals = new ArrayList(initCodeAnalysis.getBoundIdentifiers()[1]);
            requiredGlobals.addAll(actionCodeAnalysis.getBoundIdentifiers()[1]);
            requiredGlobals.addAll(resultCodeAnalysis.getBoundIdentifiers()[1]);
            if (accumDescr.getReverseCode() != null) {
                Dialect.AnalysisResult reverseCodeAnalysis = context.getDialect().analyzeBlock(context, accumDescr, accumDescr.getActionCode());
                requiredDeclarations.addAll(reverseCodeAnalysis.getBoundIdentifiers()[0]);
                requiredGlobals.addAll(reverseCodeAnalysis.getBoundIdentifiers()[1]);
            }
            Declaration[] declarations = new Declaration[requiredDeclarations.size()];
            int size = requiredDeclarations.size();
            for (int i = 0; i < size; ++i) {
                declarations[i] = context.getDeclarationResolver().getDeclaration((String)requiredDeclarations.get(i));
            }
            Declaration[] sourceDeclArr = sourcePattern.getOuterDeclarations().values().toArray(new Declaration[0]);
            String[] globals = requiredGlobals.toArray(new String[requiredGlobals.size()]);
            Map map = this.createVariableContext(className, null, context, declarations, null, globals);
            map.put("className", accumDescr.getClassName());
            map.put("innerDeclarations", sourceDeclArr);
            String initCode = this.fixInitCode(initCodeAnalysis, accumDescr.getInitCode());
            String actionCode = accumDescr.getActionCode();
            String resultCode = accumDescr.getResultCode();
            String[] attributesTypes = new String[initCodeAnalysis.getLocalVariablesMap().size()];
            String[] attributes = new String[initCodeAnalysis.getLocalVariablesMap().size()];
            int index = 0;
            Iterator it = initCodeAnalysis.getLocalVariablesMap().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                attributes[index] = (String)entry.getKey();
                attributesTypes[index] = ((JavaLocalDeclarationDescr)entry.getValue()).getType();
            }
            map.put("attributes", attributes);
            map.put("attributesTypes", attributesTypes);
            map.put("initCode", initCode);
            map.put("actionCode", actionCode);
            map.put("resultCode", resultCode);
            if (accumDescr.getReverseCode() == null) {
                map.put("reverseCode", "");
                map.put("supportsReverse", "false");
            } else {
                map.put("reverseCode", accumDescr.getReverseCode());
                map.put("supportsReverse", "true");
            }
            map.put("hashCode", new Integer(actionCode.hashCode()));
            accumulate = new Accumulate(sourcePattern, declarations, sourceDeclArr);
            this.generatTemplates("accumulateInnerClass", "accumulateInvoker", context, className, map, accumulate, accumDescr);
        }
        return accumulate;
    }

    protected String fixInitCode(JavaAnalysisResult analysis, String originalCode) {
        TreeSet locals = new TreeSet(new Comparator(){

            public int compare(Object o1, Object o2) {
                JavaLocalDeclarationDescr d1 = (JavaLocalDeclarationDescr)o1;
                JavaLocalDeclarationDescr d2 = (JavaLocalDeclarationDescr)o2;
                return d1.getStart() - d2.getStart();
            }
        });
        Iterator it = analysis.getLocalVariablesMap().values().iterator();
        while (it.hasNext()) {
            locals.add(it.next());
        }
        StringBuffer initCode = new StringBuffer();
        int lastAdded = 0;
        Iterator it2 = locals.iterator();
        while (it2.hasNext()) {
            JavaLocalDeclarationDescr d = (JavaLocalDeclarationDescr)it2.next();
            initCode.append(originalCode.substring(lastAdded, d.getStart()));
            lastAdded = d.getEnd();
            Iterator vars = d.getIdentifiers().iterator();
            while (vars.hasNext()) {
                JavaLocalDeclarationDescr.IdentifierDescr id = (JavaLocalDeclarationDescr.IdentifierDescr)vars.next();
                initCode.append(originalCode.substring(id.getStart(), id.getEnd()));
                initCode.append(";");
                for (lastAdded = id.getEnd(); lastAdded < originalCode.length() && (Character.isWhitespace(originalCode.charAt(lastAdded)) || originalCode.charAt(lastAdded) == ';'); ++lastAdded) {
                }
            }
        }
        initCode.append(originalCode.substring(lastAdded));
        return initCode.toString();
    }
}

