/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder.dialect.java;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.drools.base.ClassFieldExtractorCache;
import org.drools.base.TypeResolver;
import org.drools.commons.jci.compilers.CompilationResult;
import org.drools.commons.jci.compilers.JavaCompiler;
import org.drools.commons.jci.compilers.JavaCompilerFactory;
import org.drools.commons.jci.compilers.JavaCompilerSettings;
import org.drools.commons.jci.problems.CompilationProblem;
import org.drools.commons.jci.readers.MemoryResourceReader;
import org.drools.commons.jci.readers.ResourceReader;
import org.drools.compiler.Dialect;
import org.drools.compiler.PackageBuilder;
import org.drools.compiler.RuleError;
import org.drools.lang.descr.AccumulateDescr;
import org.drools.lang.descr.AndDescr;
import org.drools.lang.descr.BaseDescr;
import org.drools.lang.descr.CollectDescr;
import org.drools.lang.descr.EvalDescr;
import org.drools.lang.descr.ExistsDescr;
import org.drools.lang.descr.ForallDescr;
import org.drools.lang.descr.FromDescr;
import org.drools.lang.descr.FunctionDescr;
import org.drools.lang.descr.NotDescr;
import org.drools.lang.descr.OrDescr;
import org.drools.lang.descr.PatternDescr;
import org.drools.lang.descr.QueryDescr;
import org.drools.lang.descr.RuleDescr;
import org.drools.rule.LineMappings;
import org.drools.rule.Package;
import org.drools.rule.Rule;
import org.drools.rule.builder.AccumulateBuilder;
import org.drools.rule.builder.CollectBuilder;
import org.drools.rule.builder.ConsequenceBuilder;
import org.drools.rule.builder.ForallBuilder;
import org.drools.rule.builder.FromBuilder;
import org.drools.rule.builder.FunctionBuilder;
import org.drools.rule.builder.GroupElementBuilder;
import org.drools.rule.builder.PatternBuilder;
import org.drools.rule.builder.PredicateBuilder;
import org.drools.rule.builder.QueryBuilder;
import org.drools.rule.builder.ReturnValueBuilder;
import org.drools.rule.builder.RuleBuildContext;
import org.drools.rule.builder.RuleClassBuilder;
import org.drools.rule.builder.RuleConditionBuilder;
import org.drools.rule.builder.SalienceBuilder;
import org.drools.rule.builder.dialect.java.DeclarationTypeFixer;
import org.drools.rule.builder.dialect.java.JavaAccumulateBuilder;
import org.drools.rule.builder.dialect.java.JavaAnalysisResult;
import org.drools.rule.builder.dialect.java.JavaConsequenceBuilder;
import org.drools.rule.builder.dialect.java.JavaDialectConfiguration;
import org.drools.rule.builder.dialect.java.JavaEvalBuilder;
import org.drools.rule.builder.dialect.java.JavaExprAnalyzer;
import org.drools.rule.builder.dialect.java.JavaFunctionBuilder;
import org.drools.rule.builder.dialect.java.JavaPredicateBuilder;
import org.drools.rule.builder.dialect.java.JavaReturnValueBuilder;
import org.drools.rule.builder.dialect.java.JavaRuleClassBuilder;
import org.drools.rule.builder.dialect.java.KnowledgeHelperFixer;
import org.drools.rule.builder.dialect.java.PackageStore;
import org.drools.rule.builder.dialect.mvel.MVELFromBuilder;
import org.drools.rule.builder.dialect.mvel.MVELSalienceBuilder;
import org.drools.util.StringUtils;

public class JavaDialect
implements Dialect {
    public static final String ID = "JavaDialect";
    private static final String EXPRESSION_DIALECT_NAME = "MVEL";
    private final PatternBuilder pattern = new PatternBuilder();
    private final QueryBuilder query = new QueryBuilder();
    private final SalienceBuilder salience = new MVELSalienceBuilder();
    private final JavaAccumulateBuilder accumulate = new JavaAccumulateBuilder();
    private final JavaEvalBuilder eval = new JavaEvalBuilder();
    private final JavaPredicateBuilder predicate = new JavaPredicateBuilder();
    private final JavaReturnValueBuilder returnValue = new JavaReturnValueBuilder();
    private final JavaConsequenceBuilder consequence = new JavaConsequenceBuilder();
    private final JavaRuleClassBuilder rule = new JavaRuleClassBuilder();
    private final MVELFromBuilder from = new MVELFromBuilder();
    private final JavaFunctionBuilder function = new JavaFunctionBuilder();
    private final CollectBuilder collect = new CollectBuilder();
    private final ForallBuilder forall = new ForallBuilder();
    private KnowledgeHelperFixer knowledgeHelperFixer;
    private DeclarationTypeFixer typeFixer;
    private JavaExprAnalyzer analyzer;
    private JavaDialectConfiguration configuration;
    private Package pkg;
    private JavaCompiler compiler;
    private List generatedClassList;
    private MemoryResourceReader src;
    private PackageStore packageStoreWrapper;
    private Map errorHandlers;
    private List results;
    private String ruleClass;
    private TypeResolver typeResolver;
    private ClassFieldExtractorCache classFieldExtractorCache;
    private Map builders;

    public void init(PackageBuilder builder) {
        this.pkg = builder.getPackage();
        this.configuration = (JavaDialectConfiguration)builder.getPackageBuilderConfiguration().getDialectConfiguration("java");
        this.typeResolver = builder.getTypeResolver();
        this.classFieldExtractorCache = builder.getClassFieldExtractorCache();
        this.knowledgeHelperFixer = new KnowledgeHelperFixer();
        this.typeFixer = new DeclarationTypeFixer();
        this.analyzer = new JavaExprAnalyzer();
        if (this.pkg != null) {
            this.init(this.pkg);
        }
        this.initBuilder();
        this.loadCompiler();
    }

    public void initBuilder() {
        this.builders = new HashMap();
        this.builders.put(CollectDescr.class, this.collect);
        this.builders.put(ForallDescr.class, this.forall);
        GroupElementBuilder gebuilder = new GroupElementBuilder();
        this.builders.put(AndDescr.class, gebuilder);
        this.builders.put(OrDescr.class, gebuilder);
        this.builders.put(NotDescr.class, gebuilder);
        this.builders.put(ExistsDescr.class, gebuilder);
        this.builders.put(PatternDescr.class, this.getPatternBuilder());
        this.builders.put(QueryDescr.class, this.getQueryBuilder());
        this.builders.put(FromDescr.class, this.getFromBuilder());
        this.builders.put(AccumulateDescr.class, this.getAccumulateBuilder());
        this.builders.put(EvalDescr.class, this.getEvalBuilder());
    }

    public Map getBuilders() {
        return this.builders;
    }

    public void init(Package pkg) {
        this.pkg = pkg;
        this.errorHandlers = new HashMap();
        this.results = new ArrayList();
        this.src = new MemoryResourceReader();
        this.generatedClassList = new ArrayList();
        this.packageStoreWrapper = new PackageStore(pkg.getPackageCompilationData(), this.results);
    }

    public void init(RuleDescr ruleDescr) {
        String ruleClassName = JavaDialect.getUniqueLegalName(this.pkg.getName(), ruleDescr.getName(), "java", this.src);
        ruleDescr.setClassName(StringUtils.ucFirst((String)ruleClassName));
        ruleDescr.setDialect(this);
    }

    public void setRuleClass(String ruleClass) {
        this.ruleClass = ruleClass;
    }

    public String getExpressionDialectName() {
        return EXPRESSION_DIALECT_NAME;
    }

    public Dialect.AnalysisResult analyzeExpression(RuleBuildContext context, BaseDescr descr, Object content) {
        JavaAnalysisResult result = null;
        try {
            result = this.analyzer.analyzeExpression((String)content, new Set[]{context.getDeclarationResolver().getDeclarations().keySet(), context.getPkg().getGlobals().keySet()});
        }
        catch (Exception e) {
            context.getErrors().add(new RuleError(context.getRule(), descr, e, "Unable to determine the used declarations.\n" + e));
        }
        return result;
    }

    public Dialect.AnalysisResult analyzeBlock(RuleBuildContext context, BaseDescr descr, String text) {
        JavaAnalysisResult result = null;
        try {
            result = this.analyzer.analyzeBlock(text, new Set[]{context.getDeclarationResolver().getDeclarations().keySet(), context.getPkg().getGlobals().keySet()});
        }
        catch (Exception e) {
            context.getErrors().add(new RuleError(context.getRule(), descr, e, "Unable to determine the used declarations.\n" + e));
        }
        return result;
    }

    public TypeResolver getTypeResolver() {
        return this.typeResolver;
    }

    public ClassFieldExtractorCache getClassFieldExtractorCache() {
        return this.classFieldExtractorCache;
    }

    public KnowledgeHelperFixer getKnowledgeHelperFixer() {
        return this.knowledgeHelperFixer;
    }

    public DeclarationTypeFixer getTypeFixer() {
        return this.typeFixer;
    }

    public RuleConditionBuilder getBuilder(Class clazz) {
        return (RuleConditionBuilder)this.builders.get(clazz);
    }

    public PatternBuilder getPatternBuilder() {
        return this.pattern;
    }

    public QueryBuilder getQueryBuilder() {
        return this.query;
    }

    public SalienceBuilder getSalienceBuilder() {
        return this.salience;
    }

    public AccumulateBuilder getAccumulateBuilder() {
        return this.accumulate;
    }

    public RuleConditionBuilder getEvalBuilder() {
        return this.eval;
    }

    public PredicateBuilder getPredicateBuilder() {
        return this.predicate;
    }

    public ReturnValueBuilder getReturnValueBuilder() {
        return this.returnValue;
    }

    public ConsequenceBuilder getConsequenceBuilder() {
        return this.consequence;
    }

    public RuleClassBuilder getRuleClassBuilder() {
        return this.rule;
    }

    public FunctionBuilder getFunctionBuilder() {
        return this.function;
    }

    public FromBuilder getFromBuilder() {
        return this.from;
    }

    public void compileAll() {
        if (this.generatedClassList.isEmpty()) {
            return;
        }
        String[] classes = new String[this.generatedClassList.size()];
        this.generatedClassList.toArray(classes);
        CompilationResult result = this.compiler.compile(classes, this.src, this.packageStoreWrapper, this.pkg.getPackageCompilationData().getClassLoader());
        if (result.getErrors().length > 0) {
            PackageBuilder.ErrorHandler handler;
            for (int i = 0; i < result.getErrors().length; ++i) {
                CompilationProblem err = result.getErrors()[i];
                handler = (PackageBuilder.ErrorHandler)this.errorHandlers.get(err.getFileName());
                if (handler instanceof PackageBuilder.RuleErrorHandler) {
                    PackageBuilder.RuleErrorHandler rh = (PackageBuilder.RuleErrorHandler)handler;
                }
                handler.addError(err);
            }
            Collection errors = this.errorHandlers.values();
            Iterator iter = errors.iterator();
            while (iter.hasNext()) {
                handler = (PackageBuilder.ErrorHandler)iter.next();
                if (!handler.isInError() || handler instanceof PackageBuilder.RuleInvokerErrorHandler) continue;
                this.results.add(handler.getError());
            }
        }
        this.generatedClassList.clear();
    }

    public void addRule(RuleBuildContext context) {
        if (this.ruleClass == null) {
            return;
        }
        Rule rule = context.getRule();
        RuleDescr ruleDescr = context.getRuleDescr();
        this.addClassCompileTask(this.pkg.getName() + "." + ruleDescr.getClassName(), ruleDescr, this.ruleClass, this.src, new PackageBuilder.RuleErrorHandler(ruleDescr, rule, "Rule Compilation error"));
        Iterator it = context.getInvokers().keySet().iterator();
        while (it.hasNext()) {
            String className = (String)it.next();
            Object invoker = context.getInvokerLookups().get(className);
            if (invoker != null) {
                this.pkg.getPackageCompilationData().putInvoker(className, invoker);
            }
            String text = (String)context.getInvokers().get(className);
            BaseDescr descr = (BaseDescr)context.getDescrLookups().get(className);
            this.addClassCompileTask(className, descr, text, this.src, new PackageBuilder.RuleInvokerErrorHandler(descr, rule, "Unable to generate rule invoker."));
        }
        String name = this.pkg.getName() + "." + StringUtils.ucFirst((String)ruleDescr.getClassName());
        LineMappings mapping = new LineMappings(name);
        mapping.setStartLine(ruleDescr.getConsequenceLine());
        mapping.setOffset(ruleDescr.getConsequenceOffset());
        context.getPkg().getPackageCompilationData().getLineMappings().put(name, mapping);
    }

    public void addFunction(FunctionDescr functionDescr, TypeResolver typeResolver) {
        String functionClassName = this.pkg.getName() + "." + StringUtils.ucFirst((String)functionDescr.getName());
        this.pkg.addFunction(functionDescr.getName());
        String functionSrc = this.getFunctionBuilder().build(this.pkg, functionDescr, typeResolver, this.pkg.getPackageCompilationData().getLineMappings(), this.results);
        this.addClassCompileTask(functionClassName, functionDescr, functionSrc, this.src, new PackageBuilder.FunctionErrorHandler(functionDescr, "Function Compilation error"));
        LineMappings mapping = new LineMappings(functionClassName);
        mapping.setStartLine(functionDescr.getLine());
        mapping.setOffset(functionDescr.getOffset());
        this.pkg.getPackageCompilationData().getLineMappings().put(functionClassName, mapping);
    }

    private void addClassCompileTask(String className, BaseDescr descr, String text, MemoryResourceReader src, PackageBuilder.ErrorHandler handler) {
        String fileName = className.replace('.', '/') + ".java";
        src.add(fileName, text.getBytes());
        this.errorHandlers.put(fileName, handler);
        this.addClassName(fileName);
    }

    public void addClassName(String className) {
        this.generatedClassList.add(className);
    }

    private void loadCompiler() {
        switch (this.configuration.getCompiler()) {
            case 1: {
                this.compiler = JavaCompilerFactory.getInstance().createCompiler("janino");
                break;
            }
            default: {
                this.compiler = JavaCompilerFactory.getInstance().createCompiler("eclipse");
                JavaCompilerSettings settings = this.compiler.createDefaultSettings();
                String lngLevel = this.configuration.getJavaLanguageLevel();
                settings.setTargetVersion(lngLevel);
                if (lngLevel == "1.4") {
                    lngLevel = "1.5";
                }
                settings.setSourceVersion(lngLevel);
                break;
            }
        }
    }

    public void addImport(String importEntry) {
    }

    public void addStaticImport(String staticImportEntry) {
    }

    public List getResults() {
        return this.results;
    }

    public static String getUniqueLegalName(String packageName, String name, String ext, ResourceReader src) {
        String newName = "Rule_" + name.replaceAll("[[^\\w]$]", "_");
        int counter = -1;
        boolean exists = true;
        while (exists) {
            String fileName = packageName.replaceAll("\\.", "/") + newName + "_" + ++counter + ext;
            exists = src != null && src.isAvailable(fileName);
        }
        if (counter >= 0) {
            newName = newName + "_" + counter;
        }
        return newName;
    }

    public String getId() {
        return ID;
    }
}

