/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder.dialect.mvel;

import java.io.Serializable;
import java.util.ArrayList;
import org.drools.base.accumulators.AccumulateFunction;
import org.drools.base.accumulators.MVELAccumulatorFunctionExecutor;
import org.drools.base.mvel.DroolsMVELFactory;
import org.drools.base.mvel.MVELAccumulator;
import org.drools.compiler.Dialect;
import org.drools.lang.descr.AccumulateDescr;
import org.drools.lang.descr.BaseDescr;
import org.drools.rule.Accumulate;
import org.drools.rule.Declaration;
import org.drools.rule.Pattern;
import org.drools.rule.RuleConditionElement;
import org.drools.rule.builder.AccumulateBuilder;
import org.drools.rule.builder.RuleBuildContext;
import org.drools.rule.builder.RuleConditionBuilder;
import org.drools.rule.builder.dialect.mvel.MVELAnalysisResult;
import org.drools.rule.builder.dialect.mvel.MVELDialect;
import org.drools.spi.Accumulator;

public class MVELAccumulateBuilder
implements AccumulateBuilder {
    public RuleConditionElement build(RuleBuildContext context, BaseDescr descr) {
        return this.build(context, descr, null);
    }

    public RuleConditionElement build(RuleBuildContext context, BaseDescr descr, Pattern prefixPattern) {
        AccumulateDescr accumDescr = (AccumulateDescr)descr;
        if (!accumDescr.hasValidInput()) {
            return null;
        }
        RuleConditionBuilder builder = context.getDialect().getBuilder(accumDescr.getInput().getClass());
        RuleConditionElement source = builder.build(context, accumDescr.getInput());
        if (source == null) {
            return null;
        }
        MVELDialect dialect = (MVELDialect)context.getDialect();
        Declaration[] sourceDeclArr = source.getOuterDeclarations().values().toArray(new Declaration[0]);
        DroolsMVELFactory factory = new DroolsMVELFactory(context.getDeclarationResolver().getDeclarations(), source.getOuterDeclarations(), context.getPkg().getGlobals());
        MVELAccumulatorFunctionExecutor accumulator = null;
        Declaration[] declarations = null;
        if (accumDescr.isExternalFunction()) {
            Dialect.AnalysisResult analysis = dialect.analyzeExpression(context, accumDescr, accumDescr.getExpression());
            int size = analysis.getBoundIdentifiers()[0].size();
            declarations = new Declaration[size];
            for (int i = 0; i < size; ++i) {
                declarations[i] = context.getDeclarationResolver().getDeclaration((String)analysis.getBoundIdentifiers()[0].get(i));
            }
            Serializable expression = dialect.compile(accumDescr.getExpression(), analysis, null, source.getOuterDeclarations(), null, context);
            AccumulateFunction function = context.getConfiguration().getAccumulateFunction(accumDescr.getFunctionIdentifier());
            accumulator = new MVELAccumulatorFunctionExecutor(factory, expression, function);
        } else {
            MVELAnalysisResult initCodeAnalysis = (MVELAnalysisResult)dialect.analyzeBlock(context, accumDescr, accumDescr.getInitCode());
            MVELAnalysisResult actionCodeAnalysis = (MVELAnalysisResult)dialect.analyzeBlock(context, accumDescr, null, accumDescr.getActionCode(), initCodeAnalysis.getMvelVariables());
            MVELAnalysisResult resultCodeAnalysis = (MVELAnalysisResult)dialect.analyzeExpression(context, accumDescr, accumDescr.getResultCode(), initCodeAnalysis.getMvelVariables());
            ArrayList requiredDeclarations = new ArrayList(initCodeAnalysis.getBoundIdentifiers()[0]);
            requiredDeclarations.addAll(actionCodeAnalysis.getBoundIdentifiers()[0]);
            requiredDeclarations.addAll(resultCodeAnalysis.getBoundIdentifiers()[0]);
            if (accumDescr.getReverseCode() != null) {
                Dialect.AnalysisResult reverseCodeAnalysis = context.getDialect().analyzeBlock(context, accumDescr, accumDescr.getActionCode());
                requiredDeclarations.addAll(reverseCodeAnalysis.getBoundIdentifiers()[0]);
            }
            declarations = new Declaration[requiredDeclarations.size()];
            int size = requiredDeclarations.size();
            for (int i = 0; i < size; ++i) {
                declarations[i] = context.getDeclarationResolver().getDeclaration((String)requiredDeclarations.get(i));
            }
            Serializable init = dialect.compile(accumDescr.getInitCode(), initCodeAnalysis, null, source.getOuterDeclarations(), null, context);
            Serializable action = dialect.compile(accumDescr.getActionCode(), actionCodeAnalysis, null, source.getOuterDeclarations(), initCodeAnalysis.getMvelVariables(), context);
            Serializable reverse = null;
            if (accumDescr.getReverseCode() != null) {
                reverse = dialect.compile(accumDescr.getReverseCode(), resultCodeAnalysis, null, source.getOuterDeclarations(), initCodeAnalysis.getMvelVariables(), context);
            }
            Serializable result = dialect.compile(accumDescr.getResultCode(), resultCodeAnalysis, null, source.getOuterDeclarations(), initCodeAnalysis.getMvelVariables(), context);
            accumulator = new MVELAccumulator(factory, init, action, reverse, result);
        }
        Accumulate accumulate = new Accumulate(source, declarations, sourceDeclArr, (Accumulator)accumulator);
        return accumulate;
    }
}

