/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.drools.RuleBaseConfiguration;
import org.drools.RuntimeDroolsException;
import org.drools.base.evaluators.EvaluatorRegistry;
import org.drools.builder.KnowledgeBuilderConfiguration;
import org.drools.builder.conf.AccumulateFunctionOption;
import org.drools.builder.conf.DefaultDialectOption;
import org.drools.builder.conf.DumpDirOption;
import org.drools.builder.conf.EvaluatorOption;
import org.drools.builder.conf.KnowledgeBuilderOption;
import org.drools.builder.conf.MultiValueKnowledgeBuilderOption;
import org.drools.builder.conf.ProcessStringEscapesOption;
import org.drools.builder.conf.SingleValueKnowledgeBuilderOption;
import org.drools.compiler.Dialect;
import org.drools.compiler.DialectCompiletimeRegistry;
import org.drools.compiler.DialectConfiguration;
import org.drools.compiler.PackageBuilder;
import org.drools.compiler.PackageRegistry;
import org.drools.process.builder.ProcessNodeBuilder;
import org.drools.process.builder.ProcessNodeBuilderRegistry;
import org.drools.rule.Package;
import org.drools.runtime.rule.AccumulateFunction;
import org.drools.runtime.rule.EvaluatorDefinition;
import org.drools.util.ChainedProperties;
import org.drools.util.ClassUtils;
import org.drools.util.ConfFileUtils;
import org.drools.util.StringUtils;
import org.drools.xml.ChangeSetSemanticModule;
import org.drools.xml.DefaultSemanticModule;
import org.drools.xml.Handler;
import org.drools.xml.ProcessSemanticModule;
import org.drools.xml.RulesSemanticModule;
import org.drools.xml.SemanticModule;
import org.drools.xml.SemanticModules;
import org.mvel2.MVEL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageBuilderConfiguration
implements KnowledgeBuilderConfiguration {
    private Map dialectConfigurations;
    private DefaultDialectOption defaultDialect;
    private ClassLoader classLoader;
    private ChainedProperties chainedProperties;
    private Map<String, AccumulateFunction> accumulateFunctions;
    private EvaluatorRegistry evaluatorRegistry;
    private SemanticModules semanticModules;
    private ProcessNodeBuilderRegistry nodeBuilderRegistry;
    private File dumpDirectory;
    private boolean allowMultipleNamespaces = true;
    private boolean processStringEscapes = true;

    public boolean isAllowMultipleNamespaces() {
        return this.allowMultipleNamespaces;
    }

    public void setAllowMultipleNamespaces(boolean allowMultipleNamespaces) {
        this.allowMultipleNamespaces = allowMultipleNamespaces;
    }

    public PackageBuilderConfiguration(ClassLoader classLoader) {
        this.init(classLoader, null);
    }

    public PackageBuilderConfiguration(Properties properties) {
        this.init(null, properties);
    }

    public PackageBuilderConfiguration(ClassLoader classLoader, Properties properties) {
        this.init(classLoader, properties);
    }

    public PackageBuilderConfiguration() {
        this.init(null, null);
    }

    private void init(ClassLoader classLoader, Properties properties) {
        if (classLoader == null && (classLoader = Thread.currentThread().getContextClassLoader()) == null) {
            classLoader = this.getClass().getClassLoader();
        }
        this.setClassLoader(classLoader);
        this.chainedProperties = new ChainedProperties(this.classLoader, "packagebuilder.conf");
        if (properties != null) {
            this.chainedProperties.addProperties(properties);
        }
        this.dialectConfigurations = new HashMap();
        this.buildDialectConfigurationMap();
        this.buildAccumulateFunctionsMap();
        this.buildEvaluatorRegistry();
        this.buildDumpDirectory();
        this.setProperty("drools.parser.processStringEscapes", this.chainedProperties.getProperty("drools.parser.processStringEscapes", "true"));
    }

    public void setProperty(String name, String value) {
        if (StringUtils.isEmpty((CharSequence)(name = name.trim()))) {
            return;
        }
        if (name.equals("drools.dialect.default")) {
            this.setDefaultDialect(value);
        } else if (name.startsWith("drools.accumulate.function.")) {
            this.addAccumulateFunction(name.substring("drools.accumulate.function.".length()), value);
        } else if (name.startsWith("drools.evaluator.")) {
            this.evaluatorRegistry.addEvaluatorDefinition(value);
        } else if (name.equals("drools.dump.dir")) {
            this.buildDumpDirectory(value);
        } else if (name.equals("drools.parser.processStringEscapes")) {
            this.setProcessStringEscapes(Boolean.parseBoolean(value));
        }
    }

    public String getProperty(String name) {
        if (StringUtils.isEmpty((CharSequence)(name = name.trim()))) {
            return null;
        }
        if (name.equals("drools.dialect.default")) {
            return this.getDefaultDialect();
        }
        if (name.startsWith("drools.accumulate.function.")) {
            int index = "drools.accumulate.function.".length();
            AccumulateFunction function = this.accumulateFunctions.get(name.substring(index));
            return function != null ? function.getClass().getName() : null;
        }
        if (name.startsWith("drools.evaluator.")) {
            String key = name.substring(name.lastIndexOf(46) + 1);
            org.drools.base.evaluators.EvaluatorDefinition evalDef = this.evaluatorRegistry.getEvaluatorDefinition(key);
            return evalDef != null ? evalDef.getClass().getName() : null;
        }
        if (name.equals("drools.dump.dir")) {
            return this.dumpDirectory != null ? this.dumpDirectory.toString() : null;
        }
        if (name.equals("drools.parser.processStringEscapes")) {
            return String.valueOf(this.isProcessStringEscapes());
        }
        return null;
    }

    public ChainedProperties getChainedProperties() {
        return this.chainedProperties;
    }

    private void buildDialectConfigurationMap() {
        HashMap dialectProperties = new HashMap();
        this.chainedProperties.mapStartsWith(dialectProperties, "drools.dialect", false);
        this.setDefaultDialect((String)dialectProperties.remove("drools.dialect.default"));
        for (Map.Entry entry : dialectProperties.entrySet()) {
            String str = (String)entry.getKey();
            String dialectName = str.substring(str.lastIndexOf(".") + 1);
            String dialectClass = (String)entry.getValue();
            this.addDialect(dialectName, dialectClass);
        }
    }

    public void addDialect(String dialectName, String dialectClass) {
        Class<?> cls = null;
        try {
            cls = this.classLoader.loadClass(dialectClass);
            DialectConfiguration dialectConf = (DialectConfiguration)cls.newInstance();
            dialectConf.init(this);
            this.addDialect(dialectName, dialectConf);
        }
        catch (Exception e) {
            throw new RuntimeDroolsException("Unable to load dialect '" + dialectClass + ":" + dialectName + ":" + (cls != null ? cls.getName() : "null") + "'", (Throwable)e);
        }
    }

    public void addDialect(String dialectName, DialectConfiguration dialectConf) {
        this.dialectConfigurations.put(dialectName, dialectConf);
    }

    public DialectCompiletimeRegistry buildDialectRegistry(PackageBuilder packageBuilder, PackageRegistry pkgRegistry, Package pkg) {
        DialectCompiletimeRegistry registry = new DialectCompiletimeRegistry(pkg);
        for (DialectConfiguration conf : this.dialectConfigurations.values()) {
            Dialect dialect = conf.newDialect(packageBuilder, pkgRegistry, pkg);
            registry.addDialect(dialect.getId(), dialect);
        }
        return registry;
    }

    public String getDefaultDialect() {
        return this.defaultDialect.getName();
    }

    public void setDefaultDialect(String defaultDialect) {
        this.defaultDialect = DefaultDialectOption.get((String)defaultDialect);
    }

    public DialectConfiguration getDialectConfiguration(String name) {
        return (DialectConfiguration)this.dialectConfigurations.get(name);
    }

    public void setDialectConfiguration(String name, DialectConfiguration configuration) {
        this.dialectConfigurations.put(name, configuration);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        if (classLoader != null) {
            this.classLoader = classLoader;
        }
    }

    public void addSemanticModule(SemanticModule module) {
        if (this.semanticModules == null) {
            this.initSemanticModules();
        }
        this.semanticModules.addSemanticModule(module);
    }

    public SemanticModules getSemanticModules() {
        if (this.semanticModules == null) {
            this.initSemanticModules();
        }
        return this.semanticModules;
    }

    public void initSemanticModules() {
        this.semanticModules = new SemanticModules();
        this.semanticModules.addSemanticModule((SemanticModule)new ProcessSemanticModule());
        this.semanticModules.addSemanticModule((SemanticModule)new RulesSemanticModule());
        this.semanticModules.addSemanticModule((SemanticModule)new ChangeSetSemanticModule());
        String[] locations = this.chainedProperties.getProperty("semanticModules", "").split("\\s");
        boolean i = false;
        for (String moduleLocation : locations) {
            if ((moduleLocation = moduleLocation.trim()).startsWith("\"")) {
                moduleLocation = moduleLocation.substring(1);
            }
            if (moduleLocation.endsWith("\"")) {
                moduleLocation = moduleLocation.substring(0, moduleLocation.length() - 1);
            }
            if (moduleLocation.equals("")) continue;
            this.loadSemanticModule(moduleLocation);
        }
    }

    public void loadSemanticModule(String moduleLocation) {
        URL url = ConfFileUtils.getURL((String)moduleLocation, (ClassLoader)this.classLoader, this.getClass());
        if (url == null) {
            throw new IllegalArgumentException(moduleLocation + " is specified but cannot be found.'");
        }
        Properties properties = ConfFileUtils.getProperties((URL)url);
        if (properties == null) {
            throw new IllegalArgumentException(moduleLocation + " is specified but cannot be found.'");
        }
        this.loadSemanticModule(properties);
    }

    public void loadSemanticModule(Properties properties) {
        String uri = properties.getProperty("uri", null);
        if (uri == null || uri.trim().equals("")) {
            throw new RuntimeException("Semantic Module URI property must not be empty");
        }
        DefaultSemanticModule module = new DefaultSemanticModule(uri);
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String elementName = (String)entry.getKey();
            if ("uri".equals(elementName)) continue;
            if (elementName == null || elementName.trim().equals("")) {
                throw new RuntimeException("Element name must be specified for Semantic Module handler");
            }
            String handlerName = (String)entry.getValue();
            if (handlerName == null || handlerName.trim().equals("")) {
                throw new RuntimeException("Handler name must be specified for Semantic Module");
            }
            Handler handler = (Handler)ClassUtils.instantiateObject((String)handlerName, (ClassLoader)this.classLoader);
            if (handler == null) {
                throw new RuntimeException("Unable to load Semantic Module handler '" + elementName + ":" + handlerName + "'");
            }
            module.addHandler(elementName, handler);
        }
        this.semanticModules.addSemanticModule((SemanticModule)module);
    }

    public ProcessNodeBuilderRegistry getProcessNodeBuilderRegistry() {
        if (this.nodeBuilderRegistry == null) {
            this.initProcessNodeBuilderRegistry();
        }
        return this.nodeBuilderRegistry;
    }

    private void initProcessNodeBuilderRegistry() {
        this.nodeBuilderRegistry = new ProcessNodeBuilderRegistry();
        String[] locations = this.chainedProperties.getProperty("processNodeBuilderRegistry", "").split("\\s");
        boolean i = false;
        for (String builderLocation : locations) {
            if ((builderLocation = builderLocation.trim()).startsWith("\"")) {
                builderLocation = builderLocation.substring(1);
            }
            if (builderLocation.endsWith("\"")) {
                builderLocation = builderLocation.substring(0, builderLocation.length() - 1);
            }
            if (builderLocation.equals("")) continue;
            this.loadProcessNodeBuilderRegistry(builderLocation);
        }
    }

    private void loadProcessNodeBuilderRegistry(String factoryLocation) {
        String content = ConfFileUtils.URLContentsToString((URL)ConfFileUtils.getURL((String)factoryLocation, null, RuleBaseConfiguration.class));
        Map map = (Map)MVEL.eval((String)content, new HashMap());
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                this.nodeBuilderRegistry.register((Class)entry.getKey(), (ProcessNodeBuilder)entry.getValue());
            }
        }
    }

    private void buildAccumulateFunctionsMap() {
        this.accumulateFunctions = new HashMap<String, AccumulateFunction>();
        HashMap temp = new HashMap();
        this.chainedProperties.mapStartsWith(temp, "drools.accumulate.function.", true);
        int index = "drools.accumulate.function.".length();
        for (Map.Entry entry : temp.entrySet()) {
            String identifier = ((String)entry.getKey()).trim().substring(index);
            this.accumulateFunctions.put(identifier, this.loadAccumulateFunction(identifier, (String)entry.getValue()));
        }
    }

    public Map<String, String> getAccumulateFunctionsMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, AccumulateFunction> entry : this.accumulateFunctions.entrySet()) {
            result.put(entry.getKey(), entry.getValue().getClass().getName());
        }
        return result;
    }

    public void addAccumulateFunction(String identifier, String className) {
        this.accumulateFunctions.put(identifier, this.loadAccumulateFunction(identifier, className));
    }

    public void addAccumulateFunction(String identifier, Class<? extends AccumulateFunction> clazz) {
        try {
            this.accumulateFunctions.put(identifier, clazz.newInstance());
        }
        catch (InstantiationException e) {
            throw new RuntimeDroolsException("Error loading accumulate function for identifier " + identifier + ". Instantiation failed for class " + clazz.getName(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeDroolsException("Error loading accumulate function for identifier " + identifier + ". Illegal access to class " + clazz.getName(), (Throwable)e);
        }
    }

    public AccumulateFunction getAccumulateFunction(String identifier) {
        return this.accumulateFunctions.get(identifier);
    }

    private AccumulateFunction loadAccumulateFunction(String identifier, String className) {
        try {
            Class<?> clazz = this.classLoader.loadClass(className);
            return (AccumulateFunction)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeDroolsException("Error loading accumulate function for identifier " + identifier + ". Class " + className + " not found", (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new RuntimeDroolsException("Error loading accumulate function for identifier " + identifier + ". Instantiation failed for class " + className, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeDroolsException("Error loading accumulate function for identifier " + identifier + ". Illegal access to class " + className, (Throwable)e);
        }
    }

    private void buildEvaluatorRegistry() {
        this.evaluatorRegistry = new EvaluatorRegistry(this.classLoader);
        HashMap temp = new HashMap();
        this.chainedProperties.mapStartsWith(temp, "drools.evaluator.", true);
        for (String className : temp.values()) {
            this.evaluatorRegistry.addEvaluatorDefinition(className);
        }
    }

    public EvaluatorRegistry getEvaluatorRegistry() {
        return this.evaluatorRegistry;
    }

    public void addEvaluatorDefinition(String className) {
        this.evaluatorRegistry.addEvaluatorDefinition(className);
    }

    public void addEvaluatorDefinition(org.drools.base.evaluators.EvaluatorDefinition def) {
        this.evaluatorRegistry.addEvaluatorDefinition(def);
    }

    private void buildDumpDirectory() {
        String dumpStr = this.chainedProperties.getProperty("drools.dump.dir", null);
        this.buildDumpDirectory(dumpStr);
    }

    private void buildDumpDirectory(String dumpStr) {
        if (dumpStr != null) {
            this.setDumpDir(new File(dumpStr));
        }
    }

    public File getDumpDir() {
        return this.dumpDirectory;
    }

    public void setDumpDir(File dumpDir) {
        if (!(dumpDir.isDirectory() && dumpDir.canWrite() && dumpDir.canRead())) {
            throw new RuntimeDroolsException("Drools dump directory is not accessible: " + dumpDir.toString());
        }
        this.dumpDirectory = dumpDir;
    }

    public boolean isProcessStringEscapes() {
        return this.processStringEscapes;
    }

    public void setProcessStringEscapes(boolean processStringEscapes) {
        this.processStringEscapes = processStringEscapes;
    }

    public <T extends SingleValueKnowledgeBuilderOption> T getOption(Class<T> option) {
        if (DefaultDialectOption.class.equals(option)) {
            return (T)this.defaultDialect;
        }
        if (DumpDirOption.class.equals(option)) {
            return (T)DumpDirOption.get((File)this.dumpDirectory);
        }
        if (ProcessStringEscapesOption.class.equals(option)) {
            return (T)(this.processStringEscapes ? ProcessStringEscapesOption.YES : ProcessStringEscapesOption.NO);
        }
        return null;
    }

    public <T extends MultiValueKnowledgeBuilderOption> T getOption(Class<T> option, String key) {
        if (AccumulateFunctionOption.class.equals(option)) {
            return (T)AccumulateFunctionOption.get((String)key, (AccumulateFunction)this.accumulateFunctions.get(key));
        }
        if (EvaluatorOption.class.equals(option)) {
            return (T)EvaluatorOption.get((String)key, (EvaluatorDefinition)this.evaluatorRegistry.getEvaluatorDefinition(key));
        }
        return null;
    }

    public <T extends KnowledgeBuilderOption> void setOption(T option) {
        if (option instanceof DefaultDialectOption) {
            this.defaultDialect = (DefaultDialectOption)option;
        } else if (option instanceof AccumulateFunctionOption) {
            this.accumulateFunctions.put(((AccumulateFunctionOption)option).getName(), ((AccumulateFunctionOption)option).getFunction());
        } else if (option instanceof DumpDirOption) {
            this.dumpDirectory = ((DumpDirOption)option).getDirectory();
        } else if (option instanceof EvaluatorOption) {
            this.evaluatorRegistry.addEvaluatorDefinition((org.drools.base.evaluators.EvaluatorDefinition)((EvaluatorOption)option).getEvaluatorDefinition());
        } else if (option instanceof ProcessStringEscapesOption) {
            this.processStringEscapes = ((ProcessStringEscapesOption)option).isProcessStringEscapes();
        }
    }
}

