/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.compiler.Dialect;
import org.drools.compiler.DialectCompiletimeRegistry;
import org.drools.compiler.DroolsError;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.PackageBuilder;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.compiler.PackageRegistry;
import org.drools.compiler.ParserError;
import org.drools.compiler.RuleFlowLoadError;
import org.drools.definition.process.Connection;
import org.drools.definition.process.Node;
import org.drools.definition.process.NodeContainer;
import org.drools.definition.process.Process;
import org.drools.definition.process.WorkflowProcess;
import org.drools.io.InternalResource;
import org.drools.io.Resource;
import org.drools.lang.descr.ActionDescr;
import org.drools.lang.descr.ProcessDescr;
import org.drools.process.builder.ProcessNodeBuilder;
import org.drools.process.builder.ProcessNodeBuilderRegistry;
import org.drools.process.core.Context;
import org.drools.process.core.ContextContainer;
import org.drools.process.core.ContextResolver;
import org.drools.process.core.context.exception.ActionExceptionHandler;
import org.drools.process.core.context.exception.ExceptionHandler;
import org.drools.process.core.context.exception.ExceptionScope;
import org.drools.process.core.impl.ProcessImpl;
import org.drools.process.core.validation.ProcessValidationError;
import org.drools.process.core.validation.ProcessValidator;
import org.drools.rule.builder.ProcessBuildContext;
import org.drools.ruleflow.core.validation.RuleFlowProcessValidator;
import org.drools.workflow.core.Constraint;
import org.drools.workflow.core.DroolsAction;
import org.drools.workflow.core.impl.DroolsConsequenceAction;
import org.drools.workflow.core.impl.WorkflowProcessImpl;
import org.drools.workflow.core.node.ConstraintTrigger;
import org.drools.workflow.core.node.MilestoneNode;
import org.drools.workflow.core.node.Split;
import org.drools.workflow.core.node.StartNode;
import org.drools.workflow.core.node.Trigger;
import org.drools.xml.XmlProcessReader;
import org.drools.xml.processes.RuleFlowMigrator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessBuilder {
    private PackageBuilder packageBuilder;
    private final List<DroolsError> errors = new ArrayList<DroolsError>();
    private Map<String, ProcessValidator> processValidators = new HashMap<String, ProcessValidator>();
    private static final String XSL_FROM_4_TO_5 = "/org/drools/xml/processes/RuleFlowFrom4To5.xsl";
    private static final String PROCESS_ELEMENT_WITH_NAMESPACE = "<process xmlns=\"http://drools.org/drools-5.0/process\"\n    xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n    xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n";

    public ProcessBuilder(PackageBuilder packageBuilder) {
        this.packageBuilder = packageBuilder;
        this.processValidators.put("RuleFlow", (ProcessValidator)RuleFlowProcessValidator.getInstance());
    }

    public List<DroolsError> getErrors() {
        return this.errors;
    }

    public void buildProcess(Process process, Resource resource) {
        if (resource != null && ((InternalResource)resource).hasURL()) {
            ((org.drools.process.core.Process)process).setResource(resource);
        }
        boolean hasErrors = false;
        ProcessValidator validator = this.processValidators.get(process.getType());
        if (validator == null) {
            System.out.println("Could not find validator for process " + process.getType() + ".");
            System.out.println("Continuing without validation of the process " + process.getName() + "[" + process.getId() + "]");
        } else {
            ProcessValidationError[] errors = validator.validateProcess((Process)((WorkflowProcess)process));
            if (errors.length != 0) {
                hasErrors = true;
                for (int i = 0; i < errors.length; ++i) {
                    this.errors.add(new ParserError(errors[i].toString(), -1, -1));
                }
            }
        }
        if (!hasErrors) {
            String rules = this.generateRules(process);
            try {
                this.packageBuilder.addPackageFromDrl(new StringReader(rules));
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
            }
            catch (DroolsParserException e) {
                e.printStackTrace(System.err);
            }
            if (this.packageBuilder.getPackage() != null) {
                ProcessDescr processDescr = new ProcessDescr();
                processDescr.setName(process.getPackageName());
                processDescr.setResource(resource);
                PackageRegistry pkgRegistry = this.packageBuilder.getPackageRegistry(this.packageBuilder.getPackage().getName());
                DialectCompiletimeRegistry dialectRegistry = pkgRegistry.getDialectCompiletimeRegistry();
                Dialect dialect = dialectRegistry.getDialect("java");
                dialect.init(processDescr);
                ProcessBuildContext buildContext = new ProcessBuildContext(this.packageBuilder, this.packageBuilder.getPackage(), process, processDescr, dialectRegistry, dialect);
                this.buildContexts((ContextContainer)process, buildContext);
                if (process instanceof WorkflowProcess) {
                    this.buildNodes((WorkflowProcess)process, buildContext);
                }
                this.packageBuilder.getPackage().addProcess(process);
                pkgRegistry.compileAll();
                pkgRegistry.getDialectRuntimeRegistry().onBeforeExecute();
            }
        }
    }

    public void buildContexts(ContextContainer contextContainer, ProcessBuildContext buildContext) {
        List exceptionScopes = contextContainer.getContexts("ExceptionScope");
        if (exceptionScopes != null) {
            for (Context context : exceptionScopes) {
                ExceptionScope exceptionScope = (ExceptionScope)context;
                for (ExceptionHandler exceptionHandler : exceptionScope.getExceptionHandlers().values()) {
                    if (!(exceptionHandler instanceof ActionExceptionHandler)) continue;
                    DroolsConsequenceAction action = (DroolsConsequenceAction)((ActionExceptionHandler)exceptionHandler).getAction();
                    ActionDescr actionDescr = new ActionDescr();
                    actionDescr.setText(action.getConsequence());
                    Dialect dialect = buildContext.getDialectRegistry().getDialect(action.getDialect());
                    dialect.getActionBuilder().build(buildContext, (DroolsAction)action, actionDescr, (ContextResolver)((ProcessImpl)buildContext.getProcess()));
                }
            }
        }
    }

    public void buildNodes(WorkflowProcess process, ProcessBuildContext context) {
        ProcessNodeBuilderRegistry nodeBuilderRegistry = this.packageBuilder.getPackageBuilderConfiguration().getProcessNodeBuilderRegistry();
        this.processNodes(process.getNodes(), (Process)process, context.getProcessDescr(), context, nodeBuilderRegistry);
        if (!context.getErrors().isEmpty()) {
            this.errors.addAll(context.getErrors());
        }
        context.getDialectRegistry().addProcess(context);
    }

    private void processNodes(Node[] nodes, Process process, ProcessDescr processDescr, ProcessBuildContext context, ProcessNodeBuilderRegistry nodeBuilderRegistry) {
        for (Node node : nodes) {
            ProcessNodeBuilder builder = nodeBuilderRegistry.getNodeBuilder(node);
            if (builder != null) {
                builder.build(process, processDescr, context, node);
            }
            if (node instanceof NodeContainer) {
                this.processNodes(((NodeContainer)node).getNodes(), process, processDescr, context, nodeBuilderRegistry);
            }
            if (!(node instanceof ContextContainer)) continue;
            this.buildContexts((ContextContainer)node, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProcessFromFile(Reader reader, Resource resource) throws Exception {
        PackageBuilderConfiguration configuration = this.packageBuilder.getPackageBuilderConfiguration();
        XmlProcessReader xmlReader = new XmlProcessReader(configuration.getSemanticModules());
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader newLoader = this.getClass().getClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(newLoader);
            String portRuleFlow = System.getProperty("drools.ruleflow.port", "false");
            Reader portedReader = null;
            portedReader = portRuleFlow.equalsIgnoreCase("true") ? this.portToCurrentVersion(reader) : reader;
            Process process = xmlReader.read(portedReader);
            if (process != null) {
                this.buildProcess(process, resource);
            } else {
                this.errors.add(new RuleFlowLoadError("unable to parse xml", null));
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
        reader.close();
    }

    private Reader portToCurrentVersion(Reader reader) throws Exception {
        String xml = RuleFlowMigrator.convertReaderToString(reader);
        if (RuleFlowMigrator.needToMigrateRFM(xml)) {
            xml = RuleFlowMigrator.portRFMToCurrentVersion(xml);
        } else if (RuleFlowMigrator.needToMigrateRF(xml)) {
            xml = RuleFlowMigrator.portRFMToCurrentVersion(xml);
        }
        return new StringReader(xml);
    }

    private String generateRules(Process process) {
        StringBuilder builder = new StringBuilder();
        if (process instanceof WorkflowProcessImpl) {
            Map globals;
            List functionImports;
            WorkflowProcessImpl ruleFlow = (WorkflowProcessImpl)process;
            builder.append("package " + ruleFlow.getPackageName() + "\n");
            List imports = ruleFlow.getImports();
            if (imports != null) {
                for (String importString : imports) {
                    builder.append("import " + importString + ";\n");
                }
            }
            if ((functionImports = ruleFlow.getFunctionImports()) != null) {
                for (String importString : functionImports) {
                    builder.append("import function " + importString + ";\n");
                }
            }
            if ((globals = ruleFlow.getGlobals()) != null) {
                for (Map.Entry entry : globals.entrySet()) {
                    builder.append("global " + (String)entry.getValue() + " " + (String)entry.getKey() + ";\n");
                }
            }
            Node[] nodes = ruleFlow.getNodes();
            for (int i = 0; i < nodes.length; ++i) {
                StartNode startNode;
                List triggers;
                if (nodes[i] instanceof Split) {
                    Split split = (Split)nodes[i];
                    if (split.getType() != 2 && split.getType() != 3) continue;
                    for (Connection connection : split.getDefaultOutgoingConnections()) {
                        Constraint constraint = split.getConstraint(connection);
                        if (!"rule".equals(constraint.getType())) continue;
                        builder.append(this.createSplitRule(process, connection, split.getConstraint(connection).getConstraint()));
                    }
                    continue;
                }
                if (nodes[i] instanceof MilestoneNode) {
                    MilestoneNode milestone = (MilestoneNode)nodes[i];
                    builder.append(this.createMilestoneRule(process, milestone));
                    continue;
                }
                if (!(nodes[i] instanceof StartNode) || (triggers = (startNode = (StartNode)nodes[i]).getTriggers()) == null) continue;
                for (Trigger trigger : triggers) {
                    if (!(trigger instanceof ConstraintTrigger)) continue;
                    builder.append(this.createStartConstraintRule(process, (ConstraintTrigger)trigger));
                }
            }
        }
        return builder.toString();
    }

    private String createSplitRule(Process process, Connection connection, String constraint) {
        return "rule \"RuleFlow-Split-" + process.getId() + "-" + connection.getFrom().getId() + "-" + connection.getTo().getId() + "\" \n" + "      ruleflow-group \"DROOLS_SYSTEM\" \n" + "    when \n" + "      " + constraint + "\n" + "    then \n" + "end \n\n";
    }

    private String createMilestoneRule(Process process, MilestoneNode milestone) {
        return "rule \"RuleFlow-Milestone-" + process.getId() + "-" + milestone.getId() + "\" \n" + "      ruleflow-group \"DROOLS_SYSTEM\" \n" + "    when \n" + "      " + milestone.getConstraint() + "\n" + "    then \n" + "end \n\n";
    }

    private String createStartConstraintRule(Process process, ConstraintTrigger trigger) {
        String result = "rule \"RuleFlow-Start-" + process.getId() + "\" \n" + "    when\n" + "        " + trigger.getConstraint() + "\n" + "    then\n";
        Map inMappings = trigger.getInMappings();
        if (inMappings != null && !inMappings.isEmpty()) {
            result = result + "        java.util.Map params = new java.util.HashMap();\n";
            for (Map.Entry entry : inMappings.entrySet()) {
                result = result + "        params.put(\"" + (String)entry.getKey() + "\", " + (String)entry.getValue() + ");\n";
            }
            result = result + "        drools.getWorkingMemory().startProcess(\"" + process.getId() + "\", params);\n" + "end\n\n";
        } else {
            result = result + "        drools.getWorkingMemory().startProcess(\"" + process.getId() + "\");\n" + "end\n\n";
        }
        return result;
    }
}

