/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.compiler.DescrBuildError;
import org.drools.compiler.Dialect;
import org.drools.compiler.DialectCompiletimeRegistry;
import org.drools.compiler.PackageBuilder;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.lang.descr.BaseDescr;
import org.drools.rule.Dialectable;
import org.drools.rule.Package;

public class PackageBuildContext {
    private Package pkg;
    private PackageBuilder pkgBuilder;
    private BaseDescr parentDescr;
    private List errors;
    private List methods;
    private Map invokers;
    private Map invokerLookups;
    private Map descrLookups;
    private int counter;
    private DialectCompiletimeRegistry dialectRegistry;
    private Dialect dialect;

    public void init(PackageBuilder pkgBuilder, Package pkg, BaseDescr parentDescr, DialectCompiletimeRegistry dialectRegistry, Dialect defaultDialect, Dialectable component) {
        this.pkgBuilder = pkgBuilder;
        this.pkg = pkg;
        this.parentDescr = parentDescr;
        this.methods = new ArrayList();
        this.invokers = new HashMap();
        this.invokerLookups = new HashMap();
        this.descrLookups = new HashMap();
        this.errors = new ArrayList();
        this.dialectRegistry = dialectRegistry;
        Dialect dialect = this.dialect = component != null && component.getDialect() != null ? this.dialectRegistry.getDialect(component.getDialect()) : defaultDialect;
        if (this.dialect == null && component != null && component.getDialect() != null) {
            this.errors.add(new DescrBuildError(null, parentDescr, component, "Unable to load Dialect '" + component.getDialect() + "'"));
        }
    }

    public BaseDescr getParentDescr() {
        return this.parentDescr;
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public void setDialect(Dialect dialect) {
        this.dialect = dialect;
    }

    public Dialect getDialect(String dialectName) {
        return this.dialectRegistry.getDialect(dialectName);
    }

    public DialectCompiletimeRegistry getDialectRegistry() {
        return this.dialectRegistry;
    }

    public List getErrors() {
        return this.errors;
    }

    public Package getPkg() {
        return this.pkg;
    }

    public Map getDescrLookups() {
        return this.descrLookups;
    }

    public void setDescrLookups(Map descrLookups) {
        this.descrLookups = descrLookups;
    }

    public Map getInvokerLookups() {
        return this.invokerLookups;
    }

    public void setInvokerLookups(Map invokerLookups) {
        this.invokerLookups = invokerLookups;
    }

    public Map getInvokers() {
        return this.invokers;
    }

    public void setInvokers(Map invokers) {
        this.invokers = invokers;
    }

    public List getMethods() {
        return this.methods;
    }

    public void setMethods(List methods) {
        this.methods = methods;
    }

    public int getCurrentId() {
        return this.counter;
    }

    public int getNextId() {
        return this.counter++;
    }

    public PackageBuilderConfiguration getConfiguration() {
        return this.pkgBuilder.getPackageBuilderConfiguration();
    }

    public PackageBuilder getPackageBuilder() {
        return this.pkgBuilder;
    }
}

