/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler;

import java.io.File;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.drools.RuleBaseConfiguration;
import org.drools.RuntimeDroolsException;
import org.drools.base.accumulators.AccumulateFunction;
import org.drools.base.evaluators.EvaluatorDefinition;
import org.drools.base.evaluators.EvaluatorRegistry;
import org.drools.builder.KnowledgeBuilderConfiguration;
import org.drools.compiler.Dialect;
import org.drools.compiler.DialectCompiletimeRegistry;
import org.drools.compiler.DialectConfiguration;
import org.drools.compiler.PackageBuilder;
import org.drools.compiler.PackageRegistry;
import org.drools.process.builder.ProcessNodeBuilder;
import org.drools.process.builder.ProcessNodeBuilderRegistry;
import org.drools.rule.Package;
import org.drools.util.ChainedProperties;
import org.drools.util.ClassUtils;
import org.drools.util.ConfFileUtils;
import org.drools.util.StringUtils;
import org.drools.xml.DefaultSemanticModule;
import org.drools.xml.Handler;
import org.drools.xml.ProcessSemanticModule;
import org.drools.xml.RulesSemanticModule;
import org.drools.xml.SemanticModule;
import org.drools.xml.SemanticModules;
import org.mvel2.MVEL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageBuilderConfiguration
implements KnowledgeBuilderConfiguration {
    private static final String ACCUMULATE_FUNCTION_PREFIX = "drools.accumulate.function.";
    private static final String EVALUATOR_DEFINITION_PREFIX = "drools.evaluator.";
    private static final String DROOLS_PARSER_PROCESS_STRING_ESCAPES = "drools.parser.processStringEscapes";
    private Map dialectConfigurations;
    private String defaultDialect;
    private ClassLoader classLoader;
    private ChainedProperties chainedProperties;
    private Map<String, String> accumulateFunctions;
    private EvaluatorRegistry evaluatorRegistry;
    private SemanticModules semanticModules;
    private ProcessNodeBuilderRegistry nodeBuilderRegistry;
    private File dumpDirectory;
    private boolean allowMultipleNamespaces = true;
    private boolean processStringEscapes = true;

    public boolean isAllowMultipleNamespaces() {
        return this.allowMultipleNamespaces;
    }

    public void setAllowMultipleNamespaces(boolean allowMultipleNamespaces) {
        this.allowMultipleNamespaces = allowMultipleNamespaces;
    }

    public PackageBuilderConfiguration(ClassLoader classLoader) {
        this.init(classLoader, null);
    }

    public PackageBuilderConfiguration(Properties properties) {
        this.init(null, properties);
    }

    public PackageBuilderConfiguration(ClassLoader classLoader, Properties properties) {
        this.init(classLoader, properties);
    }

    public PackageBuilderConfiguration() {
        this.init(null, null);
    }

    private void init(ClassLoader classLoader, Properties properties) {
        if (classLoader == null && (classLoader = Thread.currentThread().getContextClassLoader()) == null) {
            classLoader = this.getClass().getClassLoader();
        }
        this.setClassLoader(classLoader);
        this.chainedProperties = new ChainedProperties(this.classLoader, "packagebuilder.conf");
        if (properties != null) {
            this.chainedProperties.addProperties(properties);
        }
        this.dialectConfigurations = new HashMap();
        this.buildDialectConfigurationMap();
        this.buildAccumulateFunctionsMap();
        this.buildEvaluatorRegistry();
        this.buildDumpDirectory();
        this.setProperty(DROOLS_PARSER_PROCESS_STRING_ESCAPES, this.chainedProperties.getProperty(DROOLS_PARSER_PROCESS_STRING_ESCAPES, "true"));
    }

    public void setProperty(String name, String value) {
        if (StringUtils.isEmpty((String)(name = name.trim()))) {
            return;
        }
        if (name.equals("drools.dialect.default")) {
            this.setDefaultDialect(value);
        } else if (name.startsWith("drools.accumulate.function")) {
            this.addAccumulateFunction(name.substring(name.lastIndexOf(46)), value);
        } else if (name.startsWith(EVALUATOR_DEFINITION_PREFIX)) {
            this.evaluatorRegistry.addEvaluatorDefinition(value);
        } else if (name.equals("drools.dump.dir")) {
            this.buildDumpDirectory(value);
        } else if (name.equals(DROOLS_PARSER_PROCESS_STRING_ESCAPES)) {
            this.setProcessStringEscapes(Boolean.parseBoolean(value));
        }
    }

    public String getProperty(String name) {
        if (StringUtils.isEmpty((String)(name = name.trim()))) {
            return null;
        }
        if (name.equals("drools.dialect.default")) {
            return this.getDefaultDialect();
        }
        if (name.startsWith("drools.accumulate.function")) {
            return this.accumulateFunctions.get(name);
        }
        if (name.startsWith(EVALUATOR_DEFINITION_PREFIX)) {
            return this.evaluatorRegistry.getEvaluatorDefinition(name.substring(name.lastIndexOf(46))).getClass().getName();
        }
        if (name.equals("drools.dump.dir")) {
            return Boolean.toString(this.dumpDirectory != null);
        }
        if (name.equals(DROOLS_PARSER_PROCESS_STRING_ESCAPES)) {
            return String.valueOf(this.isProcessStringEscapes());
        }
        return null;
    }

    public ChainedProperties getChainedProperties() {
        return this.chainedProperties;
    }

    private void buildDialectConfigurationMap() {
        HashMap dialectProperties = new HashMap();
        this.chainedProperties.mapStartsWith(dialectProperties, "drools.dialect", false);
        this.setDefaultDialect((String)dialectProperties.remove("drools.dialect.default"));
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        for (Map.Entry entry : dialectProperties.entrySet()) {
            String str = (String)entry.getKey();
            String dialectName = str.substring(str.lastIndexOf(".") + 1);
            String dialectClass = (String)entry.getValue();
            this.addDialect(dialectName, dialectClass);
        }
    }

    public void addDialect(String dialectName, String dialectClass) {
        Class<?> cls = null;
        try {
            cls = this.classLoader.loadClass(dialectClass);
            DialectConfiguration dialectConf = (DialectConfiguration)cls.newInstance();
            dialectConf.init(this);
            this.addDialect(dialectName, dialectConf);
        }
        catch (Exception e) {
            throw new RuntimeDroolsException("Unable to load dialect '" + dialectClass + ":" + dialectName + ":" + (cls != null ? cls.getName() : "null") + "'", (Throwable)e);
        }
    }

    public void addDialect(String dialectName, DialectConfiguration dialectConf) {
        this.dialectConfigurations.put(dialectName, dialectConf);
    }

    public DialectCompiletimeRegistry buildDialectRegistry(PackageBuilder packageBuilder, PackageRegistry pkgRegistry, Package pkg) {
        DialectCompiletimeRegistry registry = new DialectCompiletimeRegistry(pkg);
        for (DialectConfiguration conf : this.dialectConfigurations.values()) {
            Dialect dialect = conf.newDialect(packageBuilder, pkgRegistry, pkg);
            registry.addDialect(dialect.getId(), dialect);
        }
        return registry;
    }

    public String getDefaultDialect() {
        return this.defaultDialect;
    }

    public void setDefaultDialect(String defaultDialect) {
        this.defaultDialect = defaultDialect;
    }

    public DialectConfiguration getDialectConfiguration(String name) {
        return (DialectConfiguration)this.dialectConfigurations.get(name);
    }

    public void setDialectConfiguration(String name, DialectConfiguration configuration) {
        this.dialectConfigurations.put(name, configuration);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        if (classLoader != null) {
            this.classLoader = classLoader;
        }
    }

    public void addSemanticModule(SemanticModule module) {
        if (this.semanticModules == null) {
            this.initSemanticModules();
        }
        this.semanticModules.addSemanticModule(module);
    }

    public SemanticModules getSemanticModules() {
        if (this.semanticModules == null) {
            this.initSemanticModules();
        }
        return this.semanticModules;
    }

    public void initSemanticModules() {
        this.semanticModules = new SemanticModules();
        this.semanticModules.addSemanticModule(new ProcessSemanticModule());
        this.semanticModules.addSemanticModule(new RulesSemanticModule());
        String[] locations = this.chainedProperties.getProperty("semanticModules", "").split("\\s");
        boolean i = false;
        for (String moduleLocation : locations) {
            if ((moduleLocation = moduleLocation.trim()).startsWith("\"")) {
                moduleLocation = moduleLocation.substring(1);
            }
            if (moduleLocation.endsWith("\"")) {
                moduleLocation = moduleLocation.substring(0, moduleLocation.length() - 1);
            }
            if (moduleLocation.equals("")) continue;
            this.loadSemanticModule(moduleLocation);
        }
    }

    public void loadSemanticModule(String moduleLocation) {
        URL url = ConfFileUtils.getURL((String)moduleLocation, (ClassLoader)this.classLoader, this.getClass());
        if (url == null) {
            throw new IllegalArgumentException(moduleLocation + " is specified but cannot be found.'");
        }
        Properties properties = ConfFileUtils.getProperties((URL)url);
        if (properties == null) {
            throw new IllegalArgumentException(moduleLocation + " is specified but cannot be found.'");
        }
        this.loadSemanticModule(properties);
    }

    public void loadSemanticModule(Properties properties) {
        String uri = properties.getProperty("uri", null);
        if (uri == null || uri.trim().equals("")) {
            throw new RuntimeException("Semantic Module URI property must not be empty");
        }
        DefaultSemanticModule module = new DefaultSemanticModule(uri);
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String elementName = (String)entry.getKey();
            if ("uri".equals(elementName)) continue;
            if (elementName == null || elementName.trim().equals("")) {
                throw new RuntimeException("Element name must be specified for Semantic Module handler");
            }
            String handlerName = (String)entry.getValue();
            if (handlerName == null || handlerName.trim().equals("")) {
                throw new RuntimeException("Handler name must be specified for Semantic Module");
            }
            Handler handler = (Handler)ClassUtils.instantiateObject((String)handlerName, (ClassLoader)this.classLoader);
            if (handler == null) {
                throw new RuntimeException("Unable to load Semantic Module handler '" + elementName + ":" + handlerName + "'");
            }
            module.addHandler(elementName, handler);
        }
        this.semanticModules.addSemanticModule(module);
    }

    public ProcessNodeBuilderRegistry getProcessNodeBuilderRegistry() {
        if (this.nodeBuilderRegistry == null) {
            this.initProcessNodeBuilderRegistry();
        }
        return this.nodeBuilderRegistry;
    }

    private void initProcessNodeBuilderRegistry() {
        this.nodeBuilderRegistry = new ProcessNodeBuilderRegistry();
        String[] locations = this.chainedProperties.getProperty("processNodeBuilderRegistry", "").split("\\s");
        boolean i = false;
        for (String builderLocation : locations) {
            if ((builderLocation = builderLocation.trim()).startsWith("\"")) {
                builderLocation = builderLocation.substring(1);
            }
            if (builderLocation.endsWith("\"")) {
                builderLocation = builderLocation.substring(0, builderLocation.length() - 1);
            }
            if (builderLocation.equals("")) continue;
            this.loadProcessNodeBuilderRegistry(builderLocation);
        }
    }

    private void loadProcessNodeBuilderRegistry(String factoryLocation) {
        String content = ConfFileUtils.URLContentsToString((URL)ConfFileUtils.getURL((String)factoryLocation, null, RuleBaseConfiguration.class));
        Map map = (Map)MVEL.eval((String)content, new HashMap());
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                this.nodeBuilderRegistry.register((Class)entry.getKey(), (ProcessNodeBuilder)entry.getValue());
            }
        }
    }

    private void buildAccumulateFunctionsMap() {
        this.accumulateFunctions = new HashMap<String, String>();
        HashMap temp = new HashMap();
        this.chainedProperties.mapStartsWith(temp, ACCUMULATE_FUNCTION_PREFIX, true);
        for (Map.Entry entry : temp.entrySet()) {
            String identifier = ((String)entry.getKey()).trim().substring(ACCUMULATE_FUNCTION_PREFIX.length());
            this.accumulateFunctions.put(identifier, (String)entry.getValue());
        }
    }

    public Map<String, String> getAccumulateFunctionsMap() {
        return Collections.unmodifiableMap(this.accumulateFunctions);
    }

    public void addAccumulateFunction(String identifier, String className) {
        this.accumulateFunctions.put(identifier, className);
    }

    public void addAccumulateFunction(String identifier, Class clazz) {
        this.accumulateFunctions.put(identifier, clazz.getName());
    }

    public AccumulateFunction getAccumulateFunction(String identifier) {
        String className = this.accumulateFunctions.get(identifier);
        if (className == null) {
            throw new RuntimeDroolsException("No accumulator function found for identifier: " + identifier);
        }
        try {
            Class<?> clazz = this.classLoader.loadClass(className);
            return (AccumulateFunction)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeDroolsException("Error loading accumulator function for identifier " + identifier + ". Class " + className + " not found", (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new RuntimeDroolsException("Error loading accumulator function for identifier " + identifier + ". Instantiation failed for class " + className, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeDroolsException("Error loading accumulator function for identifier " + identifier + ". Illegal access to class " + className, (Throwable)e);
        }
    }

    private void buildEvaluatorRegistry() {
        this.evaluatorRegistry = new EvaluatorRegistry(this.classLoader);
        HashMap temp = new HashMap();
        this.chainedProperties.mapStartsWith(temp, EVALUATOR_DEFINITION_PREFIX, true);
        for (String className : temp.values()) {
            this.evaluatorRegistry.addEvaluatorDefinition(className);
        }
    }

    public EvaluatorRegistry getEvaluatorRegistry() {
        return this.evaluatorRegistry;
    }

    public void addEvaluatorDefinition(String className) {
        this.evaluatorRegistry.addEvaluatorDefinition(className);
    }

    public void addEvaluatorDefinition(EvaluatorDefinition def) {
        this.evaluatorRegistry.addEvaluatorDefinition(def);
    }

    private void buildDumpDirectory() {
        String dumpStr = this.chainedProperties.getProperty("drools.dump.dir", null);
        this.buildDumpDirectory(dumpStr);
    }

    private void buildDumpDirectory(String dumpStr) {
        if (dumpStr != null) {
            this.dumpDirectory = new File(dumpStr);
            if (!(this.dumpDirectory.isDirectory() && this.dumpDirectory.canWrite() && this.dumpDirectory.canRead())) {
                this.dumpDirectory = null;
                throw new RuntimeDroolsException("Drools dump directory is not accessible: " + dumpStr);
            }
        }
    }

    public File getDumpDir() {
        return this.dumpDirectory;
    }

    public void setDumpDir(File dumpDir) {
        if (!(dumpDir.isDirectory() && dumpDir.canWrite() && dumpDir.canRead())) {
            throw new RuntimeDroolsException("Drools dump directory is not accessible: " + dumpDir.toString());
        }
        this.dumpDirectory = dumpDir;
    }

    public boolean isProcessStringEscapes() {
        return this.processStringEscapes;
    }

    public void setProcessStringEscapes(boolean processStringEscapes) {
        this.processStringEscapes = processStringEscapes;
    }
}

