/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.modeldriven;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.drools.guvnor.client.modeldriven.DropDownData;
import org.drools.guvnor.client.modeldriven.brl.ActionFieldValue;
import org.drools.guvnor.client.modeldriven.brl.DSLSentence;
import org.drools.guvnor.client.modeldriven.brl.FactPattern;
import org.drools.guvnor.client.modeldriven.brl.FieldConstraint;
import org.drools.guvnor.client.modeldriven.brl.PortableObject;
import org.drools.guvnor.client.modeldriven.brl.SingleFieldConstraint;

public class SuggestionCompletionEngine
implements PortableObject {
    public static final String TYPE_COLLECTION = "Collection";
    public static final String TYPE_COMPARABLE = "Comparable";
    public static final String TYPE_STRING = "String";
    public static final String TYPE_NUMERIC = "Numeric";
    public static final String TYPE_BOOLEAN = "Boolean";
    public static final String TYPE_OBJECT = "Object";
    private static final String[] STANDARD_CONNECTIVES = new String[]{"|| ==", "|| !=", "&& !="};
    private static final String[] STRING_CONNECTIVES = new String[]{"|| ==", "|| !=", "&& !=", "&& matches", "|| matches"};
    private static final String[] COMPARABLE_CONNECTIVES = new String[]{"|| ==", "|| !=", "&& !=", "&& >", "&& <", "|| >", "|| <", "&& >=", "&& <=", "|| <=", "|| >="};
    private static final String[] COLLECTION_CONNECTIVES = new String[]{"|| ==", "|| !=", "&& !=", "|| contains", "&& contains", "|| excludes", "&& excludes"};
    private static final String[] STANDARD_OPERATORS = new String[]{"==", "!="};
    private static final String[] COMPARABLE_OPERATORS = new String[]{"==", "!=", "<", ">", "<=", ">="};
    private static final String[] STRING_OPERATORS = new String[]{"==", "!=", "matches", "soundslike"};
    private static final String[] COLLECTION_OPERATORS = new String[]{"contains", "excludes", "==", "!="};
    private static final String[] CONDITIONAL_ELEMENTS = new String[]{"not", "exists", "or"};
    public String[] factTypes;
    public Map<String, String[]> fieldsForType;
    public Map<String, String> fieldTypes;
    public Map<String, String> globalTypes = new HashMap<String, String>();
    public Map<String, String> modifiers;
    public Map<String, String[]> dataEnumLists = new HashMap<String, String[]>();
    public DSLSentence[] conditionDSLSentences = new DSLSentence[0];
    public DSLSentence[] actionDSLSentences = new DSLSentence[0];
    public DSLSentence[] keywordDSLItems = new DSLSentence[0];
    public DSLSentence[] anyScopeDSLItems = new DSLSentence[0];
    private transient Map dataEnumLookupFields;

    public String[] getConditionalElements() {
        return CONDITIONAL_ELEMENTS;
    }

    public DSLSentence[] getDSLConditions() {
        return this.conditionDSLSentences;
    }

    public DSLSentence[] getDSLActions() {
        return this.actionDSLSentences;
    }

    public String[] getConnectiveOperatorCompletions(String factType, String fieldName) {
        String type = this.fieldTypes.get(factType + "." + fieldName);
        if (type == null) {
            return STANDARD_CONNECTIVES;
        }
        if (type.equals(TYPE_STRING)) {
            return STRING_CONNECTIVES;
        }
        if (type.equals(TYPE_COMPARABLE) || type.equals(TYPE_NUMERIC)) {
            return COMPARABLE_CONNECTIVES;
        }
        if (type.equals(TYPE_COLLECTION)) {
            return COLLECTION_CONNECTIVES;
        }
        return STANDARD_CONNECTIVES;
    }

    public String[] getFactTypes() {
        return this.factTypes;
    }

    public String[] getFieldCompletions(String factType) {
        return this.fieldsForType.get(factType);
    }

    public String[] getOperatorCompletions(String factType, String fieldName) {
        String type = this.fieldTypes.get(factType + "." + fieldName);
        if (type == null) {
            return STANDARD_OPERATORS;
        }
        if (type.equals(TYPE_STRING)) {
            return STRING_OPERATORS;
        }
        if (type.equals(TYPE_COMPARABLE) || type.equals(TYPE_NUMERIC)) {
            return COMPARABLE_OPERATORS;
        }
        if (type.equals(TYPE_COLLECTION)) {
            return COLLECTION_OPERATORS;
        }
        return STANDARD_OPERATORS;
    }

    public String getFieldType(String factType, String fieldName) {
        return this.fieldTypes.get(factType + "." + fieldName);
    }

    public boolean isGlobalVariable(String variable) {
        return this.globalTypes.containsKey(variable);
    }

    public String[] getFieldCompletionsForGlobalVariable(String varName) {
        String type = this.globalTypes.get(varName);
        return this.fieldsForType.get(type);
    }

    private String[] toStringArray(Set set) {
        String[] f = new String[set.size()];
        int i = 0;
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            f[i] = (String)iter.next();
            ++i;
        }
        return f;
    }

    public String[] getGlobalVariables() {
        return this.toStringArray(this.globalTypes.keySet());
    }

    public DropDownData getEnums(FactPattern pat, String field) {
        Map dataEnumLookupFields = this.loadDataEnumLookupFields();
        if (pat.constraintList != null && pat.constraintList.constraints != null) {
            Object _typeField = dataEnumLookupFields.get(pat.factType + "." + field);
            if (_typeField instanceof String) {
                String typeField = (String)_typeField;
                FieldConstraint[] cons = pat.constraintList.constraints;
                for (int i = 0; i < cons.length; ++i) {
                    FieldConstraint con = cons[i];
                    if (!(con instanceof SingleFieldConstraint)) continue;
                    SingleFieldConstraint sfc = (SingleFieldConstraint)con;
                    if (!sfc.fieldName.equals(typeField)) continue;
                    String key = pat.factType + "." + field + "[" + typeField + "=" + sfc.value + "]";
                    return DropDownData.create(this.dataEnumLists.get(key));
                }
            } else if (_typeField != null) {
                String[] fieldsNeeded = (String[])_typeField;
                String queryString = this.getQueryString(pat.factType, field, this.dataEnumLists);
                String[] valuePairs = new String[fieldsNeeded.length];
                for (int i = 0; i < fieldsNeeded.length; ++i) {
                    for (int j = 0; j < pat.constraintList.constraints.length; ++j) {
                        FieldConstraint con = pat.constraintList.constraints[j];
                        if (!(con instanceof SingleFieldConstraint)) continue;
                        SingleFieldConstraint sfc = (SingleFieldConstraint)con;
                        if (!sfc.fieldName.equals(fieldsNeeded[i])) continue;
                        valuePairs[i] = fieldsNeeded[i] + "=" + sfc.value;
                    }
                }
                return DropDownData.create(queryString, valuePairs);
            }
        }
        return DropDownData.create(this.getEnumValues(pat.factType, field));
    }

    public DropDownData getEnums(String type, ActionFieldValue[] currentValues, String field) {
        if (currentValues != null) {
            Map dataEnumLookupFields = this.loadDataEnumLookupFields();
            Object _typeField = dataEnumLookupFields.get(type + "." + field);
            if (_typeField instanceof String) {
                String typeField = (String)dataEnumLookupFields.get(type + "." + field);
                for (int i = 0; i < currentValues.length; ++i) {
                    ActionFieldValue val = currentValues[i];
                    if (!val.field.equals(typeField)) continue;
                    String key = type + "." + field + "[" + typeField + "=" + val.value + "]";
                    return DropDownData.create(this.dataEnumLists.get(key));
                }
            } else if (_typeField != null) {
                String[] fieldsNeeded = (String[])_typeField;
                String queryString = this.getQueryString(type, field, this.dataEnumLists);
                String[] valuePairs = new String[fieldsNeeded.length];
                for (int i = 0; i < fieldsNeeded.length; ++i) {
                    for (int j = 0; j < currentValues.length; ++j) {
                        ActionFieldValue con = currentValues[j];
                        if (!con.field.equals(fieldsNeeded[i])) continue;
                        valuePairs[i] = fieldsNeeded[i] + "=" + con.value;
                    }
                }
                return DropDownData.create(queryString, valuePairs);
            }
        }
        String[] vals = this.dataEnumLists.get(type + "." + field);
        return DropDownData.create(vals);
    }

    String getQueryString(String factType, String field, Map dataEnumLists) {
        for (String key : dataEnumLists.keySet()) {
            if (!key.startsWith(factType + "." + field)) continue;
            String[] qry = (String[])dataEnumLists.get(key);
            return qry[0];
        }
        throw new IllegalStateException();
    }

    public String[] getEnumValues(String factType, String field) {
        return this.dataEnumLists.get(factType + "." + field);
    }

    Map loadDataEnumLookupFields() {
        if (this.dataEnumLookupFields == null) {
            this.dataEnumLookupFields = new HashMap();
            Set<String> keys = this.dataEnumLists.keySet();
            for (String key : keys) {
                if (key.indexOf(91) == -1) continue;
                int ix = key.indexOf(91);
                String factField = key.substring(0, ix);
                String predicate = key.substring(ix + 1, key.indexOf(93));
                if (predicate.indexOf(61) > -1) {
                    String typeField = predicate.substring(0, predicate.indexOf(61));
                    this.dataEnumLookupFields.put(factField, typeField);
                    continue;
                }
                String[] fields = predicate.split(",");
                for (int i = 0; i < fields.length; ++i) {
                    fields[i] = fields[i].trim();
                }
                this.dataEnumLookupFields.put(factField, fields);
            }
        }
        return this.dataEnumLookupFields;
    }
}

