/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.modeldriven.brl;

import java.util.ArrayList;
import java.util.List;
import org.drools.guvnor.client.modeldriven.brl.ActionRetractFact;
import org.drools.guvnor.client.modeldriven.brl.ActionSetField;
import org.drools.guvnor.client.modeldriven.brl.DSLSentence;
import org.drools.guvnor.client.modeldriven.brl.FactPattern;
import org.drools.guvnor.client.modeldriven.brl.FieldConstraint;
import org.drools.guvnor.client.modeldriven.brl.IAction;
import org.drools.guvnor.client.modeldriven.brl.IPattern;
import org.drools.guvnor.client.modeldriven.brl.ISingleFieldConstraint;
import org.drools.guvnor.client.modeldriven.brl.PortableObject;
import org.drools.guvnor.client.modeldriven.brl.RuleAttribute;
import org.drools.guvnor.client.modeldriven.brl.RuleMetadata;
import org.drools.guvnor.client.modeldriven.brl.SingleFieldConstraint;

public class RuleModel
implements PortableObject {
    public String name;
    public String parentName;
    public String modelVersion = "1.0";
    public RuleAttribute[] attributes = new RuleAttribute[0];
    public RuleMetadata[] metadataList = new RuleMetadata[0];
    public IPattern[] lhs = new IPattern[0];
    public IAction[] rhs = new IAction[0];

    public FactPattern getBoundFact(String var) {
        if (this.lhs == null) {
            return null;
        }
        for (int i = 0; i < this.lhs.length; ++i) {
            if (!(this.lhs[i] instanceof FactPattern)) continue;
            FactPattern p = (FactPattern)this.lhs[i];
            if (p.boundName == null || !var.equals(p.boundName)) continue;
            return p;
        }
        return null;
    }

    public List getBoundFacts() {
        if (this.lhs == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < this.lhs.length; ++i) {
            if (!(this.lhs[i] instanceof FactPattern)) continue;
            FactPattern p = (FactPattern)this.lhs[i];
            if (p.boundName == null) continue;
            list.add(p.boundName);
        }
        return list;
    }

    public boolean removeLhsItem(int idx) {
        IPattern[] newList = new IPattern[this.lhs.length - 1];
        int newIdx = 0;
        for (int i = 0; i < this.lhs.length; ++i) {
            if (i != idx) {
                newList[newIdx] = this.lhs[i];
                ++newIdx;
                continue;
            }
            if (!(this.lhs[i] instanceof FactPattern)) continue;
            FactPattern p = (FactPattern)this.lhs[i];
            if (p.boundName == null || !this.isBoundFactUsed(p.boundName)) continue;
            return false;
        }
        this.lhs = newList;
        return true;
    }

    public boolean isBoundFactUsed(String binding) {
        if (this.rhs == null) {
            return false;
        }
        for (int i = 0; i < this.rhs.length; ++i) {
            if (this.rhs[i] instanceof ActionSetField) {
                ActionSetField set = (ActionSetField)this.rhs[i];
                if (!set.variable.equals(binding)) continue;
                return true;
            }
            if (!(this.rhs[i] instanceof ActionRetractFact)) continue;
            ActionRetractFact ret = (ActionRetractFact)this.rhs[i];
            if (!ret.variableName.equals(binding)) continue;
            return true;
        }
        return false;
    }

    public void addLhsItem(IPattern pat) {
        if (this.lhs == null) {
            this.lhs = new IPattern[0];
        }
        IPattern[] list = this.lhs;
        IPattern[] newList = new IPattern[list.length + 1];
        for (int i = 0; i < list.length; ++i) {
            newList[i] = list[i];
        }
        newList[list.length] = pat;
        this.lhs = newList;
    }

    public void addRhsItem(IAction action) {
        if (this.rhs == null) {
            this.rhs = new IAction[0];
        }
        IAction[] list = this.rhs;
        IAction[] newList = new IAction[list.length + 1];
        for (int i = 0; i < list.length; ++i) {
            newList[i] = list[i];
        }
        newList[list.length] = action;
        this.rhs = newList;
    }

    public void removeRhsItem(int idx) {
        IAction[] newList = new IAction[this.rhs.length - 1];
        int newIdx = 0;
        for (int i = 0; i < this.rhs.length; ++i) {
            if (i == idx) continue;
            newList[newIdx] = this.rhs[i];
            ++newIdx;
        }
        this.rhs = newList;
    }

    public void addAttribute(RuleAttribute attribute) {
        RuleAttribute[] list = this.attributes;
        RuleAttribute[] newList = new RuleAttribute[list.length + 1];
        for (int i = 0; i < list.length; ++i) {
            newList[i] = list[i];
        }
        newList[list.length] = attribute;
        this.attributes = newList;
    }

    public void removeAttribute(int idx) {
        RuleAttribute[] newList = new RuleAttribute[this.attributes.length - 1];
        int newIdx = 0;
        for (int i = 0; i < this.attributes.length; ++i) {
            if (i == idx) continue;
            newList[newIdx] = this.attributes[i];
            ++newIdx;
        }
        this.attributes = newList;
    }

    public void addMetadata(RuleMetadata metadata) {
        RuleMetadata[] newList = new RuleMetadata[this.metadataList.length + 1];
        for (int i = 0; i < this.metadataList.length; ++i) {
            newList[i] = this.metadataList[i];
        }
        newList[this.metadataList.length] = metadata;
        this.metadataList = newList;
    }

    public void removeMetadata(int idx) {
        RuleMetadata[] newList = new RuleMetadata[this.metadataList.length - 1];
        int newIdx = 0;
        for (int i = 0; i < this.metadataList.length; ++i) {
            if (i == idx) continue;
            newList[newIdx] = this.metadataList[i];
            ++newIdx;
        }
        this.metadataList = newList;
    }

    public RuleMetadata getMetaData(String attributeName) {
        if (this.metadataList != null && attributeName != null) {
            for (int i = 0; i < this.metadataList.length; ++i) {
                if (!attributeName.equals(this.metadataList[i].attributeName)) continue;
                return this.metadataList[i];
            }
        }
        return null;
    }

    public boolean updateMetadata(RuleMetadata target) {
        RuleMetadata metaData = this.getMetaData(target.attributeName);
        if (metaData != null) {
            metaData.value = target.value;
            return true;
        }
        this.addMetadata(target);
        return false;
    }

    public List getBoundVariablesInScope(ISingleFieldConstraint con) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < this.lhs.length; ++i) {
            IPattern pat = this.lhs[i];
            if (!(pat instanceof FactPattern)) continue;
            FactPattern fact = (FactPattern)pat;
            if (fact.constraintList != null) {
                FieldConstraint[] cons = fact.constraintList.constraints;
                if (cons != null) {
                    for (int k = 0; k < cons.length; ++k) {
                        FieldConstraint fc = cons[k];
                        if (!(fc instanceof SingleFieldConstraint)) continue;
                        SingleFieldConstraint c = (SingleFieldConstraint)fc;
                        if (c == con) {
                            return result;
                        }
                        if (c.connectives != null) {
                            for (int j = 0; j < c.connectives.length; ++j) {
                                if (con != c.connectives[j]) continue;
                                return result;
                            }
                        }
                        if (!c.isBound()) continue;
                        result.add(c.fieldBinding);
                    }
                }
                if (!fact.isBound()) continue;
                result.add(fact.boundName);
                continue;
            }
            if (!fact.isBound()) continue;
            result.add(fact.boundName);
        }
        return result;
    }

    public List getAllVariables() {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < this.lhs.length; ++i) {
            IPattern pat = this.lhs[i];
            if (!(pat instanceof FactPattern)) continue;
            FactPattern fact = (FactPattern)pat;
            if (fact.isBound()) {
                result.add(fact.boundName);
            }
            for (int j = 0; j < fact.getFieldConstraints().length; ++j) {
                SingleFieldConstraint con;
                FieldConstraint fc = fact.getFieldConstraints()[j];
                if (!(fc instanceof SingleFieldConstraint) || !(con = (SingleFieldConstraint)fc).isBound()) continue;
                result.add(con.fieldBinding);
            }
        }
        return result;
    }

    public boolean isVariableNameUsed(String s) {
        return this.getAllVariables().contains(s);
    }

    public boolean hasDSLSentences() {
        int i;
        if (this.lhs != null) {
            for (i = 0; i < this.lhs.length; ++i) {
                if (!(this.lhs[i] instanceof DSLSentence)) continue;
                return true;
            }
        }
        if (this.rhs != null) {
            for (i = 0; i < this.rhs.length; ++i) {
                if (!(this.rhs[i] instanceof DSLSentence)) continue;
                return true;
            }
        }
        return false;
    }
}

