/*
 * Decompiled with CFR 0.152.
 */
package org.drools.lang.dsl;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.drools.lang.dsl.DSLMappingEntry;

public abstract class AbstractDSLMappingEntry {
    protected DSLMappingEntry.Section section;
    protected DSLMappingEntry.MetaData metadata;
    protected String key;
    protected String value;
    protected String sentence;
    protected Map variables = Collections.EMPTY_MAP;
    protected Pattern keyPattern;
    protected String valuePattern;

    public DSLMappingEntry.Section getSection() {
        return this.section;
    }

    public DSLMappingEntry.MetaData getMetaData() {
        return this.metadata;
    }

    public String getMappingKey() {
        return this.key;
    }

    public String getMappingValue() {
        return this.value;
    }

    public void setSection(DSLMappingEntry.Section section) {
        this.section = section;
    }

    public void setMetaData(DSLMappingEntry.MetaData metadata) {
        this.metadata = metadata;
    }

    public Pattern getKeyPattern() {
        return this.keyPattern;
    }

    public String getValuePattern() {
        return this.valuePattern;
    }

    public Map getVariables() {
        return this.variables;
    }

    public String toPatternString() {
        return this.section + "[" + this.metadata + "]" + this.keyPattern.pattern() + "=" + this.valuePattern;
    }

    public String toString() {
        return this.section + "[" + this.metadata + "]" + this.key + "=" + this.value;
    }

    public void setSentence(String sentence) {
        this.sentence = sentence;
    }

    public String getSentence() {
        return this.sentence;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + (this.metadata == null ? 0 : this.metadata.hashCode());
        result = 31 * result + (this.section == null ? 0 : this.section.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractDSLMappingEntry other = (AbstractDSLMappingEntry)obj;
        if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
            return false;
        }
        if (this.metadata == null ? other.metadata != null : !this.metadata.equals(other.metadata)) {
            return false;
        }
        if (this.section == null ? other.section != null : !this.section.equals(other.section)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public List getErrors() {
        return Collections.EMPTY_LIST;
    }
}

