/*
 * Decompiled with CFR 0.152.
 */
package org.drools.lang.dsl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.lang.dsl.AbstractDSLMappingEntry;
import org.drools.lang.dsl.DSLMappingEntry;

public class DefaultDSLMappingEntry
extends AbstractDSLMappingEntry
implements DSLMappingEntry {
    private static final Pattern VAR_FINDER = Pattern.compile("(^|[^\\\\])\\{([(\\\\\\{)|[^\\{]]*?)\\}", 40);
    private static final Pattern PAREN_FINDER = Pattern.compile("(^\\(|[^\\\\]\\(|\\G\\()");

    public DefaultDSLMappingEntry() {
        this(DSLMappingEntry.ANY, DSLMappingEntry.EMPTY_METADATA, null, null);
    }

    public DefaultDSLMappingEntry(DSLMappingEntry.Section section, DSLMappingEntry.MetaData metadata, String key, String value) {
        this.section = section;
        this.metadata = metadata;
        this.setMappingKey(key);
        this.setMappingValue(value);
    }

    public void setMappingKey(String key) {
        if (key != null) {
            key = key.trim();
        }
        this.key = key;
        if (key != null) {
            int substr = 0;
            String escapedKey = key.replaceAll("\\$", "\\\\\\$");
            Matcher m = VAR_FINDER.matcher(escapedKey);
            StringBuffer buf = new StringBuffer();
            int counter = 1;
            if (!key.startsWith("^")) {
                buf.append("(\\W|^)");
                substr += buf.length();
                ++counter;
            }
            int lastMatch = 0;
            while (m.find()) {
                if (this.variables == Collections.EMPTY_MAP) {
                    this.variables = new HashMap(2);
                }
                String before = escapedKey.substring(lastMatch, Math.max(m.start(), lastMatch));
                lastMatch = m.end() + 1;
                Matcher m2 = PAREN_FINDER.matcher(before);
                while (m2.find()) {
                    ++counter;
                }
                this.variables.put(m.group(2), new Integer(counter++));
                m.appendReplacement(buf, m.group(1) + "(.*?)");
            }
            m.appendTail(buf);
            if (buf.toString().endsWith("(.*?)")) {
                buf.append("$");
            } else {
                buf.append("(\\W|$)");
            }
            String pat = buf.toString();
            if (pat.substring(substr).trim().startsWith("-") && !pat.substring(substr).trim().startsWith("-\\s*")) {
                pat = pat.substring(0, pat.indexOf(45) + 1) + "\\s*" + pat.substring(pat.indexOf(45) + 1).trim();
            }
            pat = pat.replaceAll("\\s+", "\\\\s+");
            this.keyPattern = Pattern.compile(pat, 40);
        } else {
            this.keyPattern = null;
        }
        this.setMappingValue(this.value);
    }

    public void setMappingValue(String value) {
        this.valuePattern = value;
        this.value = value;
        if (value != null) {
            this.valuePattern = this.valuePattern.replaceAll("\\\\n", "\n").replaceAll("\\$", "\\\\\\$");
            for (Map.Entry entry : this.variables.entrySet()) {
                String var = (String)entry.getKey();
                int pos = (Integer)entry.getValue();
                this.valuePattern = this.valuePattern.replaceAll("\\{" + var + "\\}", "\\$" + pos);
            }
        }
    }
}

