/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder.dialect.mvel;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.drools.base.mvel.MVELAction;
import org.drools.base.mvel.MVELCompilationUnit;
import org.drools.base.mvel.MVELCompileable;
import org.drools.compiler.DescrBuildError;
import org.drools.compiler.Dialect;
import org.drools.lang.descr.ActionDescr;
import org.drools.rule.MVELDialectRuntimeData;
import org.drools.rule.builder.ActionBuilder;
import org.drools.rule.builder.PackageBuildContext;
import org.drools.rule.builder.dialect.mvel.MVELDialect;
import org.drools.spi.ProcessContext;
import org.drools.spi.Wireable;
import org.drools.workflow.core.DroolsAction;
import org.mvel2.Macro;
import org.mvel2.MacroProcessor;

public class MVELActionBuilder
implements ActionBuilder {
    private static final Map macros = new HashMap(5);

    public void build(PackageBuildContext context, DroolsAction action, ActionDescr actionDescr) {
        String text = MVELActionBuilder.processMacros(actionDescr.getText());
        try {
            MVELDialect dialect = (MVELDialect)context.getDialect("mvel");
            HashSet<String> variables = new HashSet<String>();
            variables.add("context");
            Dialect.AnalysisResult analysis = dialect.analyzeBlock(context, actionDescr, dialect.getInterceptors(), text, new Set[]{variables, context.getPkg().getGlobals().keySet()}, null);
            HashMap<String, Class> variableClasses = new HashMap<String, Class>();
            variableClasses.put("context", ProcessContext.class);
            MVELCompilationUnit unit = dialect.getMVELCompilationUnit(text, analysis, null, null, variableClasses, context);
            MVELAction expr = new MVELAction(unit, context.getDialect().getId());
            expr.setVariableNames(analysis.getNotBoundedIdentifiers());
            action.setMetaData("Action", (Object)expr);
            MVELDialectRuntimeData data = (MVELDialectRuntimeData)context.getPkg().getDialectRuntimeRegistry().getDialectData(dialect.getId());
            data.addCompileable((Wireable)action, (MVELCompileable)expr);
            expr.compile((ClassLoader)context.getPackageBuilder().getRootClassLoader());
        }
        catch (Exception e) {
            context.getErrors().add(new DescrBuildError(context.getParentDescr(), actionDescr, null, "Unable to build expression for 'action' : " + e.getMessage() + " '" + actionDescr.getText() + "'"));
        }
    }

    public static String processMacros(String consequence) {
        MacroProcessor macroProcessor = new MacroProcessor();
        macroProcessor.setMacros(macros);
        return macroProcessor.parse(MVELActionBuilder.delimitExpressions(consequence));
    }

    public static String delimitExpressions(String s) {
        StringBuffer result = new StringBuffer();
        char[] cs = s.toCharArray();
        int brace = 0;
        int sqre = 0;
        int crly = 0;
        int lastNonWhite = 59;
        for (int i = 0; i < cs.length; ++i) {
            int c = cs[i];
            switch (c) {
                case 40: {
                    ++brace;
                    break;
                }
                case 123: {
                    ++crly;
                    break;
                }
                case 91: {
                    ++sqre;
                    break;
                }
                case 41: {
                    --brace;
                    break;
                }
                case 125: {
                    --crly;
                    break;
                }
                case 93: {
                    --sqre;
                    break;
                }
            }
            if (brace == 0 && sqre == 0 && crly == 0 && (c == 10 || c == 13)) {
                if (lastNonWhite != 59) {
                    result.append(';');
                    lastNonWhite = 59;
                }
            } else if (!Character.isWhitespace((char)c)) {
                lastNonWhite = c;
            }
            result.append((char)c);
        }
        return result.toString();
    }

    static {
        macros.put("insert", new Macro(){

            public String doMacro() {
                return "drools.insert";
            }
        });
        macros.put("insertLogical", new Macro(){

            public String doMacro() {
                return "drools.insertLogical";
            }
        });
        macros.put("modify", new Macro(){

            public String doMacro() {
                return "@Modify with";
            }
        });
        macros.put("update", new Macro(){

            public String doMacro() {
                return "drools.update";
            }
        });
        macros.put("retract", new Macro(){

            public String doMacro() {
                return "drools.retract";
            }
        });
    }
}

