/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.compiler.Dialect;
import org.drools.rule.Package;
import org.drools.rule.builder.ProcessBuildContext;

public class DialectCompiletimeRegistry {
    private Package pkg;
    private Map<String, Dialect> map;

    public DialectCompiletimeRegistry(Package pkg) {
        this.pkg = pkg;
        this.map = new HashMap<String, Dialect>();
    }

    public void addDialect(String name, Dialect dialect) {
        this.map.put(name, dialect);
    }

    public Dialect getDialect(String name) {
        return this.map.get(name);
    }

    public void compileAll() {
        for (Dialect dialect : this.map.values()) {
            dialect.compileAll();
        }
    }

    public Iterator iterator() {
        return this.map.values().iterator();
    }

    public List addResults(List list) {
        if (list == null) {
            list = new ArrayList();
        }
        for (Dialect dialect : this.map.values()) {
            List results = dialect.getResults();
            if (results == null) continue;
            list.addAll(results);
        }
        return list;
    }

    public void addImport(String importEntry) {
        for (Dialect dialect : this.map.values()) {
            dialect.addImport(importEntry);
        }
    }

    public void addStaticImport(String staticImportEntry) {
        for (Dialect dialect : this.map.values()) {
            dialect.addStaticImport(staticImportEntry);
        }
    }

    public void addProcess(ProcessBuildContext contgext) {
        for (Dialect dialect : this.map.values()) {
            dialect.addProcess(contgext);
        }
    }
}

