/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder.dialect.java;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.drools.lang.descr.BaseDescr;
import org.drools.rule.builder.ProcessBuildContext;
import org.drools.util.StringUtils;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.integration.impl.MapVariableResolverFactory;
import org.mvel2.templates.CompiledTemplate;
import org.mvel2.templates.SimpleTemplateRegistry;
import org.mvel2.templates.TemplateCompiler;
import org.mvel2.templates.TemplateRegistry;
import org.mvel2.templates.TemplateRuntime;

public class AbstractJavaProcessBuilder {
    protected static final TemplateRegistry RULE_REGISTRY = new SimpleTemplateRegistry();
    protected static final TemplateRegistry INVOKER_REGISTRY = new SimpleTemplateRegistry();

    public TemplateRegistry getRuleTemplateRegistry() {
        return RULE_REGISTRY;
    }

    public TemplateRegistry getInvokerTemplateRegistry() {
        return INVOKER_REGISTRY;
    }

    public Map createVariableContext(String className, String text, ProcessBuildContext context, String[] globals) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("methodName", className);
        map.put("package", context.getPkg().getName());
        map.put("processClassName", StringUtils.ucFirst((String)context.getProcessDescr().getClassName()));
        map.put("invokerClassName", context.getProcessDescr().getClassName() + StringUtils.ucFirst((String)className) + "Invoker");
        if (text != null) {
            map.put("text", text);
            map.put("hashCode", new Integer(text.hashCode()));
        }
        ArrayList<String> globalTypes = new ArrayList<String>(globals.length);
        int length = globals.length;
        for (int i = 0; i < length; ++i) {
            globalTypes.add(((String)context.getPkg().getGlobals().get(globals[i])).replace('$', '.'));
        }
        map.put("globals", globals);
        map.put("globalTypes", globalTypes);
        return map;
    }

    public void generatTemplates(String ruleTemplate, String invokerTemplate, ProcessBuildContext context, String className, Map vars, Object invokerLookup, BaseDescr descrLookup) {
        TemplateRegistry registry = this.getRuleTemplateRegistry();
        context.getMethods().add(TemplateRuntime.execute((CompiledTemplate)registry.getNamedTemplate(ruleTemplate), null, (VariableResolverFactory)new MapVariableResolverFactory(vars), (TemplateRegistry)registry));
        registry = this.getInvokerTemplateRegistry();
        String invokerClassName = context.getPkg().getName() + "." + context.getProcessDescr().getClassName() + StringUtils.ucFirst((String)className) + "Invoker";
        context.getInvokers().put(invokerClassName, TemplateRuntime.execute((CompiledTemplate)registry.getNamedTemplate(invokerTemplate), null, (VariableResolverFactory)new MapVariableResolverFactory(vars), (TemplateRegistry)registry));
        context.getInvokerLookups().put(invokerClassName, invokerLookup);
        context.getDescrLookups().put(invokerClassName, descrLookup);
    }

    static {
        RULE_REGISTRY.addNamedTemplate("rules", TemplateCompiler.compileTemplate((InputStream)AbstractJavaProcessBuilder.class.getResourceAsStream("javaRule.mvel"), null));
        INVOKER_REGISTRY.addNamedTemplate("invokers", TemplateCompiler.compileTemplate((InputStream)AbstractJavaProcessBuilder.class.getResourceAsStream("javaInvokers.mvel"), null));
        TemplateRuntime.execute((CompiledTemplate)RULE_REGISTRY.getNamedTemplate("rules"), null, (TemplateRegistry)RULE_REGISTRY);
        TemplateRuntime.execute((CompiledTemplate)INVOKER_REGISTRY.getNamedTemplate("invokers"), null, (TemplateRegistry)INVOKER_REGISTRY);
    }
}

