/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.modeldriven.brl;

import java.util.ArrayList;
import java.util.List;
import org.drools.guvnor.client.modeldriven.brl.ActionInsertFact;
import org.drools.guvnor.client.modeldriven.brl.ActionRetractFact;
import org.drools.guvnor.client.modeldriven.brl.ActionSetField;
import org.drools.guvnor.client.modeldriven.brl.CompositeFieldConstraint;
import org.drools.guvnor.client.modeldriven.brl.DSLSentence;
import org.drools.guvnor.client.modeldriven.brl.FactPattern;
import org.drools.guvnor.client.modeldriven.brl.FieldConstraint;
import org.drools.guvnor.client.modeldriven.brl.IAction;
import org.drools.guvnor.client.modeldriven.brl.IPattern;
import org.drools.guvnor.client.modeldriven.brl.ISingleFieldConstraint;
import org.drools.guvnor.client.modeldriven.brl.PortableObject;
import org.drools.guvnor.client.modeldriven.brl.RuleAttribute;
import org.drools.guvnor.client.modeldriven.brl.RuleMetadata;
import org.drools.guvnor.client.modeldriven.brl.SingleFieldConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleModel
implements PortableObject {
    public String name;
    public String parentName;
    public String modelVersion = "1.0";
    public RuleAttribute[] attributes = new RuleAttribute[0];
    public RuleMetadata[] metadataList = new RuleMetadata[0];
    public IPattern[] lhs = new IPattern[0];
    public IAction[] rhs = new IAction[0];

    public FactPattern getBoundFact(String var) {
        if (this.lhs == null) {
            return null;
        }
        for (int i = 0; i < this.lhs.length; ++i) {
            if (!(this.lhs[i] instanceof FactPattern)) continue;
            FactPattern p = (FactPattern)this.lhs[i];
            if (p.boundName == null || !var.equals(p.boundName)) continue;
            return p;
        }
        return null;
    }

    public String getFieldConstraint(String var) {
        if (this.lhs == null) {
            return null;
        }
        for (int i = 0; i < this.lhs.length; ++i) {
            FactPattern p;
            FieldConstraint[] arr$;
            int len$;
            int i$;
            if (!(this.lhs[i] instanceof FactPattern) || (i$ = 0) >= (len$ = (arr$ = (p = (FactPattern)this.lhs[i]).getFieldConstraints()).length)) continue;
            FieldConstraint z = arr$[i$];
            return this.giveFieldBinding(z, var);
        }
        return null;
    }

    private String giveFieldBinding(FieldConstraint f, String var) {
        FieldConstraint s;
        if (f instanceof SingleFieldConstraint && (s = (SingleFieldConstraint)f).isBound() && var.equals(s.fieldBinding)) {
            return s.fieldType;
        }
        if (f instanceof CompositeFieldConstraint) {
            s = (CompositeFieldConstraint)f;
            int i$ = 0;
            FieldConstraint[] arr$ = ((CompositeFieldConstraint)s).constraints;
            int len$ = arr$.length;
            if (i$ < len$) {
                FieldConstraint ss = arr$[i$];
                return this.giveFieldBinding(s, var);
            }
        }
        return null;
    }

    public ActionInsertFact getRhsBoundFact(String var) {
        if (this.rhs == null) {
            return null;
        }
        for (int i = 0; i < this.rhs.length; ++i) {
            ActionInsertFact p;
            if (!(this.rhs[i] instanceof ActionInsertFact) || (p = (ActionInsertFact)this.rhs[i]).getBoundName() == null || !var.equals(p.getBoundName())) continue;
            return p;
        }
        return null;
    }

    public List getBoundFacts() {
        if (this.lhs == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < this.lhs.length; ++i) {
            List<String> fieldBindings;
            if (!(this.lhs[i] instanceof FactPattern)) continue;
            FactPattern p = (FactPattern)this.lhs[i];
            if (p.boundName != null) {
                list.add(p.boundName);
            }
            if ((fieldBindings = this.getListFieldBinding(p)) == null) continue;
            list.addAll(fieldBindings);
        }
        return list;
    }

    private List<String> getListFieldBinding(FactPattern fact) {
        ArrayList<String> result = new ArrayList<String>();
        for (int j = 0; j < fact.getFieldConstraints().length; ++j) {
            FieldConstraint fc = fact.getFieldConstraints()[j];
            List<String> s = this.giveFieldBinding(fc);
            result.addAll(s);
        }
        return result;
    }

    private List<String> giveFieldBinding(FieldConstraint f) {
        FieldConstraint s;
        ArrayList<String> result = new ArrayList<String>();
        if (f instanceof SingleFieldConstraint && (s = (SingleFieldConstraint)f).isBound()) {
            result.add(s.fieldBinding);
        }
        if (f instanceof CompositeFieldConstraint) {
            s = (CompositeFieldConstraint)f;
            for (FieldConstraint ss : ((CompositeFieldConstraint)s).constraints) {
                List<String> t = this.giveFieldBinding(s);
                result.addAll(t);
            }
        }
        return result;
    }

    public List getRhsBoundFacts() {
        if (this.rhs == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < this.rhs.length; ++i) {
            ActionInsertFact p;
            if (!(this.rhs[i] instanceof ActionInsertFact) || (p = (ActionInsertFact)this.rhs[i]).getBoundName() == null) continue;
            list.add(p.getBoundName());
        }
        return list;
    }

    public boolean removeLhsItem(int idx) {
        IPattern[] newList = new IPattern[this.lhs.length - 1];
        int newIdx = 0;
        for (int i = 0; i < this.lhs.length; ++i) {
            if (i != idx) {
                newList[newIdx] = this.lhs[i];
                ++newIdx;
                continue;
            }
            if (!(this.lhs[i] instanceof FactPattern)) continue;
            FactPattern p = (FactPattern)this.lhs[i];
            if (p.boundName == null || !this.isBoundFactUsed(p.boundName)) continue;
            return false;
        }
        this.lhs = newList;
        return true;
    }

    public boolean isBoundFactUsed(String binding) {
        if (this.rhs == null) {
            return false;
        }
        for (int i = 0; i < this.rhs.length; ++i) {
            if (this.rhs[i] instanceof ActionSetField) {
                ActionSetField set = (ActionSetField)this.rhs[i];
                if (!set.variable.equals(binding)) continue;
                return true;
            }
            if (!(this.rhs[i] instanceof ActionRetractFact)) continue;
            ActionRetractFact ret = (ActionRetractFact)this.rhs[i];
            if (!ret.variableName.equals(binding)) continue;
            return true;
        }
        return false;
    }

    public void addLhsItem(IPattern pat) {
        if (this.lhs == null) {
            this.lhs = new IPattern[0];
        }
        IPattern[] list = this.lhs;
        IPattern[] newList = new IPattern[list.length + 1];
        for (int i = 0; i < list.length; ++i) {
            newList[i] = list[i];
        }
        newList[list.length] = pat;
        this.lhs = newList;
    }

    public void addRhsItem(IAction action) {
        if (this.rhs == null) {
            this.rhs = new IAction[0];
        }
        IAction[] list = this.rhs;
        IAction[] newList = new IAction[list.length + 1];
        for (int i = 0; i < list.length; ++i) {
            newList[i] = list[i];
        }
        newList[list.length] = action;
        this.rhs = newList;
    }

    public void removeRhsItem(int idx) {
        IAction[] newList = new IAction[this.rhs.length - 1];
        int newIdx = 0;
        for (int i = 0; i < this.rhs.length; ++i) {
            if (i == idx) continue;
            newList[newIdx] = this.rhs[i];
            ++newIdx;
        }
        this.rhs = newList;
    }

    public void addAttribute(RuleAttribute attribute) {
        RuleAttribute[] list = this.attributes;
        RuleAttribute[] newList = new RuleAttribute[list.length + 1];
        for (int i = 0; i < list.length; ++i) {
            newList[i] = list[i];
        }
        newList[list.length] = attribute;
        this.attributes = newList;
    }

    public void removeAttribute(int idx) {
        RuleAttribute[] newList = new RuleAttribute[this.attributes.length - 1];
        int newIdx = 0;
        for (int i = 0; i < this.attributes.length; ++i) {
            if (i == idx) continue;
            newList[newIdx] = this.attributes[i];
            ++newIdx;
        }
        this.attributes = newList;
    }

    public void addMetadata(RuleMetadata metadata) {
        RuleMetadata[] newList = new RuleMetadata[this.metadataList.length + 1];
        for (int i = 0; i < this.metadataList.length; ++i) {
            newList[i] = this.metadataList[i];
        }
        newList[this.metadataList.length] = metadata;
        this.metadataList = newList;
    }

    public void removeMetadata(int idx) {
        RuleMetadata[] newList = new RuleMetadata[this.metadataList.length - 1];
        int newIdx = 0;
        for (int i = 0; i < this.metadataList.length; ++i) {
            if (i == idx) continue;
            newList[newIdx] = this.metadataList[i];
            ++newIdx;
        }
        this.metadataList = newList;
    }

    public RuleMetadata getMetaData(String attributeName) {
        if (this.metadataList != null && attributeName != null) {
            for (int i = 0; i < this.metadataList.length; ++i) {
                if (!attributeName.equals(this.metadataList[i].attributeName)) continue;
                return this.metadataList[i];
            }
        }
        return null;
    }

    public boolean updateMetadata(RuleMetadata target) {
        RuleMetadata metaData = this.getMetaData(target.attributeName);
        if (metaData != null) {
            metaData.value = target.value;
            return true;
        }
        this.addMetadata(target);
        return false;
    }

    public List getBoundVariablesInScope(ISingleFieldConstraint con) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < this.lhs.length; ++i) {
            IPattern pat = this.lhs[i];
            if (!(pat instanceof FactPattern)) continue;
            FactPattern fact = (FactPattern)pat;
            if (fact.constraintList != null) {
                FieldConstraint[] cons = fact.constraintList.constraints;
                if (cons != null) {
                    for (int k = 0; k < cons.length; ++k) {
                        FieldConstraint fc = cons[k];
                        if (!(fc instanceof SingleFieldConstraint)) continue;
                        SingleFieldConstraint c = (SingleFieldConstraint)fc;
                        if (c == con) {
                            return result;
                        }
                        if (c.connectives != null) {
                            for (int j = 0; j < c.connectives.length; ++j) {
                                if (con != c.connectives[j]) continue;
                                return result;
                            }
                        }
                        if (!c.isBound()) continue;
                        result.add(c.fieldBinding);
                    }
                }
                if (!fact.isBound()) continue;
                result.add(fact.boundName);
                continue;
            }
            if (!fact.isBound()) continue;
            result.add(fact.boundName);
        }
        return result;
    }

    public List getAllVariables() {
        PortableObject fact;
        PortableObject pat;
        int i;
        ArrayList<String> result = new ArrayList<String>();
        for (i = 0; i < this.lhs.length; ++i) {
            pat = this.lhs[i];
            if (!(pat instanceof FactPattern)) continue;
            fact = (FactPattern)pat;
            if (((FactPattern)fact).isBound()) {
                result.add(((FactPattern)fact).boundName);
            }
            for (int j = 0; j < ((FactPattern)fact).getFieldConstraints().length; ++j) {
                SingleFieldConstraint con;
                FieldConstraint fc = ((FactPattern)fact).getFieldConstraints()[j];
                if (!(fc instanceof SingleFieldConstraint) || !(con = (SingleFieldConstraint)fc).isBound()) continue;
                result.add(con.fieldBinding);
            }
        }
        for (i = 0; i < this.rhs.length; ++i) {
            pat = this.rhs[i];
            if (!(pat instanceof ActionInsertFact) || !((ActionInsertFact)(fact = (ActionInsertFact)pat)).isBound()) continue;
            result.add(((ActionInsertFact)fact).getBoundName());
        }
        return result;
    }

    public boolean isVariableNameUsed(String s) {
        return this.getAllVariables().contains(s);
    }

    public boolean hasDSLSentences() {
        int i;
        if (this.lhs != null) {
            for (i = 0; i < this.lhs.length; ++i) {
                if (!(this.lhs[i] instanceof DSLSentence)) continue;
                return true;
            }
        }
        if (this.rhs != null) {
            for (i = 0; i < this.rhs.length; ++i) {
                if (!(this.rhs[i] instanceof DSLSentence)) continue;
                return true;
            }
        }
        return false;
    }
}

