/*
 * Decompiled with CFR 0.152.
 */
package org.drools.lang;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.drools.core.util.ReflectiveVisitor;
import org.drools.lang.descr.AccumulateDescr;
import org.drools.lang.descr.AndDescr;
import org.drools.lang.descr.AttributeDescr;
import org.drools.lang.descr.CollectDescr;
import org.drools.lang.descr.EvalDescr;
import org.drools.lang.descr.ExistsDescr;
import org.drools.lang.descr.FieldBindingDescr;
import org.drools.lang.descr.FieldConstraintDescr;
import org.drools.lang.descr.ForallDescr;
import org.drools.lang.descr.FromDescr;
import org.drools.lang.descr.FunctionDescr;
import org.drools.lang.descr.FunctionImportDescr;
import org.drools.lang.descr.GlobalDescr;
import org.drools.lang.descr.ImportDescr;
import org.drools.lang.descr.LiteralRestrictionDescr;
import org.drools.lang.descr.NotDescr;
import org.drools.lang.descr.OrDescr;
import org.drools.lang.descr.PackageDescr;
import org.drools.lang.descr.PackageDescrDumper;
import org.drools.lang.descr.PatternDescr;
import org.drools.lang.descr.PredicateDescr;
import org.drools.lang.descr.QualifiedIdentifierRestrictionDescr;
import org.drools.lang.descr.QueryDescr;
import org.drools.lang.descr.RestrictionConnectiveDescr;
import org.drools.lang.descr.RestrictionDescr;
import org.drools.lang.descr.ReturnValueRestrictionDescr;
import org.drools.lang.descr.RuleDescr;
import org.drools.lang.descr.VariableRestrictionDescr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrlDumper
extends ReflectiveVisitor
implements PackageDescrDumper {
    private StringBuilder drlDump;
    private static final String eol = System.getProperty("line.separator");
    private String template;
    private boolean needsBracket = false;
    private static Set needsQuotes = new HashSet();

    static {
        needsQuotes.add("agenda-group");
        needsQuotes.add("activation-group");
        needsQuotes.add("ruleflow-group");
        needsQuotes.add("date-effective");
        needsQuotes.add("date-expires");
        needsQuotes.add("dialect");
    }

    @Override
    public synchronized String dump(PackageDescr packageDescr) {
        this.drlDump = new StringBuilder();
        this.visitPackageDescr(packageDescr);
        return this.drlDump.toString();
    }

    public String getTemplate() {
        return this.template;
    }

    public void visitAndDescr(AndDescr descr) {
        this.template = new String();
        this.template = !descr.getDescrs().isEmpty() ? this.processDescrList(descr.getDescrs()) : "";
    }

    public void visitAttributeDescr(AttributeDescr attributeDescr) {
        this.template = new String();
        String name = attributeDescr.getName();
        String value = null;
        value = needsQuotes.contains(name) ? "\"" + attributeDescr.getValue() + "\"" : attributeDescr.getValue();
        this.template = "\t " + name + " " + value + eol;
    }

    public void visitFieldConstraintDescr(FieldConstraintDescr descr) {
        if (!descr.getRestrictions().isEmpty()) {
            this.template = String.valueOf(descr.getFieldName()) + " " + this.processFieldConstraint(descr.getRestriction(), false);
        }
    }

    public void visitVariableRestrictionDescr(VariableRestrictionDescr descr) {
        this.template = new String();
        this.template = String.valueOf(descr.getEvaluator()) + " " + descr.getIdentifier();
    }

    public void visitPatternDescr(PatternDescr descr) {
        StringBuilder buf = new StringBuilder();
        buf.append("\t\t");
        if (descr.getIdentifier() != null) {
            buf.append(descr.getIdentifier());
            buf.append(" : ");
        }
        buf.append(descr.getObjectType());
        buf.append("( ");
        if (!descr.getConstraint().getDescrs().isEmpty()) {
            buf.append(this.processColoumnConstraintList(descr.getConstraint().getDescrs()));
        }
        buf.append(" )");
        if (descr.getSource() != null) {
            buf.append(" from ");
            this.template = buf.toString();
            this.visit(descr.getSource());
            buf.append(this.template);
        }
        this.template = buf.toString();
    }

    public void visitEvalDescr(EvalDescr descr) {
        this.template = new String();
        this.template = "\t\teval ( " + descr.getContent() + " )" + eol;
    }

    public void visitExistsDescr(ExistsDescr descr) {
        this.template = new String();
        this.template = !descr.getDescrs().isEmpty() ? "\t\texists " + this.processDescrList(descr.getDescrs()) + ";" : "";
    }

    public void visitCollectDescr(CollectDescr descr) {
        String tmpstr = new String();
        tmpstr = String.valueOf(tmpstr) + " collect (";
        this.visitPatternDescr(descr.getInputPattern());
        tmpstr = String.valueOf(tmpstr) + this.template.substring(2);
        this.template = String.valueOf(tmpstr) + ");";
    }

    public void visitAccumulateDescr(AccumulateDescr descr) {
        String tmpstr = new String();
        tmpstr = String.valueOf(tmpstr) + " accumulate (";
        if (descr.isSinglePattern()) {
            this.visitPatternDescr(descr.getInputPattern());
        } else {
            this.visit(descr.getInput());
        }
        tmpstr = String.valueOf(tmpstr) + this.template.substring(2);
        if (descr.isExternalFunction()) {
            tmpstr = String.valueOf(tmpstr) + "," + descr.getFunctionIdentifier() + "(" + descr.getExpression() + ")";
        } else {
            tmpstr = String.valueOf(tmpstr) + ", init(" + descr.getInitCode() + "), ";
            tmpstr = String.valueOf(tmpstr) + "action(" + descr.getActionCode() + "), ";
            if (descr.getReverseCode() != null) {
                tmpstr = String.valueOf(tmpstr) + " reverse(" + descr.getReverseCode() + "), ";
            }
            tmpstr = String.valueOf(tmpstr) + "result(" + descr.getResultCode() + ")";
        }
        this.template = String.valueOf(tmpstr) + ");";
    }

    public void visitFromDescr(FromDescr descr) {
        this.template = descr.getDataSource().toString();
    }

    public void visitForallDescr(ForallDescr descr) {
        String localstr = new String();
        localstr = String.valueOf(localstr) + "\t\tforall ( ";
        localstr = String.valueOf(localstr) + eol;
        for (Object obj : descr.getDescrs()) {
            this.visit(obj);
            localstr = String.valueOf(localstr) + this.template + eol;
        }
        this.template = localstr;
        this.template = String.valueOf(this.template) + "\t\t)";
        this.template = String.valueOf(this.template) + eol;
    }

    public void visitFieldBindingDescr(FieldBindingDescr descr) {
        this.template = new String();
        this.template = String.valueOf(descr.getIdentifier()) + " : " + descr.getFieldName();
    }

    public void visitFunctionDescr(FunctionDescr functionDescr) {
        this.template = new String();
        String parameterTemplate = this.processParameters(functionDescr.getParameterNames(), functionDescr.getParameterTypes());
        this.template = "function " + functionDescr.getReturnType() + " " + functionDescr.getName() + "(" + parameterTemplate + "){" + functionDescr.getText() + eol + "}" + eol;
    }

    public void visitLiteralRestrictionDescr(LiteralRestrictionDescr descr) {
        this.template = "";
        String text = descr.getText();
        if (text == null || descr.getType() == 1) {
            text = "null";
        } else if (descr.getType() == 2) {
            try {
                Integer.parseInt(text);
            }
            catch (NumberFormatException e) {
                text = "\"" + text + "\"";
            }
        } else if (descr.getType() == 3) {
            text = "\"" + text + "\"";
        }
        this.template = String.valueOf(descr.getEvaluator()) + " " + text;
    }

    public void visitQualifiedIdentifierRestrictionDescr(QualifiedIdentifierRestrictionDescr descr) {
        this.template = String.valueOf(descr.getEvaluator()) + " " + descr.getText();
    }

    public void visitRestrictionConnectiveDescr(RestrictionConnectiveDescr descr) {
        String tmp;
        this.template = tmp = this.processFieldConstraint(descr, true);
    }

    public void visitNotDescr(NotDescr descr) {
        this.template = new String();
        this.template = !descr.getDescrs().isEmpty() ? "\t   not ( " + this.processDescrList(descr.getDescrs()) + ")" : "";
    }

    public void visitOrDescr(OrDescr descr) {
        this.template = new String();
        this.template = !descr.getDescrs().isEmpty() ? this.processOrDescrList(descr.getDescrs()) : " ";
    }

    public void visitPackageDescr(PackageDescr packageDescr) {
        String packageName = packageDescr.getName();
        String xmlString = "package " + packageName + ";" + eol + eol;
        this.appendDrlDump(xmlString);
        if (packageDescr.getImports() != null) {
            this.appendDrlDump(this.processImportsList(packageDescr.getImports()));
        }
        if (packageDescr.getGlobals() != null) {
            this.appendDrlDump(this.processGlobalsList(packageDescr.getGlobals()));
        }
        if (packageDescr.getFunctionImports() != null) {
            this.appendDrlDump(this.processFunctionImportsList(packageDescr.getFunctionImports()));
        }
        if (packageDescr.getFunctions() != null) {
            this.appendDrlDump(this.processFunctionsList(packageDescr.getFunctions()));
        }
        if (packageDescr.getRules() != null) {
            this.appendDrlDump(this.processRules(packageDescr.getRules()));
        }
    }

    public void visitPredicateDescr(PredicateDescr descr) {
        this.template = new String();
        this.template = "eval( " + descr.getContent() + " )";
    }

    public void visitReturnValueRestrictionDescr(ReturnValueRestrictionDescr descr) {
        this.template = new String();
        this.template = String.valueOf(descr.getEvaluator()) + " ( " + descr.getContent() + ")";
    }

    public void visitQueryDescr(QueryDescr descr) {
        this.template = new String();
        this.template = "query \"" + descr.getName() + "\"" + this.processDescrList(descr.getLhs().getDescrs()) + "end";
    }

    private String processRules(List rules) {
        String ruleList = "";
        for (Object ruleobj : rules) {
            if (ruleobj instanceof QueryDescr) {
                this.visitQueryDescr((QueryDescr)ruleobj);
                ruleList = String.valueOf(ruleList) + this.template;
                break;
            }
            RuleDescr ruleDescr = (RuleDescr)ruleobj;
            String rule = "rule \"" + ruleDescr.getName() + "\" " + eol;
            String attribute = this.processAttribute(ruleDescr.getAttributes().values());
            String lhs = "";
            lhs = !ruleDescr.getLhs().getDescrs().isEmpty() ? "\t when" + eol + this.processDescrList(ruleDescr.getLhs().getDescrs()) + eol : "\t when";
            String rhs = (String)ruleDescr.getConsequence();
            rhs = rhs == null ? "\t then" + eol + "\t" : "\t then" + eol + ruleDescr.getConsequence();
            rule = String.valueOf(rule) + attribute;
            rule = String.valueOf(rule) + lhs;
            rule = String.valueOf(rule) + rhs;
            rule = String.valueOf(rule) + "end" + eol;
            ruleList = String.valueOf(ruleList) + rule;
        }
        return String.valueOf(ruleList) + eol;
    }

    private String processOrDescrList(List descr) {
        String descrString = "";
        Iterator iterator = descr.iterator();
        while (iterator.hasNext()) {
            this.visit(iterator.next());
            descrString = String.valueOf(descrString) + this.template;
            if (descrString.endsWith(eol)) {
                descrString = descrString.substring(0, descrString.indexOf(eol));
            }
            descrString = String.valueOf(descrString) + " || ";
        }
        return descrString.substring(0, descrString.length() - 4);
    }

    private String processColoumnConstraintList(List descr) {
        String descrString = "";
        Object previous = null;
        for (Object temp : descr) {
            this.visit(temp);
            if (previous == null) {
                descrString = String.valueOf(descrString) + this.template;
            } else if (previous instanceof FieldBindingDescr && !(temp instanceof FieldBindingDescr) && !(temp instanceof PredicateDescr)) {
                FieldConstraintDescr tempDescr = (FieldConstraintDescr)temp;
                FieldBindingDescr previousDescr = previous;
                descrString = tempDescr.getFieldName().equals(previousDescr.getFieldName()) ? String.valueOf(descrString) + this.template.substring(tempDescr.getFieldName().length() + 1) : String.valueOf(descrString) + " , " + this.template;
            } else {
                descrString = String.valueOf(descrString) + " , " + this.template;
            }
            previous = temp;
        }
        return descrString.substring(0, descrString.length());
    }

    private String processFieldConstraint(RestrictionConnectiveDescr restriction, boolean addBrackets) {
        String descrString = "";
        String connective = "";
        boolean bracketTmp = this.needsBracket;
        this.needsBracket = restriction.getRestrictions().size() > 1;
        connective = restriction.getConnective() == RestrictionConnectiveDescr.OR ? " || " : " && ";
        if (addBrackets && bracketTmp) {
            descrString = String.valueOf(descrString) + "( ";
        }
        Iterator<RestrictionDescr> it = restriction.getRestrictions().iterator();
        while (it.hasNext()) {
            RestrictionDescr temp = it.next();
            this.visit(temp);
            descrString = String.valueOf(descrString) + this.template;
            if (!it.hasNext()) continue;
            descrString = String.valueOf(descrString) + connective;
        }
        if (addBrackets && bracketTmp) {
            descrString = String.valueOf(descrString) + " )";
        }
        this.needsBracket = bracketTmp;
        return descrString;
    }

    private String processDescrList(List descr) {
        String descrString = "";
        Iterator ite = descr.iterator();
        while (ite.hasNext()) {
            Object obj = ite.next();
            this.visit(obj);
            descrString = String.valueOf(descrString) + this.template;
            if (obj.getClass().equals(PatternDescr.class) || obj.getClass().equals(CollectDescr.class)) {
                descrString = String.valueOf(descrString) + eol;
                continue;
            }
            if (!ite.hasNext()) continue;
            descrString = String.valueOf(descrString) + " && ";
        }
        return descrString;
    }

    private String processFunctionsList(List functions) {
        String functionList = "";
        Iterator it = functions.iterator();
        while (it.hasNext()) {
            this.visit(it.next());
            functionList = String.valueOf(functionList) + this.template;
        }
        return String.valueOf(functionList) + eol;
    }

    private String processAttribute(Collection<AttributeDescr> attributes) {
        String attributeList = "";
        for (AttributeDescr attributeDescr : attributes) {
            this.visit(attributeDescr);
            attributeList = String.valueOf(attributeList) + this.template;
        }
        return attributeList;
    }

    private String processParameters(List parameterNames, List parameterTypes) {
        if (parameterNames.isEmpty()) {
            return "";
        }
        String paramList = "";
        int i = 0;
        for (String paramName : parameterNames) {
            String paramType = (String)parameterTypes.get(i);
            String paramTemplate = String.valueOf(paramType) + " " + paramName + ",";
            paramList = String.valueOf(paramList) + paramTemplate;
            ++i;
        }
        paramList = paramList.substring(0, paramList.length() - 1);
        return paramList;
    }

    private String processGlobalsList(List globals) {
        String globalList = "";
        for (GlobalDescr global : globals) {
            String identifier = global.getIdentifier();
            String type = global.getType();
            String globalTemplate = "global " + type + " " + identifier + ";" + eol;
            globalList = String.valueOf(globalList) + globalTemplate;
        }
        return String.valueOf(globalList) + eol;
    }

    private String processFunctionImportsList(List imports) {
        String importList = "";
        Iterator it = imports.iterator();
        while (it.hasNext()) {
            String importString = ((FunctionImportDescr)it.next()).getTarget();
            String importTemplate = "import function " + importString + ";" + eol;
            importList = String.valueOf(importList) + importTemplate;
        }
        return String.valueOf(importList) + eol;
    }

    private String processImportsList(List imports) {
        String importList = "";
        for (ImportDescr importDescr : imports) {
            String importTemplate = "import " + importDescr.getTarget() + ";" + eol;
            importList = String.valueOf(importList) + importTemplate;
        }
        return String.valueOf(importList) + eol;
    }

    private void appendDrlDump(String temp) {
        this.drlDump.append(temp);
    }
}

