/*
 * Decompiled with CFR 0.152.
 */
package org.drools.lang;

import java.util.Iterator;
import org.drools.base.evaluators.Operator;
import org.drools.core.util.ReflectiveVisitor;
import org.drools.lang.descr.FieldBindingDescr;
import org.drools.lang.descr.FieldConstraintDescr;
import org.drools.lang.descr.LiteralRestrictionDescr;
import org.drools.lang.descr.PredicateDescr;
import org.drools.lang.descr.QualifiedIdentifierRestrictionDescr;
import org.drools.lang.descr.RestrictionConnectiveDescr;
import org.drools.lang.descr.RestrictionDescr;
import org.drools.lang.descr.ReturnValueRestrictionDescr;
import org.drools.lang.descr.VariableRestrictionDescr;

public class MVELDumper
extends ReflectiveVisitor {
    private StringBuilder mvelDump;
    private boolean isDateField;
    private static final String eol = System.getProperty("line.separator");
    private String template;
    private String fieldName;

    public String dump(FieldConstraintDescr fieldConstr) {
        return this.dump(fieldConstr, false);
    }

    public String dump(FieldConstraintDescr fieldConstr, boolean isDateField) {
        this.mvelDump = new StringBuilder();
        this.isDateField = isDateField;
        this.visit(fieldConstr);
        return this.mvelDump.toString();
    }

    public void visitFieldConstraintDescr(FieldConstraintDescr descr) {
        if (!descr.getRestrictions().isEmpty()) {
            this.fieldName = descr.getFieldName();
            this.mvelDump.append(this.processFieldConstraint(descr.getRestriction()));
        }
    }

    public void visitVariableRestrictionDescr(VariableRestrictionDescr descr) {
        this.template = this.processRestriction(descr.getEvaluator(), descr.isNegated(), descr.getIdentifier());
    }

    public void visitFieldBindingDescr(FieldBindingDescr descr) {
    }

    public void visitLiteralRestrictionDescr(LiteralRestrictionDescr descr) {
        String text = descr.getText();
        if (text == null || descr.getType() == 1) {
            text = "null";
        } else if (descr.getType() == 2) {
            try {
                Integer.parseInt(text);
            }
            catch (NumberFormatException e) {
                text = "\"" + text + "\"";
            }
        } else if (descr.getType() == 3) {
            text = "\"" + text + "\"";
            if (this.isDateField) {
                text = "org.drools.util.DateUtils.parseDate( " + text + " )";
            }
        }
        this.template = this.processRestriction(descr.getEvaluator(), descr.isNegated(), text);
    }

    public void visitQualifiedIdentifierRestrictionDescr(QualifiedIdentifierRestrictionDescr descr) {
        this.template = this.processRestriction(descr.getEvaluator(), descr.isNegated(), descr.getText());
    }

    public void visitRestrictionConnectiveDescr(RestrictionConnectiveDescr descr) {
        this.template = "( " + this.processFieldConstraint(descr) + " )";
    }

    public void visitPredicateDescr(PredicateDescr descr) {
        this.template = "eval( " + descr.getContent() + " )";
    }

    public void visitReturnValueRestrictionDescr(ReturnValueRestrictionDescr descr) {
        this.template = this.processRestriction(descr.getEvaluator(), descr.isNegated(), "( " + descr.getContent().toString() + " )");
    }

    private String processFieldConstraint(RestrictionConnectiveDescr restriction) {
        String descrString = "";
        String connective = null;
        connective = restriction.getConnective() == RestrictionConnectiveDescr.OR ? " || " : " && ";
        Iterator<RestrictionDescr> it = restriction.getRestrictions().iterator();
        while (it.hasNext()) {
            RestrictionDescr temp = it.next();
            this.visit(temp);
            descrString = String.valueOf(descrString) + this.template;
            if (!it.hasNext()) continue;
            descrString = String.valueOf(descrString) + connective;
        }
        return descrString;
    }

    private String processRestriction(String evaluator, boolean isNegated, String value) {
        Operator op = Operator.determineOperator((String)evaluator, (boolean)isNegated);
        if (op == Operator.determineOperator((String)"memberOf", (boolean)false)) {
            evaluator = "contains";
            return String.valueOf(this.evaluatorPrefix(evaluator)) + value + " " + this.evaluator(evaluator) + " " + this.fieldName + this.evaluatorSufix(evaluator);
        }
        if (op == Operator.determineOperator((String)"memberOf", (boolean)true)) {
            evaluator = "not contains";
            return String.valueOf(this.evaluatorPrefix(evaluator)) + value + " " + this.evaluator(evaluator) + " " + this.fieldName + this.evaluatorSufix(evaluator);
        }
        if (op == Operator.determineOperator((String)"excludes", (boolean)false)) {
            evaluator = "not contains";
            return String.valueOf(this.evaluatorPrefix(evaluator)) + this.fieldName + " " + this.evaluator(evaluator) + " " + value + this.evaluatorSufix(evaluator);
        }
        if (op == Operator.determineOperator((String)"matches", (boolean)false)) {
            evaluator = "~=";
            return String.valueOf(this.evaluatorPrefix(evaluator)) + this.fieldName + " " + this.evaluator(evaluator) + " " + value.replaceAll("\\\\", "\\\\\\\\") + this.evaluatorSufix(evaluator);
        }
        if (op == Operator.determineOperator((String)"matches", (boolean)true)) {
            evaluator = "not ~=";
            return String.valueOf(this.evaluatorPrefix(evaluator)) + this.fieldName + " " + this.evaluator(evaluator) + " " + value.replaceAll("\\\\", "\\\\\\\\") + this.evaluatorSufix(evaluator);
        }
        return String.valueOf(this.evaluatorPrefix(evaluator)) + this.fieldName + " " + this.evaluator(evaluator) + " " + value + this.evaluatorSufix(evaluator);
    }

    private String evaluatorPrefix(String evaluator) {
        if (evaluator.startsWith("not")) {
            return "!( ";
        }
        return "";
    }

    private String evaluator(String evaluator) {
        if (evaluator.startsWith("not")) {
            return evaluator.substring(4);
        }
        return evaluator;
    }

    private String evaluatorSufix(String evaluator) {
        if (evaluator.startsWith("not")) {
            return " )";
        }
        return "";
    }
}

