/*
 * Decompiled with CFR 0.152.
 */
package org.drools.lang.dsl;

import java.util.Map;
import java.util.regex.Pattern;
import org.drools.lang.dsl.AbstractDSLMappingEntry;
import org.drools.lang.dsl.DSLMappingEntry;
import org.mvel2.util.ParseTools;

public class AntlrDSLMappingEntry
extends AbstractDSLMappingEntry {
    private static final String HEAD_TAG = "__HEAD__";
    private static final String TAIL_TAG = "__TAIL__";
    private boolean headMatchGroupAdded = false;
    private boolean tailMatchGroupAdded = false;

    public AntlrDSLMappingEntry() {
        this(DSLMappingEntry.ANY, DSLMappingEntry.EMPTY_METADATA, null, null, null, null);
    }

    public AntlrDSLMappingEntry(DSLMappingEntry.Section section, DSLMappingEntry.MetaData metadata, String key, String value, String keyPattern, String valuePattern) {
        this.setSection(section);
        this.setMetaData(metadata);
        this.setMappingKey(key);
        this.setMappingValue(value);
        this.setKeyPattern(keyPattern);
        this.setValuePattern(valuePattern);
    }

    public void setKeyPattern(String keyPat) {
        if (keyPat != null) {
            String trimmed = keyPat.trim();
            String keyPattern = trimmed.replaceAll("\\$", "\\\\\\$");
            if (!(keyPattern = keyPattern.replaceAll("\\\\#", "#")).startsWith("^")) {
                keyPattern = "(\\W|^)" + keyPattern;
                this.getVariables().put(HEAD_TAG, 0);
                this.headMatchGroupAdded = true;
            }
            if (keyPattern.endsWith("(.*?)")) {
                keyPattern = String.valueOf(keyPattern) + "$";
            } else {
                keyPattern = String.valueOf(keyPattern) + "(\\W|$)";
                this.getVariables().put(TAIL_TAG, 1);
                this.tailMatchGroupAdded = true;
            }
            this.fixVariableOffsets();
            if (trimmed.startsWith("-") && !trimmed.startsWith("-\\s*")) {
                int index = keyPattern.indexOf(45) + 1;
                keyPattern = String.valueOf(keyPattern.substring(0, index)) + "\\s*" + keyPattern.substring(index).trim();
            }
            keyPattern = keyPattern.replaceAll("\\s+", "\\\\s+");
            keyPattern = keyPattern.replaceAll("(\\\\s\\+)+", "\\\\s+");
            this.setKeyPattern(Pattern.compile(keyPattern, 40));
        } else {
            this.setKeyPattern((Pattern)null);
        }
    }

    private void fixVariableOffsets() {
        char[] input = this.getMappingKey().toCharArray();
        int counter = 1;
        boolean insideCurly = false;
        if (this.headMatchGroupAdded) {
            this.getVariables().put(HEAD_TAG, counter);
            ++counter;
        }
        int i = 0;
        while (i < input.length) {
            switch (input[i]) {
                case '\\': {
                    ++i;
                    break;
                }
                case '(': {
                    ++counter;
                    break;
                }
                case '{': {
                    if (insideCurly) {
                        i = ParseTools.balancedCapture((char[])input, (int)i, (char)'{');
                        break;
                    }
                    insideCurly = true;
                    this.updateVariableIndex(i, counter);
                    ++counter;
                    break;
                }
                case '}': {
                    if (!insideCurly) break;
                    insideCurly = false;
                }
            }
            ++i;
        }
        if (this.tailMatchGroupAdded) {
            this.getVariables().put(TAIL_TAG, counter);
        }
    }

    private void updateVariableIndex(int offset, int counter) {
        String subs = this.getMappingKey().substring(offset);
        for (Map.Entry<String, Integer> entry : this.getVariables().entrySet()) {
            if (!subs.startsWith("{" + entry.getKey()) || subs.charAt(entry.getKey().length() + 1) != '}' && subs.charAt(entry.getKey().length() + 1) != ':') continue;
            entry.setValue(counter);
            break;
        }
    }

    public void setValuePattern(String value) {
        if (value != null) {
            StringBuilder valuePatternBuffer = new StringBuilder();
            if (this.headMatchGroupAdded) {
                valuePatternBuffer.append("$1");
            }
            valuePatternBuffer.append(value);
            if (value.endsWith(" ")) {
                valuePatternBuffer.deleteCharAt(valuePatternBuffer.length() - 1);
            }
            if (this.tailMatchGroupAdded) {
                int tailIndex = this.getVariables().get(TAIL_TAG);
                valuePatternBuffer.append("$" + tailIndex);
            }
            String pat = valuePatternBuffer.toString().replaceAll("\\\\#", "#").replaceAll("\\\\n", "\n");
            for (Map.Entry<String, Integer> entry : this.getVariables().entrySet()) {
                pat = pat.replaceAll("\\{" + entry.getKey() + "(:(.*?))?\\}", "\\$" + entry.getValue());
            }
            super.setValuePattern(pat);
        }
    }
}

