/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.xml.rules;

import java.util.HashSet;
import org.drools.lang.descr.AccumulateDescr;
import org.drools.lang.descr.AndDescr;
import org.drools.lang.descr.CollectDescr;
import org.drools.lang.descr.ConditionalElementDescr;
import org.drools.lang.descr.EvalDescr;
import org.drools.lang.descr.ExistsDescr;
import org.drools.lang.descr.ForallDescr;
import org.drools.lang.descr.NotDescr;
import org.drools.lang.descr.OrDescr;
import org.drools.lang.descr.PatternDescr;
import org.drools.lang.descr.PatternDestinationDescr;
import org.drools.xml.BaseAbstractHandler;
import org.drools.xml.ExtensibleXmlParser;
import org.drools.xml.Handler;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class PatternHandler
extends BaseAbstractHandler
implements Handler {
    public PatternHandler() {
        if (this.validParents == null && this.validPeers == null) {
            this.validParents = new HashSet();
            this.validParents.add(AndDescr.class);
            this.validParents.add(OrDescr.class);
            this.validParents.add(NotDescr.class);
            this.validParents.add(ExistsDescr.class);
            this.validParents.add(CollectDescr.class);
            this.validParents.add(ForallDescr.class);
            this.validParents.add(AccumulateDescr.class);
            this.validPeers = new HashSet();
            this.validPeers.add(null);
            this.validPeers.add(AndDescr.class);
            this.validPeers.add(OrDescr.class);
            this.validPeers.add(NotDescr.class);
            this.validPeers.add(ExistsDescr.class);
            this.validPeers.add(EvalDescr.class);
            this.validPeers.add(PatternDescr.class);
            this.validPeers.add(ForallDescr.class);
            this.allowNesting = true;
        }
    }

    public Object start(String uri, String localName, Attributes attrs, ExtensibleXmlParser parser) throws SAXException {
        parser.startElementBuilder(localName, attrs);
        String objectType = attrs.getValue("object-type");
        if (objectType == null || objectType.trim().equals("")) {
            throw new SAXParseException("<pattern> requires an 'object-type' attribute", parser.getLocator());
        }
        PatternDescr patternDescr = null;
        String identifier = attrs.getValue("identifier");
        patternDescr = identifier == null || identifier.trim().equals("") ? new PatternDescr(objectType) : new PatternDescr(objectType, identifier);
        return patternDescr;
    }

    public Object end(String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        Element element = parser.endElementBuilder();
        PatternDescr patternDescr = (PatternDescr)parser.getCurrent();
        Object parent = parser.getParent();
        if (parent instanceof PatternDestinationDescr) {
            PatternDestinationDescr parentDescr = (PatternDestinationDescr)parent;
            parentDescr.setInputPattern(patternDescr);
        } else {
            ConditionalElementDescr parentDescr = (ConditionalElementDescr)parent;
            parentDescr.addDescr(patternDescr);
        }
        return patternDescr;
    }

    public Class generateNodeFor() {
        return PatternDescr.class;
    }
}

