/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.xml.processes;

import org.drools.compiler.xml.processes.AbstractNodeHandler;
import org.drools.process.core.event.EventFilter;
import org.drools.process.core.event.EventTypeFilter;
import org.drools.workflow.core.Node;
import org.drools.workflow.core.node.EventNode;
import org.drools.xml.ExtensibleXmlParser;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class EventNodeHandler
extends AbstractNodeHandler {
    protected Node createNode() {
        return new EventNode();
    }

    public Class generateNodeFor() {
        return EventNode.class;
    }

    public void handleNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        String scope;
        super.handleNode(node, element, uri, localName, parser);
        EventNode eventNode = (EventNode)node;
        String variableName = element.getAttribute("variableName");
        if (variableName != null && variableName.length() != 0) {
            eventNode.setVariableName(variableName);
        }
        if ((scope = element.getAttribute("scope")) != null && scope.length() != 0) {
            eventNode.setScope(scope);
        }
    }

    public void writeNode(Node node, StringBuilder xmlDump, boolean includeMeta) {
        String scope;
        EventNode eventNode = (EventNode)node;
        this.writeNode("eventNode", (Node)eventNode, xmlDump, includeMeta);
        String variableName = eventNode.getVariableName();
        if (variableName != null && variableName.length() != 0) {
            xmlDump.append("variableName=\"" + variableName + "\" ");
        }
        if ((scope = eventNode.getScope()) != null && scope.length() != 0) {
            xmlDump.append("scope=\"" + scope + "\" ");
        }
        xmlDump.append(">" + EOL);
        if (includeMeta) {
            this.writeMetaData((Node)eventNode, xmlDump);
        }
        xmlDump.append("      <eventFilters>" + EOL);
        for (EventFilter filter : eventNode.getEventFilters()) {
            if (filter instanceof EventTypeFilter) {
                xmlDump.append("        <eventFilter type=\"eventType\" eventType=\"" + ((EventTypeFilter)filter).getType() + "\" />" + EOL);
                continue;
            }
            throw new IllegalArgumentException("Unknown filter type: " + filter);
        }
        xmlDump.append("      </eventFilters>" + EOL);
        this.endNode("eventNode", xmlDump);
    }
}

