/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.xml.processes;

import java.util.Map;
import org.drools.compiler.xml.XmlDumper;
import org.drools.compiler.xml.processes.AbstractNodeHandler;
import org.drools.workflow.core.Constraint;
import org.drools.workflow.core.Node;
import org.drools.workflow.core.impl.ConnectionRef;
import org.drools.workflow.core.node.Split;
import org.drools.xml.ExtensibleXmlParser;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class SplitNodeHandler
extends AbstractNodeHandler {
    protected Node createNode() {
        return new Split();
    }

    public void handleNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        super.handleNode(node, element, uri, localName, parser);
        Split splitNode = (Split)node;
        String type = element.getAttribute("type");
        if (type != null && type.length() != 0) {
            splitNode.setType(new Integer(type).intValue());
        }
    }

    public Class generateNodeFor() {
        return Split.class;
    }

    public void writeNode(Node node, StringBuilder xmlDump, boolean includeMeta) {
        Split splitNode = (Split)node;
        this.writeNode("split", (Node)splitNode, xmlDump, includeMeta);
        int type = splitNode.getType();
        if (type != 0) {
            xmlDump.append("type=\"" + type + "\" ");
        }
        if (splitNode.getConstraints().isEmpty()) {
            this.endNode(xmlDump);
        } else {
            xmlDump.append(">" + EOL);
            if (includeMeta) {
                this.writeMetaData((Node)splitNode, xmlDump);
            }
            xmlDump.append("      <constraints>" + EOL);
            for (Map.Entry entry : splitNode.getConstraints().entrySet()) {
                String constraintString;
                int priority;
                ConnectionRef connection = (ConnectionRef)entry.getKey();
                Constraint constraint = (Constraint)entry.getValue();
                xmlDump.append("        <constraint toNodeId=\"" + connection.getNodeId() + "\" " + "toType=\"" + connection.getToType() + "\" ");
                String name = constraint.getName();
                if (name != null && !"".equals(name)) {
                    xmlDump.append("name=\"" + XmlDumper.replaceIllegalChars(constraint.getName()) + "\" ");
                }
                if ((priority = constraint.getPriority()) != 0) {
                    xmlDump.append("priority=\"" + constraint.getPriority() + "\" ");
                }
                xmlDump.append("type=\"" + constraint.getType() + "\" ");
                String dialect = constraint.getDialect();
                if (dialect != null && !"".equals(dialect)) {
                    xmlDump.append("dialect=\"" + dialect + "\" ");
                }
                if ((constraintString = constraint.getConstraint()) != null) {
                    xmlDump.append(">" + XmlDumper.replaceIllegalChars(constraintString) + "</constraint>" + EOL);
                    continue;
                }
                xmlDump.append("/>" + EOL);
            }
            xmlDump.append("      </constraints>" + EOL);
            this.endNode("split", xmlDump);
        }
    }
}

