/*
 * Decompiled with CFR 0.152.
 */
package org.drools.lang.descr;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Locale;
import org.drools.lang.descr.EvaluatorBasedRestrictionDescr;

public class LiteralRestrictionDescr
extends EvaluatorBasedRestrictionDescr {
    public static final int TYPE_NULL = 1;
    public static final int TYPE_NUMBER = 2;
    public static final int TYPE_STRING = 3;
    public static final int TYPE_BOOLEAN = 4;
    private static final long serialVersionUID = 510L;
    private int type;

    public LiteralRestrictionDescr() {
    }

    public LiteralRestrictionDescr(String evaluator, String text) {
        this(evaluator, false, null, text, 3);
    }

    public LiteralRestrictionDescr(String evaluator, boolean isNegated, String text) {
        this(evaluator, isNegated, null, text, 3);
    }

    public LiteralRestrictionDescr(String evaluator, boolean isNegated, String parameterText, String text, int type) {
        super(evaluator, isNegated, parameterText);
        this.setText(text);
        this.type = type;
    }

    public String toString() {
        return super.toString() + " " + this.getText();
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public Object getValue() {
        switch (this.type) {
            case 2: {
                try {
                    return DecimalFormat.getInstance(Locale.US).parse(this.getText());
                }
                catch (ParseException e) {
                    return this.getText();
                }
            }
            case 4: {
                return Boolean.valueOf(this.getText());
            }
        }
        return this.getText();
    }
}

