/*
 * Decompiled with CFR 0.152.
 */
package org.drools.commons.jci.compilers;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.drools.commons.jci.compilers.AbstractJavaCompiler;
import org.drools.commons.jci.compilers.CompilationResult;
import org.drools.commons.jci.compilers.EclipseCompilationProblem;
import org.drools.commons.jci.compilers.EclipseJavaCompilerSettings;
import org.drools.commons.jci.compilers.JavaCompilerSettings;
import org.drools.commons.jci.problems.CompilationProblem;
import org.drools.commons.jci.readers.ResourceReader;
import org.drools.commons.jci.stores.ResourceStore;
import org.drools.core.util.ClassUtils;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;

public final class EclipseJavaCompiler
extends AbstractJavaCompiler {
    private final EclipseJavaCompilerSettings defaultSettings;

    public EclipseJavaCompiler() {
        this(new EclipseJavaCompilerSettings());
    }

    public EclipseJavaCompiler(Map pSettings) {
        this.defaultSettings = new EclipseJavaCompilerSettings(pSettings);
    }

    public EclipseJavaCompiler(EclipseJavaCompilerSettings pSettings) {
        this.defaultSettings = pSettings;
    }

    public CompilationResult compile(String[] pSourceFiles, final ResourceReader pReader, final ResourceStore pStore, final ClassLoader pClassLoader, JavaCompilerSettings pSettings) {
        Map settingsMap = new EclipseJavaCompilerSettings(pSettings).toNativeSettings();
        final ArrayList<1> problems = new ArrayList<1>();
        ICompilationUnit[] compilationUnits = new ICompilationUnit[pSourceFiles.length];
        for (int i = 0; i < compilationUnits.length; ++i) {
            final String sourceFile = pSourceFiles[i];
            if (pReader.isAvailable(sourceFile)) {
                compilationUnits[i] = new CompilationUnit(pReader, sourceFile);
                continue;
            }
            CompilationProblem problem = new CompilationProblem(){

                public int getEndColumn() {
                    return 0;
                }

                public int getEndLine() {
                    return 0;
                }

                public String getFileName() {
                    return sourceFile;
                }

                public String getMessage() {
                    return "Source " + sourceFile + " could not be found";
                }

                public int getStartColumn() {
                    return 0;
                }

                public int getStartLine() {
                    return 0;
                }

                public boolean isError() {
                    return true;
                }

                public String toString() {
                    return this.getMessage();
                }
            };
            if (this.problemHandler != null) {
                this.problemHandler.handle(problem);
            }
            problems.add(problem);
        }
        if (problems.size() > 0) {
            CompilationProblem[] result = new CompilationProblem[problems.size()];
            problems.toArray(result);
            return new CompilationResult(result);
        }
        IErrorHandlingPolicy policy = DefaultErrorHandlingPolicies.proceedWithAllProblems();
        DefaultProblemFactory problemFactory = new DefaultProblemFactory(Locale.getDefault());
        INameEnvironment nameEnvironment = new INameEnvironment(){

            public NameEnvironmentAnswer findType(char[][] pCompoundTypeName) {
                StringBuilder result = new StringBuilder();
                for (int i = 0; i < pCompoundTypeName.length; ++i) {
                    if (i != 0) {
                        result.append('.');
                    }
                    result.append(pCompoundTypeName[i]);
                }
                return this.findType(result.toString());
            }

            public NameEnvironmentAnswer findType(char[] pTypeName, char[][] pPackageName) {
                StringBuilder result = new StringBuilder();
                for (int i = 0; i < pPackageName.length; ++i) {
                    result.append(pPackageName[i]);
                    result.append('.');
                }
                result.append(pTypeName);
                return this.findType(result.toString());
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private NameEnvironmentAnswer findType(String pClazzName) {
                NameEnvironmentAnswer nameEnvironmentAnswer;
                ByteArrayOutputStream baos;
                InputStream is;
                block23: {
                    NameEnvironmentAnswer nameEnvironmentAnswer2;
                    block22: {
                        if (this.isPackage(pClazzName)) {
                            return null;
                        }
                        String resourceName = ClassUtils.convertClassToResourcePath((String)pClazzName);
                        byte[] clazzBytes = pStore.read(resourceName);
                        if (clazzBytes != null) {
                            char[] fileName = pClazzName.toCharArray();
                            try {
                                ClassFileReader classFileReader = new ClassFileReader(clazzBytes, fileName, true);
                                return new NameEnvironmentAnswer((IBinaryType)classFileReader, null);
                            }
                            catch (ClassFormatException e) {
                                throw new RuntimeException("ClassFormatException in loading class '" + fileName + "' with JCI.");
                            }
                        }
                        is = null;
                        baos = null;
                        try {
                            try {
                                int count;
                                is = pClassLoader.getResourceAsStream(resourceName);
                                if (is == null) {
                                    nameEnvironmentAnswer2 = null;
                                    Object var12_13 = null;
                                    break block22;
                                }
                                byte[] buffer = new byte[8192];
                                baos = new ByteArrayOutputStream(buffer.length);
                                while ((count = is.read(buffer, 0, buffer.length)) > 0) {
                                    baos.write(buffer, 0, count);
                                }
                                baos.flush();
                                char[] fileName = pClazzName.toCharArray();
                                ClassFileReader classFileReader = new ClassFileReader(baos.toByteArray(), fileName, true);
                                nameEnvironmentAnswer = new NameEnvironmentAnswer((IBinaryType)classFileReader, null);
                                break block23;
                            }
                            catch (IOException e) {
                                throw new RuntimeException("could not read class", e);
                            }
                            catch (ClassFormatException e) {
                                throw new RuntimeException("wrong class format", e);
                            }
                        }
                        catch (Throwable throwable) {
                            Object var12_15 = null;
                            try {
                                if (baos != null) {
                                    baos.close();
                                }
                            }
                            catch (IOException oe) {
                                throw new RuntimeException("could not close output stream", oe);
                            }
                            try {
                                if (is == null) throw throwable;
                                is.close();
                                throw throwable;
                            }
                            catch (IOException ie) {
                                throw new RuntimeException("could not close input stream", ie);
                            }
                        }
                    }
                    try {}
                    catch (IOException oe) {
                        throw new RuntimeException("could not close output stream", oe);
                    }
                    if (baos != null) {
                        baos.close();
                    }
                    try {}
                    catch (IOException ie) {
                        throw new RuntimeException("could not close input stream", ie);
                    }
                    if (is == null) return nameEnvironmentAnswer2;
                    is.close();
                    return nameEnvironmentAnswer2;
                }
                Object var12_14 = null;
                try {}
                catch (IOException oe) {
                    throw new RuntimeException("could not close output stream", oe);
                }
                if (baos != null) {
                    baos.close();
                }
                try {}
                catch (IOException ie) {
                    throw new RuntimeException("could not close input stream", ie);
                }
                if (is == null) return nameEnvironmentAnswer;
                is.close();
                return nameEnvironmentAnswer;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isPackage(String pClazzName) {
                boolean bl;
                block14: {
                    InputStream is;
                    block12: {
                        boolean bl2;
                        block13: {
                            block10: {
                                boolean bl3;
                                block11: {
                                    is = null;
                                    try {
                                        is = pClassLoader.getResourceAsStream(ClassUtils.convertClassToResourcePath((String)pClazzName));
                                        if (is == null) break block10;
                                        bl3 = false;
                                        Object var6_5 = null;
                                        if (is == null) break block11;
                                    }
                                    catch (Throwable throwable) {
                                        Object var6_8 = null;
                                        if (is != null) {
                                            try {
                                                is.close();
                                            }
                                            catch (IOException e) {
                                                throw new RuntimeException("Unable to close stream for resource: " + pClazzName);
                                            }
                                        }
                                        throw throwable;
                                    }
                                    try {
                                        is.close();
                                    }
                                    catch (IOException e) {
                                        throw new RuntimeException("Unable to close stream for resource: " + pClazzName);
                                    }
                                }
                                return bl3;
                            }
                            String source = pClazzName.replace('.', '/') + ".java";
                            if (!pReader.isAvailable(source)) break block12;
                            bl2 = false;
                            Object var6_6 = null;
                            if (is == null) break block13;
                            try {
                                is.close();
                            }
                            catch (IOException e) {
                                throw new RuntimeException("Unable to close stream for resource: " + pClazzName);
                            }
                        }
                        return bl2;
                    }
                    bl = true;
                    Object var6_7 = null;
                    if (is == null) break block14;
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Unable to close stream for resource: " + pClazzName);
                    }
                }
                return bl;
            }

            public boolean isPackage(char[][] parentPackageName, char[] pPackageName) {
                StringBuilder result = new StringBuilder();
                if (parentPackageName != null) {
                    for (int i = 0; i < parentPackageName.length; ++i) {
                        if (i != 0) {
                            result.append('.');
                        }
                        result.append(parentPackageName[i]);
                    }
                }
                if (parentPackageName != null && parentPackageName.length > 0) {
                    result.append('.');
                }
                result.append(pPackageName);
                return this.isPackage(result.toString());
            }

            public void cleanup() {
            }
        };
        ICompilerRequestor compilerRequestor = new ICompilerRequestor(){

            public void acceptResult(org.eclipse.jdt.internal.compiler.CompilationResult pResult) {
                int i;
                if (pResult.hasProblems()) {
                    CategorizedProblem[] iproblems = pResult.getProblems();
                    for (i = 0; i < iproblems.length; ++i) {
                        CategorizedProblem iproblem = iproblems[i];
                        EclipseCompilationProblem problem = new EclipseCompilationProblem((IProblem)iproblem);
                        if (EclipseJavaCompiler.this.problemHandler != null) {
                            EclipseJavaCompiler.this.problemHandler.handle(problem);
                        }
                        problems.add(problem);
                    }
                }
                if (!pResult.hasErrors()) {
                    ClassFile[] clazzFiles = pResult.getClassFiles();
                    for (i = 0; i < clazzFiles.length; ++i) {
                        ClassFile clazzFile = clazzFiles[i];
                        char[][] compoundName = clazzFile.getCompoundName();
                        StringBuilder clazzName = new StringBuilder();
                        for (int j = 0; j < compoundName.length; ++j) {
                            if (j != 0) {
                                clazzName.append('.');
                            }
                            clazzName.append(compoundName[j]);
                        }
                        pStore.write(clazzName.toString().replace('.', '/') + ".class", clazzFile.getBytes());
                    }
                }
            }
        };
        Compiler compiler = new Compiler(nameEnvironment, policy, settingsMap, compilerRequestor, (IProblemFactory)problemFactory, false);
        compiler.compile(compilationUnits);
        CompilationProblem[] result = new CompilationProblem[problems.size()];
        problems.toArray(result);
        return new CompilationResult(result);
    }

    public JavaCompilerSettings createDefaultSettings() {
        return this.defaultSettings;
    }

    final class CompilationUnit
    implements ICompilationUnit {
        private final String clazzName;
        private final String fileName;
        private final char[] typeName;
        private final char[][] packageName;
        private final ResourceReader reader;

        CompilationUnit(ResourceReader pReader, String pSourceFile) {
            this.reader = pReader;
            this.clazzName = ClassUtils.convertResourceToClassName((String)pSourceFile);
            this.fileName = pSourceFile;
            int dot = this.clazzName.lastIndexOf(46);
            this.typeName = dot > 0 ? this.clazzName.substring(dot + 1).toCharArray() : this.clazzName.toCharArray();
            StringTokenizer izer = new StringTokenizer(this.clazzName, ".");
            this.packageName = new char[izer.countTokens() - 1][];
            for (int i = 0; i < this.packageName.length; ++i) {
                this.packageName[i] = izer.nextToken().toCharArray();
            }
        }

        public char[] getFileName() {
            return this.fileName.toCharArray();
        }

        public char[] getContents() {
            byte[] content = this.reader.getBytes(this.fileName);
            if (content == null) {
                return null;
            }
            return new String(content).toCharArray();
        }

        public char[] getMainTypeName() {
            return this.typeName;
        }

        public char[][] getPackageName() {
            return this.packageName;
        }
    }
}

