/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder.dialect.mvel;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.drools.base.EvaluatorWrapper;
import org.drools.compiler.BoundIdentifiers;
import org.drools.compiler.DescrBuildError;
import org.drools.definition.rule.Rule;
import org.drools.rule.builder.PackageBuildContext;
import org.drools.rule.builder.dialect.mvel.MVELAnalysisResult;
import org.drools.rule.builder.dialect.mvel.MVELDialect;
import org.mvel2.MVEL;
import org.mvel2.ParserConfiguration;
import org.mvel2.ParserContext;
import org.mvel2.util.PropertyTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MVELExprAnalyzer {
    public MVELAnalysisResult analyzeExpression(PackageBuildContext context, String expr, BoundIdentifiers availableIdentifiers, Map<String, Class<?>> localTypes, String contextIndeifier, Class kcontextClass) {
        MVELAnalysisResult result = null;
        if (expr.trim().length() > 0) {
            MVEL.COMPILER_OPT_ALLOW_NAKED_METH_CALL = true;
            MVELDialect dialect = (MVELDialect)context.getDialect("mvel");
            ParserConfiguration conf = new ParserConfiguration();
            conf.setImports(dialect.getImports());
            conf.setPackageImports((HashSet)dialect.getPackgeImports());
            conf.setClassLoader((ClassLoader)context.getPackageBuilder().getRootClassLoader());
            ParserContext parserContext1 = new ParserContext(conf);
            if (localTypes != null) {
                for (Map.Entry<String, Class<?>> entry : localTypes.entrySet()) {
                    parserContext1.addInput(entry.getKey(), entry.getValue());
                }
            }
            if (availableIdentifiers.getThisClass() != null) {
                parserContext1.addInput("this", availableIdentifiers.getThisClass());
            }
            parserContext1.setStrictTypeEnforcement(false);
            parserContext1.setStrongTyping(false);
            parserContext1.setInterceptors(dialect.getInterceptors());
            Class returnType = null;
            try {
                returnType = MVEL.analyze((String)expr, (ParserContext)parserContext1);
            }
            catch (Exception e) {
                context.getErrors().add(new DescrBuildError(context.getParentDescr(), null, null, "Unable to Analyse Expression " + expr + ":\n" + e.getMessage()));
                return null;
            }
            HashSet<String> requiredInputs = new HashSet<String>();
            requiredInputs.addAll(parserContext1.getInputs().keySet());
            HashMap variables = parserContext1.getVariables();
            if (availableIdentifiers.getThisClass() != null) {
                Iterator it = requiredInputs.iterator();
                while (it.hasNext()) {
                    if (PropertyTools.getFieldOrAccessor(availableIdentifiers.getThisClass(), (String)((String)it.next())) == null) continue;
                    it.remove();
                }
            }
            ParserContext parserContext2 = new ParserContext(conf);
            parserContext2.setStrictTypeEnforcement(true);
            parserContext2.setStrongTyping(true);
            parserContext2.setInterceptors(dialect.getInterceptors());
            if (context.isTypesafe()) {
                if (localTypes != null) {
                    for (Map.Entry entry : localTypes.entrySet()) {
                        parserContext2.addInput((String)entry.getKey(), (Class)entry.getValue());
                    }
                }
                for (String string : requiredInputs) {
                    Class<Object> cls = availableIdentifiers.getDeclarations().get(string);
                    if (cls != null) {
                        parserContext2.addInput(string, cls);
                        continue;
                    }
                    if (cls == null && (cls = availableIdentifiers.getGlobals().get(string)) != null) {
                        parserContext2.addInput(string, cls);
                        continue;
                    }
                    if (cls == null) {
                        Class<Object> clazz = cls = availableIdentifiers.getOperators().keySet().contains(string) ? EvaluatorWrapper.class : null;
                        if (cls != null) {
                            parserContext2.addInput(string, cls);
                            continue;
                        }
                    }
                    if (cls != null) continue;
                    if (string.equals(contextIndeifier)) {
                        parserContext2.addInput(contextIndeifier, kcontextClass);
                    } else if (string.equals("kcontext")) {
                        parserContext2.addInput("kcontext", kcontextClass);
                    }
                    if (!string.equals("rule")) continue;
                    parserContext2.addInput("rule", Rule.class);
                }
                if (availableIdentifiers.getThisClass() != null) {
                    parserContext2.addInput("this", availableIdentifiers.getThisClass());
                }
                try {
                    returnType = MVEL.analyze((String)expr, (ParserContext)parserContext2);
                }
                catch (Exception e) {
                    context.getErrors().add(new DescrBuildError(context.getParentDescr(), null, null, "Unable to Analyse Expression " + expr + ":\n" + e.getMessage()));
                    return null;
                }
                requiredInputs = new HashSet();
                requiredInputs.addAll(parserContext2.getInputs().keySet());
                requiredInputs.addAll(variables.keySet());
                variables = parserContext2.getVariables();
            }
            result = this.analyze(requiredInputs, availableIdentifiers);
            result.setReturnType(returnType);
            result.setMvelVariables(variables);
        } else {
            result = this.analyze(Collections.EMPTY_SET, availableIdentifiers);
            result.setMvelVariables(new HashMap());
        }
        return result;
    }

    private MVELAnalysisResult analyze(Set<String> identifiers, BoundIdentifiers availableIdentifiers) {
        MVELAnalysisResult result = new MVELAnalysisResult();
        result.setIdentifiers(identifiers);
        HashSet<String> notBound = new HashSet<String>(identifiers);
        notBound.remove("this");
        HashMap usedDecls = new HashMap();
        HashMap usedGlobals = new HashMap();
        HashMap<String, EvaluatorWrapper> usedOperators = new HashMap<String, EvaluatorWrapper>();
        for (Map.Entry<String, Class<?>> entry : availableIdentifiers.getDeclarations().entrySet()) {
            if (!identifiers.contains(entry.getKey())) continue;
            usedDecls.put(entry.getKey(), entry.getValue());
            notBound.remove(entry.getKey());
        }
        for (Map.Entry<String, Class<?>> entry : availableIdentifiers.getGlobals().entrySet()) {
            if (!identifiers.contains(entry.getKey())) continue;
            usedGlobals.put(entry.getKey(), entry.getValue());
            notBound.remove(entry.getKey());
        }
        for (Map.Entry<String, Class<?>> entry : availableIdentifiers.getOperators().entrySet()) {
            if (!identifiers.contains(entry.getKey())) continue;
            usedOperators.put(entry.getKey(), (EvaluatorWrapper)entry.getValue());
            notBound.remove(entry);
        }
        result.setBoundIdentifiers(new BoundIdentifiers(usedDecls, usedGlobals, usedOperators, availableIdentifiers.getThisClass()));
        result.setNotBoundedIdentifiers(notBound);
        return result;
    }
}

