/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder.dialect.mvel;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.drools.base.EvaluatorWrapper;
import org.drools.base.ModifyInterceptor;
import org.drools.base.TypeResolver;
import org.drools.base.mvel.MVELCompilationUnit;
import org.drools.commons.jci.readers.MemoryResourceReader;
import org.drools.compiler.AnalysisResult;
import org.drools.compiler.BoundIdentifiers;
import org.drools.compiler.DescrBuildError;
import org.drools.compiler.Dialect;
import org.drools.compiler.ImportError;
import org.drools.compiler.PackageBuilder;
import org.drools.compiler.PackageRegistry;
import org.drools.core.util.StringUtils;
import org.drools.definition.rule.Rule;
import org.drools.io.Resource;
import org.drools.lang.descr.AccumulateDescr;
import org.drools.lang.descr.AndDescr;
import org.drools.lang.descr.BaseDescr;
import org.drools.lang.descr.CollectDescr;
import org.drools.lang.descr.EntryPointDescr;
import org.drools.lang.descr.EvalDescr;
import org.drools.lang.descr.ExistsDescr;
import org.drools.lang.descr.ForallDescr;
import org.drools.lang.descr.FromDescr;
import org.drools.lang.descr.FunctionDescr;
import org.drools.lang.descr.NotDescr;
import org.drools.lang.descr.OrDescr;
import org.drools.lang.descr.PatternDescr;
import org.drools.lang.descr.ProcessDescr;
import org.drools.lang.descr.QueryDescr;
import org.drools.lang.descr.RuleDescr;
import org.drools.rule.Declaration;
import org.drools.rule.DialectRuntimeData;
import org.drools.rule.LineMappings;
import org.drools.rule.MVELDialectRuntimeData;
import org.drools.rule.Package;
import org.drools.rule.builder.AccumulateBuilder;
import org.drools.rule.builder.CollectBuilder;
import org.drools.rule.builder.ConsequenceBuilder;
import org.drools.rule.builder.EnabledBuilder;
import org.drools.rule.builder.EngineElementBuilder;
import org.drools.rule.builder.EntryPointBuilder;
import org.drools.rule.builder.ForallBuilder;
import org.drools.rule.builder.FromBuilder;
import org.drools.rule.builder.GroupElementBuilder;
import org.drools.rule.builder.PackageBuildContext;
import org.drools.rule.builder.PatternBuilder;
import org.drools.rule.builder.PredicateBuilder;
import org.drools.rule.builder.QueryBuilder;
import org.drools.rule.builder.ReturnValueBuilder;
import org.drools.rule.builder.RuleBuildContext;
import org.drools.rule.builder.RuleClassBuilder;
import org.drools.rule.builder.RuleConditionBuilder;
import org.drools.rule.builder.SalienceBuilder;
import org.drools.rule.builder.dialect.DialectUtil;
import org.drools.rule.builder.dialect.java.JavaFunctionBuilder;
import org.drools.rule.builder.dialect.mvel.MVELAccumulateBuilder;
import org.drools.rule.builder.dialect.mvel.MVELAnalysisResult;
import org.drools.rule.builder.dialect.mvel.MVELConsequenceBuilder;
import org.drools.rule.builder.dialect.mvel.MVELDialectConfiguration;
import org.drools.rule.builder.dialect.mvel.MVELEnabledBuilder;
import org.drools.rule.builder.dialect.mvel.MVELEvalBuilder;
import org.drools.rule.builder.dialect.mvel.MVELExprAnalyzer;
import org.drools.rule.builder.dialect.mvel.MVELFromBuilder;
import org.drools.rule.builder.dialect.mvel.MVELPredicateBuilder;
import org.drools.rule.builder.dialect.mvel.MVELReturnValueBuilder;
import org.drools.rule.builder.dialect.mvel.MVELSalienceBuilder;
import org.drools.spi.KnowledgeHelper;
import org.mvel2.MVEL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MVELDialect
implements Dialect,
Externalizable {
    private String id = "mvel";
    private static final String EXPRESSION_DIALECT_NAME = "MVEL";
    protected static final PatternBuilder PATTERN_BUILDER = new PatternBuilder();
    protected static final QueryBuilder QUERY_BUILDER = new QueryBuilder();
    protected static final MVELAccumulateBuilder ACCUMULATE_BUILDER = new MVELAccumulateBuilder();
    protected static final SalienceBuilder SALIENCE_BUILDER = new MVELSalienceBuilder();
    protected static final EnabledBuilder ENABLED_BUILDER = new MVELEnabledBuilder();
    protected static final MVELEvalBuilder EVAL_BUILDER = new MVELEvalBuilder();
    protected static final MVELPredicateBuilder PREDICATE_BUILDER = new MVELPredicateBuilder();
    protected static final MVELReturnValueBuilder RETURN_VALUE_BUILDER = new MVELReturnValueBuilder();
    protected static final MVELConsequenceBuilder CONSEQUENCE_BUILDER = new MVELConsequenceBuilder();
    protected static final MVELFromBuilder FROM_BUILDER = new MVELFromBuilder();
    protected static final JavaFunctionBuilder FUNCTION_BUILDER = new JavaFunctionBuilder();
    protected static final CollectBuilder COLLECT_BUILDER = new CollectBuilder();
    protected static final ForallBuilder FORALL_BUILDER = new ForallBuilder();
    protected static final EntryPointBuilder ENTRY_POINT_BUILDER = new EntryPointBuilder();
    protected static final GroupElementBuilder GE_BUILDER = new GroupElementBuilder();
    private static Map<Class<?>, EngineElementBuilder> builders;
    private static final MVELExprAnalyzer analyzer;
    private Map interceptors;
    protected List results;
    protected MemoryResourceReader src;
    protected Package pkg;
    private MVELDialectConfiguration configuration;
    private PackageBuilder pkgBuilder;
    private PackageRegistry packageRegistry;
    private boolean strictMode;
    private int languageLevel;
    private MVELDialectRuntimeData data;

    public MVELDialect(PackageBuilder builder, PackageRegistry pkgRegistry, Package pkg) {
        this(builder, pkgRegistry, pkg, "mvel");
    }

    public MVELDialect(PackageBuilder builder, PackageRegistry pkgRegistry, Package pkg, String id) {
        this.id = id;
        this.pkg = pkg;
        this.pkgBuilder = builder;
        this.packageRegistry = pkgRegistry;
        this.configuration = (MVELDialectConfiguration)builder.getPackageBuilderConfiguration().getDialectConfiguration("mvel");
        this.setLanguageLevel(this.configuration.getLangLevel());
        this.strictMode = this.configuration.isStrict();
        MVEL.COMPILER_OPT_ALLOW_NAKED_METH_CALL = true;
        this.interceptors = new HashMap(1);
        this.interceptors.put("Modify", new ModifyInterceptor());
        this.results = new ArrayList();
        if (pkg.getDialectRuntimeRegistry().getDialectData(this.getId()) == null) {
            this.data = new MVELDialectRuntimeData();
            this.pkg.getDialectRuntimeRegistry().setDialectData(this.getId(), (DialectRuntimeData)this.data);
            this.data.onAdd(this.pkg.getDialectRuntimeRegistry(), this.pkgBuilder.getRootClassLoader());
        } else {
            this.data = (MVELDialectRuntimeData)this.pkg.getDialectRuntimeRegistry().getDialectData("mvel");
        }
        this.results = new ArrayList();
        this.src = new MemoryResourceReader();
        if (this.pkg != null) {
            this.addImport(this.pkg.getName() + ".*");
        }
        this.addImport("java.lang.*");
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.interceptors = (Map)in.readObject();
        this.results = (List)in.readObject();
        this.src = (MemoryResourceReader)in.readObject();
        this.pkg = (Package)in.readObject();
        this.packageRegistry = (PackageRegistry)in.readObject();
        this.configuration = (MVELDialectConfiguration)in.readObject();
        this.strictMode = in.readBoolean();
        this.data = (MVELDialectRuntimeData)this.pkg.getDialectRuntimeRegistry().getDialectData("mvel");
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.interceptors);
        out.writeObject(this.results);
        out.writeObject(this.src);
        out.writeObject(this.pkg);
        out.writeObject(this.packageRegistry);
        out.writeObject(this.configuration);
        out.writeBoolean(this.strictMode);
        out.writeObject(this.data);
    }

    public void setLanguageLevel(int languageLevel) {
        this.languageLevel = languageLevel;
    }

    public static void initBuilder() {
        if (builders != null) {
            return;
        }
        builders = new HashMap();
        builders.put(AndDescr.class, GE_BUILDER);
        builders.put(OrDescr.class, GE_BUILDER);
        builders.put(NotDescr.class, GE_BUILDER);
        builders.put(ExistsDescr.class, GE_BUILDER);
        builders.put(PatternDescr.class, PATTERN_BUILDER);
        builders.put(FromDescr.class, FROM_BUILDER);
        builders.put(QueryDescr.class, QUERY_BUILDER);
        builders.put(AccumulateDescr.class, ACCUMULATE_BUILDER);
        builders.put(EvalDescr.class, EVAL_BUILDER);
        builders.put(CollectDescr.class, COLLECT_BUILDER);
        builders.put(ForallDescr.class, FORALL_BUILDER);
        builders.put(FunctionDescr.class, FUNCTION_BUILDER);
        builders.put(EntryPointDescr.class, ENTRY_POINT_BUILDER);
    }

    @Override
    public void init(RuleDescr ruleDescr) {
        String pkgName = this.pkg == null ? "" : this.pkg.getName();
        String ruleClassName = DialectUtil.getUniqueLegalName(pkgName, ruleDescr.getName(), "mvel", "Rule", this.src);
        ruleDescr.setClassName(StringUtils.ucFirst((String)ruleClassName));
    }

    @Override
    public void init(ProcessDescr processDescr) {
        String processDescrClassName = DialectUtil.getUniqueLegalName(this.pkg.getName(), processDescr.getName(), "mvel", "Process", this.src);
        processDescr.setClassName(StringUtils.ucFirst((String)processDescrClassName));
    }

    @Override
    public String getExpressionDialectName() {
        return EXPRESSION_DIALECT_NAME;
    }

    @Override
    public void addRule(RuleBuildContext context) {
        RuleDescr ruleDescr = context.getRuleDescr();
        String name = this.pkg.getName() + "." + StringUtils.ucFirst((String)ruleDescr.getClassName());
        LineMappings mapping = new LineMappings(name);
        mapping.setStartLine(ruleDescr.getConsequenceLine());
        mapping.setOffset(ruleDescr.getConsequenceOffset());
        context.getPkg().getDialectRuntimeRegistry().getLineMappings().put(name, mapping);
    }

    @Override
    public void addFunction(FunctionDescr functionDescr, TypeResolver typeResolver, Resource resource) {
    }

    @Override
    public void preCompileAddFunction(FunctionDescr functionDescr, TypeResolver typeResolver) {
    }

    @Override
    public void postCompileAddFunction(FunctionDescr functionDescr, TypeResolver typeResolver) {
    }

    @Override
    public void addImport(String importEntry) {
        if (importEntry.endsWith(".*")) {
            importEntry = importEntry.substring(0, importEntry.length() - 2);
            this.data.addPackageImport(importEntry);
        } else {
            try {
                Class cls = this.packageRegistry.getTypeResolver().resolveType(importEntry);
                this.data.addImport(cls.getSimpleName(), cls);
            }
            catch (ClassNotFoundException e) {
                this.results.add(new ImportError(importEntry, 1));
            }
        }
    }

    @Override
    public void addStaticImport(String staticImportEntry) {
        if (staticImportEntry.endsWith("*")) {
            return;
        }
        int index = staticImportEntry.lastIndexOf(46);
        String className = staticImportEntry.substring(0, index);
        String methodName = staticImportEntry.substring(index + 1);
        try {
            Class cls = this.pkgBuilder.getRootClassLoader().loadClass(className);
            if (cls != null) {
                for (Method method : cls.getDeclaredMethods()) {
                    if (!method.getName().equals(methodName)) continue;
                    this.data.addImport(methodName, method);
                    return;
                }
                for (AccessibleObject accessibleObject : cls.getFields()) {
                    if (!accessibleObject.isAccessible() || !((Field)accessibleObject).getName().equals(methodName)) continue;
                    this.data.addImport(methodName, (Field)accessibleObject);
                    return;
                }
            }
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        this.results.add(new ImportError(staticImportEntry, -1));
    }

    public boolean isStrictMode() {
        return this.strictMode;
    }

    public void setStrictMode(boolean strictMode) {
        this.strictMode = strictMode;
    }

    @Override
    public void compileAll() {
    }

    @Override
    public AnalysisResult analyzeExpression(PackageBuildContext context, BaseDescr descr, Object content, BoundIdentifiers availableIdentifiers) {
        return this.analyzeExpression(context, descr, content, availableIdentifiers, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnalysisResult analyzeExpression(PackageBuildContext context, BaseDescr descr, Object content, BoundIdentifiers availableIdentifiers, Map<String, Class<?>> localTypes) {
        MVELAnalysisResult result = null;
        BaseDescr temp = context.getParentDescr();
        context.setParentDescr(descr);
        try {
            result = analyzer.analyzeExpression(context, (String)content, availableIdentifiers, localTypes, "drools", KnowledgeHelper.class);
        }
        catch (Exception e) {
            context.getErrors().add(new DescrBuildError(context.getParentDescr(), descr, null, "Unable to determine the used declarations.\n" + e.getMessage()));
        }
        finally {
            context.setParentDescr(temp);
        }
        return result;
    }

    @Override
    public AnalysisResult analyzeBlock(PackageBuildContext context, BaseDescr descr, String text, BoundIdentifiers availableIdentifiers) {
        return this.analyzeBlock(context, descr, null, text, availableIdentifiers, null, "drools", KnowledgeHelper.class);
    }

    public AnalysisResult analyzeBlock(PackageBuildContext context, BaseDescr descr, Map interceptors, String text, BoundIdentifiers availableIdentifiers, Map<String, Class<?>> localTypes, String contextIndeifier, Class kcontextClass) {
        MVELAnalysisResult result = null;
        result = analyzer.analyzeExpression(context, text, availableIdentifiers, localTypes, contextIndeifier, kcontextClass);
        return result;
    }

    public MVELCompilationUnit getMVELCompilationUnit(String expression, AnalysisResult analysis, Declaration[] previousDeclarations, Declaration[] localDeclarations, Map<String, Class<?>> otherInputVariables, PackageBuildContext context, String contextIndeifier, Class kcontextClass) {
        LinkedHashMap resolvedInputs = new LinkedHashMap();
        ArrayList<String> ids = new ArrayList<String>();
        if (analysis.getBoundIdentifiers().getThisClass() != null || localDeclarations != null && localDeclarations.length > 0) {
            Class<?> cls = analysis.getBoundIdentifiers().getThisClass();
            ids.add("this");
            resolvedInputs.put("this", cls != null ? cls : Object.class);
        }
        ids.add(contextIndeifier);
        resolvedInputs.put(contextIndeifier, kcontextClass);
        ids.add("kcontext");
        resolvedInputs.put("kcontext", kcontextClass);
        ids.add("rule");
        resolvedInputs.put("rule", Rule.class);
        ArrayList<String> strList = new ArrayList<String>();
        for (Map.Entry<String, Class<?>> e : analysis.getBoundIdentifiers().getGlobals().entrySet()) {
            strList.add(e.getKey());
            ids.add(e.getKey());
            resolvedInputs.put(e.getKey(), e.getValue());
        }
        String[] globalIdentifiers = strList.toArray(new String[strList.size()]);
        strList.clear();
        for (String op : analysis.getBoundIdentifiers().getOperators().keySet()) {
            strList.add(op);
            ids.add(op);
            resolvedInputs.put(op, EvaluatorWrapper.class);
        }
        EvaluatorWrapper[] operators = new EvaluatorWrapper[strList.size()];
        for (int i = 0; i < operators.length; ++i) {
            operators[i] = analysis.getBoundIdentifiers().getOperators().get(strList.get(i));
        }
        if (previousDeclarations != null) {
            for (Declaration decl : previousDeclarations) {
                if (!analysis.getBoundIdentifiers().getDeclrClasses().containsKey(decl.getIdentifier())) continue;
                ids.add(decl.getIdentifier());
                resolvedInputs.put(decl.getIdentifier(), decl.getExtractor().getExtractToClass());
            }
        }
        if (localDeclarations != null) {
            for (Declaration decl : localDeclarations) {
                if (!analysis.getBoundIdentifiers().getDeclrClasses().containsKey(decl.getIdentifier())) continue;
                ids.add(decl.getIdentifier());
                resolvedInputs.put(decl.getIdentifier(), decl.getExtractor().getExtractToClass());
            }
        }
        strList = new ArrayList();
        if (otherInputVariables != null) {
            boolean i = false;
            MVELAnalysisResult mvelAnalysis = (MVELAnalysisResult)analysis;
            for (Map.Entry<String, Class<?>> entry : otherInputVariables.entrySet()) {
                if (!analysis.getNotBoundedIdentifiers().contains(entry.getKey()) && !mvelAnalysis.getMvelVariables().keySet().contains(entry.getKey()) || "rule".equals(entry.getKey())) continue;
                ids.add(entry.getKey());
                strList.add(entry.getKey());
                resolvedInputs.put(entry.getKey(), entry.getValue());
            }
        }
        String[] otherIdentifiers = strList.toArray(new String[strList.size()]);
        String[] inputIdentifiers = new String[resolvedInputs.size()];
        String[] inputTypes = new String[resolvedInputs.size()];
        int i = 0;
        Iterator i$ = ids.iterator();
        while (i$.hasNext()) {
            String id;
            inputIdentifiers[i] = id = (String)i$.next();
            inputTypes[i++] = ((Class)resolvedInputs.get(id)).getName();
        }
        String name = context != null && context.getPkg() != null && context.getPkg().getName() != null ? (context instanceof RuleBuildContext ? context.getPkg().getName() + "." + ((RuleBuildContext)context).getRuleDescr().getClassName() : context.getPkg().getName() + ".Unknown") : "Unknown";
        MVELCompilationUnit compilationUnit = new MVELCompilationUnit(name, expression, globalIdentifiers, operators, previousDeclarations, localDeclarations, otherIdentifiers, inputIdentifiers, inputTypes, this.languageLevel, ((MVELAnalysisResult)analysis).isTypesafe());
        return compilationUnit;
    }

    @Override
    public EngineElementBuilder getBuilder(Class clazz) {
        return builders.get(clazz);
    }

    @Override
    public Map<Class<?>, EngineElementBuilder> getBuilders() {
        return builders;
    }

    @Override
    public PatternBuilder getPatternBuilder() {
        return PATTERN_BUILDER;
    }

    @Override
    public QueryBuilder getQueryBuilder() {
        return QUERY_BUILDER;
    }

    @Override
    public AccumulateBuilder getAccumulateBuilder() {
        return ACCUMULATE_BUILDER;
    }

    @Override
    public ConsequenceBuilder getConsequenceBuilder() {
        return CONSEQUENCE_BUILDER;
    }

    @Override
    public RuleConditionBuilder getEvalBuilder() {
        return EVAL_BUILDER;
    }

    @Override
    public FromBuilder getFromBuilder() {
        return FROM_BUILDER;
    }

    @Override
    public EntryPointBuilder getEntryPointBuilder() {
        return ENTRY_POINT_BUILDER;
    }

    @Override
    public PredicateBuilder getPredicateBuilder() {
        return PREDICATE_BUILDER;
    }

    public PredicateBuilder getExpressionPredicateBuilder() {
        return PREDICATE_BUILDER;
    }

    @Override
    public SalienceBuilder getSalienceBuilder() {
        return SALIENCE_BUILDER;
    }

    @Override
    public EnabledBuilder getEnabledBuilder() {
        return ENABLED_BUILDER;
    }

    @Override
    public List getResults() {
        return this.results;
    }

    @Override
    public ReturnValueBuilder getReturnValueBuilder() {
        return RETURN_VALUE_BUILDER;
    }

    @Override
    public RuleClassBuilder getRuleClassBuilder() {
        throw new UnsupportedOperationException("MVELDialect.getRuleClassBuilder is not supported");
    }

    @Override
    public TypeResolver getTypeResolver() {
        return this.packageRegistry.getTypeResolver();
    }

    public Map getInterceptors() {
        return this.interceptors;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public PackageRegistry getPackageRegistry() {
        return this.packageRegistry;
    }

    static {
        MVELDialect.initBuilder();
        analyzer = new MVELExprAnalyzer();
    }
}

