/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder;

import java.util.ArrayList;
import java.util.List;
import org.drools.base.ClassObjectType;
import org.drools.base.extractors.ArrayElementReader;
import org.drools.base.extractors.SelfReferenceClassFieldReader;
import org.drools.compiler.DescrBuildError;
import org.drools.compiler.DrlExprParser;
import org.drools.compiler.DroolsParserException;
import org.drools.lang.MVELDumper;
import org.drools.lang.descr.AtomicExprDescr;
import org.drools.lang.descr.BaseDescr;
import org.drools.lang.descr.BindingDescr;
import org.drools.lang.descr.ConstraintConnectiveDescr;
import org.drools.lang.descr.ExprConstraintDescr;
import org.drools.lang.descr.PatternDescr;
import org.drools.rule.Declaration;
import org.drools.rule.Pattern;
import org.drools.rule.Query;
import org.drools.rule.QueryElement;
import org.drools.rule.Rule;
import org.drools.rule.RuleConditionElement;
import org.drools.rule.builder.RuleBuildContext;
import org.drools.rule.builder.RuleConditionBuilder;
import org.drools.runtime.rule.Variable;
import org.drools.spi.InternalReadAccessor;
import org.drools.spi.ObjectType;
import org.mvel2.MVEL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryElementBuilder
implements RuleConditionBuilder {
    @Override
    public RuleConditionElement build(RuleBuildContext context, BaseDescr descr) {
        return this.build(context, descr, null);
    }

    @Override
    public RuleConditionElement build(RuleBuildContext context, BaseDescr descr, Pattern prefixPattern) {
        throw new UnsupportedOperationException();
    }

    public RuleConditionElement build(RuleBuildContext context, BaseDescr descr, Pattern prefixPattern, Query query) {
        PatternDescr patternDescr = (PatternDescr)descr;
        Declaration[] params = query.getParameters();
        List<? extends BaseDescr> args = patternDescr.getDescrs();
        ArrayList<Integer> declrIndexes = new ArrayList<Integer>();
        ArrayList<Integer> varIndexes = new ArrayList<Integer>();
        ArrayList<Object> arguments = new ArrayList<Object>(params.length);
        for (int i = 0; i < params.length; ++i) {
            arguments.add(null);
        }
        ArrayList<Declaration> requiredDeclarations = new ArrayList<Declaration>();
        ClassObjectType argsObjectType = ClassObjectType.ObjectArray_ObjectType;
        SelfReferenceClassFieldReader arrayReader = new SelfReferenceClassFieldReader(Object[].class, "this");
        Pattern pattern = new Pattern(context.getNextPatternId(), 0, (ObjectType)argsObjectType, null);
        int length = args.size();
        for (int i = 0; i < length; ++i) {
            BaseDescr base = args.get(i);
            String expression = null;
            boolean isPositional = false;
            boolean isBinding = false;
            BindingDescr bind = null;
            ConstraintConnectiveDescr result = null;
            if (base instanceof BindingDescr) {
                bind = (BindingDescr)base;
                expression = bind.getVariable() + (bind.isUnification() ? " := " : " : ") + bind.getExpression();
                isBinding = true;
            } else {
                if (base instanceof ExprConstraintDescr) {
                    ExprConstraintDescr ecd = (ExprConstraintDescr)base;
                    expression = ecd.getExpression();
                    isPositional = ecd.getType() == ExprConstraintDescr.Type.POSITIONAL;
                } else {
                    expression = base.getText();
                }
                result = this.parseExpression(context, patternDescr, expression);
                if (result == null) {
                    context.addError(new DescrBuildError(context.getParentDescr(), descr, null, "Unable to parse constraint: \n" + expression));
                    continue;
                }
                boolean bl = isBinding = result.getDescrs().size() == 1 && result.getDescrs().get(0) instanceof BindingDescr;
                if (isBinding) {
                    bind = (BindingDescr)result.getDescrs().get(0);
                }
            }
            if (!isPositional && !isBinding) {
                context.addError(new DescrBuildError(context.getParentDescr(), descr, null, "Query's must use positional or bindings, not field constraints:\n" + expression));
                continue;
            }
            if (isPositional && isBinding) {
                context.addError(new DescrBuildError(context.getParentDescr(), descr, null, "Query's can't use positional bindings:\n" + expression));
                continue;
            }
            if (isPositional) {
                this.processPositional(context, query, params, declrIndexes, varIndexes, arguments, requiredDeclarations, (InternalReadAccessor)arrayReader, pattern, base, expression, result);
                continue;
            }
            this.processBinding(context, descr, params, declrIndexes, varIndexes, arguments, requiredDeclarations, (InternalReadAccessor)arrayReader, pattern, bind, result);
        }
        Declaration[] declrsArray = requiredDeclarations.toArray(new Declaration[requiredDeclarations.size()]);
        int[] declrIndexArray = new int[declrIndexes.size()];
        for (int i = 0; i < declrsArray.length; ++i) {
            declrIndexArray[i] = (Integer)declrIndexes.get(i);
        }
        int[] varIndexesArray = new int[varIndexes.size()];
        for (int i = 0; i < varIndexesArray.length; ++i) {
            varIndexesArray[i] = (Integer)varIndexes.get(i);
        }
        return new QueryElement(pattern, query.getName(), arguments.toArray(new Object[arguments.size()]), declrsArray, declrIndexArray, varIndexesArray, !patternDescr.isQuery());
    }

    private void processBinding(RuleBuildContext context, BaseDescr descr, Declaration[] params, List<Integer> declrIndexes, List<Integer> varIndexes, List<Object> arguments, List<Declaration> requiredDeclarations, InternalReadAccessor arrayReader, Pattern pattern, BindingDescr bind, ConstraintConnectiveDescr result) {
        int pos;
        Declaration declr = context.getDeclarationResolver().getDeclaration(context.getRule(), bind.getVariable());
        if (declr != null && (pos = QueryElementBuilder.getPos(bind.getExpression(), params)) >= 0) {
            String slot = bind.getExpression();
            String var = bind.getVariable();
            bind.setVariable(slot);
            bind.setExpression(var);
        }
        if ((pos = QueryElementBuilder.getPos(bind.getVariable(), params)) >= 0) {
            declr = context.getDeclarationResolver().getDeclaration(context.getRule(), bind.getExpression());
            if (declr != null) {
                arguments.set(pos, declr);
                declrIndexes.add(pos);
                requiredDeclarations.add(declr);
            } else {
                DrlExprParser parser = new DrlExprParser();
                ConstraintConnectiveDescr bresult = parser.parse(bind.getExpression());
                if (parser.hasErrors()) {
                    for (DroolsParserException error : parser.getErrors()) {
                        context.addError(new DescrBuildError(context.getParentDescr(), descr, null, "Unable to parser pattern expression:\n" + error.getMessage()));
                    }
                    return;
                }
                MVELDumper.MVELDumperContext mvelCtx = new MVELDumper.MVELDumperContext();
                String expr = new MVELDumper().dump((BaseDescr)bresult, mvelCtx);
                try {
                    Object o = MVEL.eval((String)expr);
                    arguments.set(pos, o);
                }
                catch (Exception e) {
                    context.addError(new DescrBuildError(context.getParentDescr(), descr, null, "Unable to compile expression:\n" + expr));
                }
            }
        } else {
            declr = pattern.addDeclaration(bind.getVariable());
            pos = QueryElementBuilder.getPos(bind.getExpression(), params);
            if (pos < 0) {
                context.addError(new DescrBuildError(context.getParentDescr(), descr, null, "named argument does not exist:\n" + bind.getExpression()));
                return;
            }
            ArrayElementReader reader = new ArrayElementReader(arrayReader, pos, params[pos].getExtractor().getExtractToClass());
            declr.setReadAccessor((InternalReadAccessor)reader);
            varIndexes.add(pos);
            arguments.set(pos, Variable.v);
        }
    }

    private void processPositional(RuleBuildContext context, Query query, Declaration[] params, List<Integer> declrIndexes, List<Integer> varIndexes, List<Object> arguments, List<Declaration> requiredDeclarations, InternalReadAccessor arrayReader, Pattern pattern, BaseDescr base, String expression, ConstraintConnectiveDescr result) {
        int position = ((ExprConstraintDescr)base).getPosition();
        if (position >= arguments.size()) {
            context.addError(new DescrBuildError(context.getParentDescr(), base, null, "Unable to parse query '" + query.getName() + "', as postion " + (position - 1) + " for expression '" + expression + "' does not exist on query size " + arguments.size()));
            return;
        }
        if (QueryElementBuilder.isVariable(expression)) {
            Declaration declr = context.getDeclarationResolver().getDeclaration((Rule)query, expression);
            if (declr != null) {
                arguments.set(position, declr);
                declrIndexes.add(position);
                requiredDeclarations.add(declr);
            } else {
                arguments.set(position, Variable.v);
                varIndexes.add(position);
                declr = pattern.addDeclaration(expression);
                ArrayElementReader reader = new ArrayElementReader(arrayReader, position, params[position].getExtractor().getExtractToClass());
                declr.setReadAccessor((InternalReadAccessor)reader);
            }
        } else {
            MVELDumper.MVELDumperContext mvelCtx = new MVELDumper.MVELDumperContext();
            String rewrittenExpr = new MVELDumper().dump((BaseDescr)result, mvelCtx);
            arguments.set(position, MVEL.eval((String)rewrittenExpr));
        }
    }

    public static int getPos(String identifier, Declaration[] params) {
        for (int i = 0; i < params.length; ++i) {
            if (!params[i].getIdentifier().trim().equals(identifier)) continue;
            return i;
        }
        return -1;
    }

    public static boolean isAtomic(ConstraintConnectiveDescr result) {
        return result.getDescrs().size() == 1 && result.getDescrs().get(0) instanceof AtomicExprDescr;
    }

    private ConstraintConnectiveDescr parseExpression(RuleBuildContext context, PatternDescr patternDescr, String expression) {
        DrlExprParser parser = new DrlExprParser();
        ConstraintConnectiveDescr result = parser.parse(expression);
        if (result == null || parser.hasErrors()) {
            for (DroolsParserException error : parser.getErrors()) {
                context.addError(new DescrBuildError(context.getParentDescr(), patternDescr, null, "Unable to parser pattern expression:\n" + error.getMessage()));
            }
            return null;
        }
        return result;
    }

    public static boolean isVariable(String str) {
        str = str.trim();
        switch (str.charAt(0)) {
            case '!': 
            case '\"': 
            case '%': 
            case '&': 
            case '\'': 
            case '(': 
            case ')': 
            case '+': 
            case '-': 
            case '.': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': 
            case '<': 
            case '=': 
            case '>': 
            case '?': 
            case '[': 
            case ']': 
            case '^': 
            case '{': 
            case '|': 
            case '}': {
                return false;
            }
        }
        for (int i = 1; i < str.length(); ++i) {
            switch (str.charAt(i)) {
                case '!': 
                case '\"': 
                case '%': 
                case '&': 
                case '\'': 
                case '+': 
                case '-': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    return false;
                }
            }
        }
        return true;
    }
}

