/*
 * Decompiled with CFR 0.152.
 */
package org.drools.kproject;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.drools.kproject.File;
import org.drools.kproject.FileSystem;
import org.drools.kproject.Folder;
import org.drools.kproject.GenerateKBaseProjectFiles;
import org.drools.kproject.GenerateKSessionProducer;
import org.drools.kproject.KBase;
import org.drools.kproject.KProject;
import org.drools.kproject.KProjectChangeLog;
import org.drools.kproject.KSession;
import org.drools.kproject.KSessionImpl;

public class KProjectChangeLogCommiter {
    private KProject kProject;
    private KProjectChangeLog changeLog;
    private FileSystem fs;

    public static void commit(KProject kProject, KProjectChangeLog changeLog, FileSystem fs) {
        KProjectChangeLogCommiter committer = new KProjectChangeLogCommiter(kProject, changeLog, fs);
        committer.commitRemovedKBases();
        committer.commitAddedKBases();
        changeLog.reset();
    }

    public static void commit(KProject kProject, FileSystem fs) {
        KProjectChangeLogCommiter committer = new KProjectChangeLogCommiter(kProject, null, fs);
        for (KBase kBase : kProject.getKBases().values()) {
            committer.commitAddedKBase(kBase);
        }
    }

    private KProjectChangeLogCommiter(KProject kproject, KProjectChangeLog changeLog, FileSystem fs) {
        this.kProject = kproject;
        this.changeLog = changeLog;
        this.fs = fs;
    }

    public void commitAddedKBases() {
        for (String kBaseQName : this.changeLog.getAddedKBases()) {
            this.commitAddedKBase(this.kProject.getKBases().get(kBaseQName));
        }
    }

    public void commitAddedKBase(KBase kbase) {
        Folder rootFld = this.fs.getFolder(this.kProject.getKBasesPath() + "/" + kbase.getQName());
        rootFld.create();
        String filesStr = GenerateKBaseProjectFiles.generateKBaseFiles(this.kProject, kbase, this.fs);
        File rootFile = rootFld.getFile(kbase.getQName() + ".files.dat");
        try {
            if (!rootFile.exists()) {
                rootFile.create(new ByteArrayInputStream(filesStr.getBytes()));
            } else {
                rootFile.setContents(new ByteArrayInputStream(filesStr.getBytes()));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void commitRemovedKBases() {
        for (String kBaseQName : this.changeLog.getRemovedKBases()) {
            this.commitRemovedKBase(this.kProject.getKBases().get(kBaseQName));
        }
    }

    public void commitRemovedKBase(KBase kbase) {
        for (String kBaseQName : this.changeLog.getRemovedKBases()) {
            Folder rootFld = this.fs.getFolder(this.kProject.getKBasesPath() + "/" + kBaseQName);
            this.fs.remove(rootFld);
        }
    }

    public void commitAddedKSessions() {
        for (String kSessionQName : this.changeLog.getAddedKSessions()) {
            KSessionImpl kSession = (KSessionImpl)this.changeLog.getKSessions().get(kSessionQName);
            Folder rootFld = this.fs.getFolder(this.kProject.getKBasesPath() + "/" + kSession.getKBase().getQName());
            this.commitAddedKSession(rootFld, kSession.getKBase(), kSession);
        }
    }

    public void commitAddedKSession(Folder rootFld, KBase kBase, KSession kSession) {
        Folder namespaceFld = this.fs.getFolder(rootFld.getPath().toPortableString() + "/" + kSession.getNamespace().replace('.', '/'));
        namespaceFld.create();
        String qualifierStr = GenerateKSessionProducer.generateQualifier(kSession);
        File qualifieFile = namespaceFld.getFile(kSession.getName() + ".java");
        try {
            if (!qualifieFile.exists()) {
                qualifieFile.create(new ByteArrayInputStream(qualifierStr.getBytes()));
            } else {
                qualifieFile.setContents(new ByteArrayInputStream(qualifierStr.getBytes()));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String producerStr = GenerateKSessionProducer.generateProducer(kBase, kSession);
        File producerFile = namespaceFld.getFile(kSession.getName() + "Producer.java");
        try {
            if (!producerFile.exists()) {
                producerFile.create(new ByteArrayInputStream(producerStr.getBytes()));
            } else {
                producerFile.setContents(new ByteArrayInputStream(producerStr.getBytes()));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void commitRemovedKSessions() {
        for (String kSessionQName : this.changeLog.getRemovedKSessions()) {
            KSessionImpl kSession = (KSessionImpl)this.changeLog.getKSessions().get(kSessionQName);
            Folder rootFld = this.fs.getFolder(this.kProject.getKBasesPath() + "/" + kSession.getKBase().getQName());
            this.commitRemovedKSession(rootFld, kSession.getKBase(), kSession);
        }
    }

    public void commitRemovedKSession(Folder rootFld, KBase kBase, KSession kSession) {
        Folder namespaceFld = this.fs.getFolder(rootFld.getPath().toPortableString() + "/" + kSession.getNamespace().replace('.', '/'));
        File qualifieFile = namespaceFld.getFile(kSession.getName() + ".java");
        this.fs.remove(qualifieFile);
        File producerFile = namespaceFld.getFile(kSession.getName() + "Producer.java");
        this.fs.remove(producerFile);
    }
}

