/*
 * Decompiled with CFR 0.152.
 */
package org.drools.kproject.models;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.core.util.AbstractXStreamConverter;
import org.drools.kproject.models.KieBaseModelImpl;
import org.drools.kproject.models.KieSessionModelImpl;
import org.drools.kproject.models.ListenerModelImpl;
import org.drools.kproject.models.QualifierModelImpl;
import org.drools.kproject.models.WorkItemHandlerModelImpl;
import org.kie.builder.KieBaseModel;
import org.kie.builder.KieModuleModel;

public class KieModuleModelImpl
implements KieModuleModel {
    public static String KMODULE_JAR_PATH = "META-INF/kmodule.xml";
    public static String KMODULE_SRC_PATH = "src/main/resources/" + KMODULE_JAR_PATH;
    private Map<String, KieBaseModel> kBases = Collections.emptyMap();
    private static final kModuleMarshaller MARSHALLER = new kModuleMarshaller();

    public KieBaseModel newKieBaseModel(String name) {
        KieBaseModelImpl kbase = new KieBaseModelImpl(this, name);
        HashMap<String, KieBaseModel> newMap = new HashMap<String, KieBaseModel>();
        newMap.putAll(this.kBases);
        newMap.put(kbase.getName(), kbase);
        this.setKBases(newMap);
        return kbase;
    }

    public KieBaseModel newDefaultKieBaseModel() {
        if (this.kBases.containsKey("!DeFaUlT!")) {
            throw new RuntimeException("This project already contains a default kie base");
        }
        return this.newKieBaseModel("!DeFaUlT!");
    }

    public void removeKieBaseModel(String qName) {
        HashMap<String, KieBaseModel> newMap = new HashMap<String, KieBaseModel>();
        newMap.putAll(this.kBases);
        newMap.remove(qName);
        this.setKBases(newMap);
    }

    public void moveKBase(String oldQName, String newQName) {
        HashMap<String, KieBaseModel> newMap = new HashMap<String, KieBaseModel>();
        newMap.putAll(this.kBases);
        KieBaseModel kieBaseModel = (KieBaseModel)newMap.remove(oldQName);
        newMap.put(newQName, kieBaseModel);
        this.setKBases(newMap);
    }

    public Map<String, KieBaseModel> getKieBaseModels() {
        return Collections.unmodifiableMap(this.kBases);
    }

    private void setKBases(Map<String, KieBaseModel> kBases) {
        this.kBases = kBases;
    }

    List<String> validate() {
        ArrayList<String> problems = new ArrayList<String>();
        return problems;
    }

    public String toString() {
        return "KieProject [kbases=" + this.kBases + "]";
    }

    public String toXML() {
        return MARSHALLER.toXML(this);
    }

    public static KieModuleModel fromXML(InputStream kModuleStream) {
        return MARSHALLER.fromXML(kModuleStream);
    }

    public static KieModuleModel fromXML(File kModuleFile) {
        return MARSHALLER.fromXML(kModuleFile);
    }

    public static KieModuleModel fromXML(URL kModuleUrl) {
        return MARSHALLER.fromXML(kModuleUrl);
    }

    public static KieModuleModel fromXML(String kModuleString) {
        return MARSHALLER.fromXML(kModuleString);
    }

    public static class kModuleConverter
    extends AbstractXStreamConverter {
        public kModuleConverter() {
            super(KieModuleModelImpl.class);
        }

        public void marshal(Object value, HierarchicalStreamWriter writer, MarshallingContext context) {
            KieModuleModelImpl kModule = (KieModuleModelImpl)value;
            this.writeObjectList(writer, context, "kbases", "kbase", kModule.getKieBaseModels().values());
        }

        public Object unmarshal(HierarchicalStreamReader reader, final UnmarshallingContext context) {
            final KieModuleModelImpl kModule = new KieModuleModelImpl();
            this.readNodes(reader, new AbstractXStreamConverter.NodeReader(){

                public void onNode(HierarchicalStreamReader reader, String name, String value) {
                    if ("kbases".equals(name)) {
                        HashMap<String, KieBaseModelImpl> kBases = new HashMap<String, KieBaseModelImpl>();
                        for (KieBaseModelImpl kBase : kModuleConverter.this.readObjectList(reader, context, KieBaseModelImpl.class)) {
                            kBase.setKModule(kModule);
                            kBases.put(kBase.getName(), kBase);
                        }
                        kModule.setKBases(kBases);
                    }
                }
            });
            return kModule;
        }
    }

    private static class kModuleMarshaller {
        private final XStream xStream = new XStream((HierarchicalStreamDriver)new DomDriver());

        private kModuleMarshaller() {
            this.xStream.registerConverter((Converter)new kModuleConverter());
            this.xStream.registerConverter((Converter)new KieBaseModelImpl.KBaseConverter());
            this.xStream.registerConverter((Converter)new KieSessionModelImpl.KSessionConverter());
            this.xStream.registerConverter((Converter)new ListenerModelImpl.ListenerConverter());
            this.xStream.registerConverter((Converter)new QualifierModelImpl.QualifierConverter());
            this.xStream.registerConverter((Converter)new WorkItemHandlerModelImpl.WorkItemHandelerConverter());
            this.xStream.alias("kmodule", KieModuleModelImpl.class);
            this.xStream.alias("kbase", KieBaseModelImpl.class);
            this.xStream.alias("ksession", KieSessionModelImpl.class);
            this.xStream.alias("listener", ListenerModelImpl.class);
            this.xStream.alias("qualifier", QualifierModelImpl.class);
            this.xStream.alias("workItemHandler", WorkItemHandlerModelImpl.class);
        }

        public String toXML(KieModuleModel kieProject) {
            return this.xStream.toXML((Object)kieProject);
        }

        public KieModuleModel fromXML(InputStream kModuleStream) {
            return (KieModuleModel)this.xStream.fromXML(kModuleStream);
        }

        public KieModuleModel fromXML(File kModuleFile) {
            return (KieModuleModel)this.xStream.fromXML(kModuleFile);
        }

        public KieModuleModel fromXML(URL kModuleUrl) {
            return (KieModuleModel)this.xStream.fromXML(kModuleUrl);
        }

        public KieModuleModel fromXML(String kModuleString) {
            return (KieModuleModel)this.xStream.fromXML(kModuleString);
        }
    }
}

