/*
 * Decompiled with CFR 0.152.
 */
package org.kie.builder.impl;

import java.io.File;
import java.util.Collection;
import org.drools.commons.jci.readers.ResourceReader;
import org.drools.compiler.io.memory.MemoryFileSystem;
import org.kie.builder.GAV;
import org.kie.builder.KieModuleModel;
import org.kie.builder.impl.AbstractKieModule;

public class MemoryKieModule
extends AbstractKieModule
implements ResourceReader {
    private final MemoryFileSystem mfs;

    public MemoryKieModule(GAV gav, KieModuleModel kieProject, MemoryFileSystem mfs) {
        super(gav, kieProject);
        this.mfs = mfs;
    }

    @Override
    public boolean isAvailable(String path) {
        return this.mfs.existsFile(path);
    }

    @Override
    public byte[] getBytes(String path) {
        return this.mfs.getBytes(path);
    }

    @Override
    public Collection<String> getFileNames() {
        return this.mfs.getFileNames();
    }

    public MemoryFileSystem getMemoryFileSystem() {
        return this.mfs;
    }

    @Override
    public File getFile() {
        return null;
    }

    @Override
    public byte[] getBytes() {
        return null;
    }

    public String toString() {
        return "MemoryKieModule[ GAV=" + this.getGAV() + "]";
    }
}

