/*
 * Decompiled with CFR 0.152.
 */
package org.drools.lang.descr;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.drools.lang.descr.AnnotatedBaseDescr;

public class EnumLiteralDescr
extends AnnotatedBaseDescr
implements Comparable<EnumLiteralDescr> {
    private static final long serialVersionUID = 510L;
    private int index = -1;
    private String name;
    private List<String> constructorArgs = Collections.emptyList();

    public EnumLiteralDescr() {
        this(null);
    }

    public EnumLiteralDescr(String name) {
        this.name = name;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.index = in.readInt();
        this.name = (String)in.readObject();
        this.constructorArgs = (List)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.index);
        out.writeObject(this.name);
        out.writeObject(this.constructorArgs);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getConstructorArgs() {
        return this.constructorArgs;
    }

    public void setConstructorArgs(List<String> constructorArgs) {
        this.constructorArgs = constructorArgs;
    }

    public void addConstructorArg(String arg) {
        if (this.constructorArgs == Collections.EMPTY_LIST) {
            this.constructorArgs = new ArrayList<String>();
        }
        this.constructorArgs.add(arg);
    }

    public String toString() {
        return "EnumLiteralDescr{index=" + this.index + ", name='" + this.name + '\'' + ", constructorArgs='" + this.constructorArgs + '\'' + "} " + super.toString();
    }

    @Override
    public int compareTo(EnumLiteralDescr other) {
        return this.index - other.index;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }
}

