/*
 * Decompiled with CFR 0.152.
 */
package org.kie.builder.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import org.drools.core.util.IoUtils;
import org.kie.builder.ReleaseId;
import org.kie.builder.impl.AbstractKieModule;
import org.kie.builder.impl.InternalKieModule;
import org.kie.builder.model.KieModuleModel;

public class FileKieModule
extends AbstractKieModule
implements InternalKieModule {
    private final File file;

    public FileKieModule(ReleaseId releaseId, KieModuleModel kieProject, File file) {
        super(releaseId, kieProject);
        this.file = file;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public boolean isAvailable(String pResourceName) {
        return new File(this.file, pResourceName).exists();
    }

    @Override
    public byte[] getBytes(String pResourceName) {
        try {
            return IoUtils.readBytesFromInputStream((InputStream)new FileInputStream(new File(this.file, pResourceName)));
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to get bytes for: " + new File(this.file, pResourceName));
        }
    }

    @Override
    public Collection<String> getFileNames() {
        return IoUtils.recursiveListFile((File)this.file);
    }

    @Override
    public byte[] getBytes() {
        try {
            return IoUtils.readBytesFromInputStream((InputStream)new FileInputStream(this.file));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return "FileKieModule[ ReleaseId=" + this.getReleaseId() + "file=" + this.file + "]";
    }
}

