/*
 * Decompiled with CFR 0.152.
 */
package org.kie.builder.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.Collection;
import org.drools.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.PackageBuilder;
import org.drools.io.impl.BaseResource;
import org.kie.KieServices;
import org.kie.builder.CompositeKnowledgeBuilder;
import org.kie.builder.IncrementalResults;
import org.kie.builder.KieBuilderSet;
import org.kie.builder.KieModule;
import org.kie.builder.KnowledgeBuilder;
import org.kie.builder.KnowledgeBuilderError;
import org.kie.builder.KnowledgeBuilderResult;
import org.kie.builder.impl.AbstractKieModule;
import org.kie.builder.impl.IncrementalResultsImpl;
import org.kie.builder.impl.InternalKieModule;
import org.kie.builder.impl.KieBuilderImpl;
import org.kie.builder.model.KieBaseModel;
import org.kie.io.Resource;
import org.kie.io.ResourceConfiguration;
import org.kie.io.ResourceType;

public class KieBuilderSetImpl
implements KieBuilderSet {
    private final KieBuilderImpl kieBuilder;
    private final String[] files;

    public KieBuilderSetImpl(KieBuilderImpl kieBuilder, String[] files) {
        this.kieBuilder = kieBuilder;
        this.files = files;
    }

    public IncrementalResults build() {
        for (String file : this.files) {
            this.kieBuilder.copySourceToTarget(file);
        }
        return this.buildChanges();
    }

    private IncrementalResults buildChanges() {
        IncrementalResultsImpl results = new IncrementalResultsImpl();
        InternalKieModule kieModule = (InternalKieModule)this.kieBuilder.getKieModuleIgnoringErrors();
        for (KieBaseModel kBaseModel : kieModule.getKieModuleModel().getKieBaseModels().values()) {
            KnowledgeBuilder kBuilder = kieModule.getKnowledgeBuilderForKieBase(kBaseModel.getName());
            for (KnowledgeBuilderError error : kBuilder.getErrors()) {
                results.removeMessage((KnowledgeBuilderResult)error);
            }
            CompositeKnowledgeBuilder ckbuilder = kBuilder.batch();
            PackageBuilder pkgBuilder = ((KnowledgeBuilderImpl)kBuilder).getPackageBuilder();
            boolean modified = false;
            for (String file : this.files) {
                String resourceName = file.startsWith("src/main/resources/") ? file.substring("src/main/resources/".length()) : file;
                modified = pkgBuilder.removeObjectsGeneratedFromResource((Resource)new DummyResource(resourceName)) || modified;
                modified = this.addResource(ckbuilder, kBaseModel, kieModule, resourceName) || modified;
            }
            if (!modified) continue;
            ckbuilder.build();
            if (kBuilder.hasErrors()) {
                for (KnowledgeBuilderError error : kBuilder.getErrors()) {
                    results.addMessage((KnowledgeBuilderResult)error);
                }
                kBuilder.undo();
                continue;
            }
            KieServices.Factory.get().getRepository().addKieModule((KieModule)kieModule);
        }
        return results;
    }

    private boolean addResource(CompositeKnowledgeBuilder ckbuilder, KieBaseModel kieBaseModel, InternalKieModule kieModule, String resourceName) {
        byte[] bytes = kieModule.getBytes(resourceName);
        if (bytes == null) {
            return false;
        }
        Resource resource = KieServices.Factory.get().getResources().newByteArrayResource(bytes).setSourcePath(resourceName);
        if (KieBuilderImpl.filterFileInKBase(kieBaseModel, resourceName)) {
            ResourceConfiguration conf = AbstractKieModule.getResourceConfiguration(kieModule, resourceName);
            if (conf == null) {
                ckbuilder.add(resource, ResourceType.determineResourceType((String)resourceName));
            } else {
                ckbuilder.add(resource, ResourceType.determineResourceType((String)resourceName), conf);
            }
            return true;
        }
        return false;
    }

    public static class DummyResource
    extends BaseResource {
        public DummyResource(String resourceName) {
            this.setSourcePath(resourceName);
        }

        public URL getURL() throws IOException {
            throw new UnsupportedOperationException("org.kie.builder.impl.KieBuilderSetImpl.DummyResource.getURL -> TODO");
        }

        public boolean hasURL() {
            throw new UnsupportedOperationException("org.kie.builder.impl.KieBuilderSetImpl.DummyResource.hasURL -> TODO");
        }

        public boolean isDirectory() {
            throw new UnsupportedOperationException("org.kie.builder.impl.KieBuilderSetImpl.DummyResource.isDirectory -> TODO");
        }

        public Collection<Resource> listResources() {
            throw new UnsupportedOperationException("org.kie.builder.impl.KieBuilderSetImpl.DummyResource.listResources -> TODO");
        }

        public long getLastModified() {
            throw new UnsupportedOperationException("org.kie.builder.impl.KieBuilderSetImpl.DummyResource.getLastModified -> TODO");
        }

        public long getLastRead() {
            throw new UnsupportedOperationException("org.kie.builder.impl.KieBuilderSetImpl.DummyResource.getLastRead -> TODO");
        }

        public InputStream getInputStream() throws IOException {
            throw new UnsupportedOperationException("org.kie.builder.impl.KieBuilderSetImpl.DummyResource.getInputStream -> TODO");
        }

        public Reader getReader() throws IOException {
            throw new UnsupportedOperationException("org.kie.builder.impl.KieBuilderSetImpl.DummyResource.getReader -> TODO");
        }
    }
}

