/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.kie.builder.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import org.drools.compiler.kie.builder.impl.ClasspathKieProject;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.InternalKieScanner;
import org.drools.compiler.kproject.ReleaseIdImpl;
import org.drools.compiler.kproject.models.KieModuleModelImpl;
import org.drools.core.io.internal.InternalResource;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.KieRepository;
import org.kie.api.builder.KieScanner;
import org.kie.api.builder.ReleaseId;
import org.kie.api.io.Resource;
import org.kie.api.runtime.KieContainer;
import org.kie.internal.utils.ServiceRegistryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieRepositoryImpl
implements KieRepository {
    private static final Logger log = LoggerFactory.getLogger(KieRepositoryImpl.class);
    private static final String DEFAULT_VERSION = "1.0.0-SNAPSHOT";
    private static final String DEFAULT_ARTIFACT = "artifact";
    private static final String DEFAULT_GROUP = "org.default";
    static final KieRepositoryImpl INSTANCE = new KieRepositoryImpl();
    private final KieModuleRepo kieModuleRepo = new KieModuleRepo();
    private final AtomicReference<ReleaseId> defaultGAV = new AtomicReference<ReleaseIdImpl>(new ReleaseIdImpl("org.default", "artifact", "1.0.0-SNAPSHOT"));
    private InternalKieScanner internalKieScanner;

    public void setDefaultGAV(ReleaseId releaseId) {
        this.defaultGAV.set(releaseId);
    }

    public ReleaseId getDefaultReleaseId() {
        return this.defaultGAV.get();
    }

    public void addKieModule(KieModule kieModule) {
        this.kieModuleRepo.store(kieModule);
        log.info("KieModule was added:" + kieModule);
    }

    public KieModule getKieModule(ReleaseId releaseId) {
        return this.getKieModule(releaseId, null);
    }

    public KieModule getKieModule(ReleaseId releaseId, byte[] pomXml) {
        VersionRange versionRange = new VersionRange(releaseId.getVersion());
        KieModule kieModule = this.kieModuleRepo.load(releaseId, versionRange);
        if (kieModule == null) {
            log.debug("KieModule Lookup. ReleaseId {} was not in cache, checking classpath", (Object)releaseId.toExternalForm());
            kieModule = this.checkClasspathForKieModule(releaseId);
        }
        if (kieModule == null) {
            log.debug("KieModule Lookup. ReleaseId {} was not in cache, checking maven repository", (Object)releaseId.toExternalForm());
            kieModule = this.loadKieModuleFromMavenRepo(releaseId, pomXml);
        }
        return kieModule;
    }

    private KieModule checkClasspathForKieModule(ReleaseId releaseId) {
        return null;
    }

    private KieModule loadKieModuleFromMavenRepo(ReleaseId releaseId, byte[] pomXml) {
        return pomXml != null ? this.getInternalKieScanner().loadArtifact(releaseId, new ByteArrayInputStream(pomXml)) : this.getInternalKieScanner().loadArtifact(releaseId);
    }

    private InternalKieScanner getInternalKieScanner() {
        if (this.internalKieScanner == null) {
            try {
                this.internalKieScanner = (InternalKieScanner)ServiceRegistryImpl.getInstance().get(KieScanner.class);
            }
            catch (Exception e) {
                this.internalKieScanner = new DummyKieScanner();
            }
        }
        return this.internalKieScanner;
    }

    public KieModule addKieModule(Resource resource, Resource ... dependencies) {
        log.info("Adding KieModule from resource :" + resource);
        KieModule kModule = this.getKieModule(resource);
        if (dependencies != null && dependencies.length > 0) {
            for (Resource depRes : dependencies) {
                InternalKieModule depKModule = (InternalKieModule)this.getKieModule(depRes);
                ((InternalKieModule)kModule).addDependency(depKModule);
                log.info("Adding KieModule dependency from resource :" + resource);
            }
        }
        this.addKieModule(kModule);
        return kModule;
    }

    public KieModule getKieModule(Resource resource) {
        InternalResource res = (InternalResource)resource;
        try {
            String urlPath = res.getURL().toExternalForm();
            if (res.isDirectory()) {
                if (!urlPath.endsWith("/")) {
                    urlPath = urlPath + "/";
                }
                urlPath = urlPath + KieModuleModelImpl.KMODULE_JAR_PATH;
            } else {
                urlPath = "jar:" + urlPath + "!/" + KieModuleModelImpl.KMODULE_JAR_PATH;
            }
            InternalKieModule kModule = ClasspathKieProject.fetchKModule(new URL(urlPath));
            log.debug("fetched KieModule from resource :" + resource);
            return kModule;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to fetch module from resource :" + res, e);
        }
    }

    public static class ComparableVersion
    implements Comparable<ComparableVersion> {
        private String value;
        private String canonical;
        private ListItem items;

        public ComparableVersion(String version) {
            this.parseVersion(version);
        }

        public final void parseVersion(String version) {
            this.value = version;
            this.items = new ListItem();
            version = version.toLowerCase(Locale.ENGLISH);
            ListItem list = this.items;
            Stack<ListItem> stack = new Stack<ListItem>();
            stack.push(list);
            boolean isDigit = false;
            int startIndex = 0;
            for (int i = 0; i < version.length(); ++i) {
                char c = version.charAt(i);
                if (c == '.') {
                    if (i == startIndex) {
                        list.add(IntegerItem.ZERO);
                    } else {
                        list.add(ComparableVersion.parseItem(isDigit, version.substring(startIndex, i)));
                    }
                    startIndex = i + 1;
                    continue;
                }
                if (c == '-') {
                    if (i == startIndex) {
                        list.add(IntegerItem.ZERO);
                    } else {
                        list.add(ComparableVersion.parseItem(isDigit, version.substring(startIndex, i)));
                    }
                    startIndex = i + 1;
                    if (!isDigit) continue;
                    list.normalize();
                    if (i + 1 >= version.length() || !Character.isDigit(version.charAt(i + 1))) continue;
                    ListItem listItem = list;
                    list = new ListItem();
                    listItem.add(list);
                    stack.push(list);
                    continue;
                }
                if (Character.isDigit(c)) {
                    if (!isDigit && i > startIndex) {
                        list.add(new StringItem(version.substring(startIndex, i), true));
                        startIndex = i;
                    }
                    isDigit = true;
                    continue;
                }
                if (isDigit && i > startIndex) {
                    list.add(ComparableVersion.parseItem(true, version.substring(startIndex, i)));
                    startIndex = i;
                }
                isDigit = false;
            }
            if (version.length() > startIndex) {
                list.add(ComparableVersion.parseItem(isDigit, version.substring(startIndex)));
            }
            while (!stack.isEmpty()) {
                list = (ListItem)stack.pop();
                list.normalize();
            }
            this.canonical = this.items.toString();
        }

        private static Item parseItem(boolean isDigit, String buf) {
            return isDigit ? new IntegerItem(buf) : new StringItem(buf, false);
        }

        @Override
        public int compareTo(ComparableVersion o) {
            return this.items.compareTo(o.items);
        }

        public String toString() {
            return this.value;
        }

        public boolean equals(Object o) {
            return o instanceof ComparableVersion && this.canonical.equals(((ComparableVersion)o).canonical);
        }

        public int hashCode() {
            return this.canonical.hashCode();
        }

        private static class ListItem
        extends ArrayList<Item>
        implements Item {
            private ListItem() {
            }

            @Override
            public int getType() {
                return 2;
            }

            @Override
            public boolean isNull() {
                return this.size() == 0;
            }

            void normalize() {
                Item item;
                ListIterator iterator = this.listIterator(this.size());
                while (iterator.hasPrevious() && (item = (Item)iterator.previous()).isNull()) {
                    iterator.remove();
                }
            }

            @Override
            public int compareTo(Item item) {
                if (item == null) {
                    if (this.size() == 0) {
                        return 0;
                    }
                    Item first = (Item)this.get(0);
                    return first.compareTo(null);
                }
                switch (item.getType()) {
                    case 0: {
                        return -1;
                    }
                    case 1: {
                        return 1;
                    }
                    case 2: {
                        Iterator left = this.iterator();
                        Iterator right = ((ListItem)item).iterator();
                        while (left.hasNext() || right.hasNext()) {
                            Item l = left.hasNext() ? (Item)left.next() : null;
                            Item r = right.hasNext() ? (Item)right.next() : null;
                            int result = l == null ? -1 * r.compareTo(l) : l.compareTo(r);
                            if (result == 0) continue;
                            return result;
                        }
                        return 0;
                    }
                }
                throw new RuntimeException("invalid item: " + item.getClass());
            }

            @Override
            public String toString() {
                StringBuilder buffer = new StringBuilder("(");
                Iterator iter = this.iterator();
                while (iter.hasNext()) {
                    buffer.append(iter.next());
                    if (!iter.hasNext()) continue;
                    buffer.append(',');
                }
                buffer.append(')');
                return buffer.toString();
            }
        }

        private static class StringItem
        implements Item {
            private static final String[] QUALIFIERS = new String[]{"alpha", "beta", "milestone", "rc", "snapshot", "", "sp"};
            private static final List<String> _QUALIFIERS = Arrays.asList(QUALIFIERS);
            private static final Properties ALIASES = new Properties();
            private static final String RELEASE_VERSION_INDEX;
            private String value;

            public StringItem(String value, boolean followedByDigit) {
                if (followedByDigit && value.length() == 1) {
                    switch (value.charAt(0)) {
                        case 'a': {
                            value = "alpha";
                            break;
                        }
                        case 'b': {
                            value = "beta";
                            break;
                        }
                        case 'm': {
                            value = "milestone";
                        }
                    }
                }
                this.value = ALIASES.getProperty(value, value);
            }

            @Override
            public int getType() {
                return 1;
            }

            @Override
            public boolean isNull() {
                return StringItem.comparableQualifier(this.value).compareTo(RELEASE_VERSION_INDEX) == 0;
            }

            public static String comparableQualifier(String qualifier) {
                int i = _QUALIFIERS.indexOf(qualifier);
                return i == -1 ? _QUALIFIERS.size() + "-" + qualifier : String.valueOf(i);
            }

            @Override
            public int compareTo(Item item) {
                if (item == null) {
                    return StringItem.comparableQualifier(this.value).compareTo(RELEASE_VERSION_INDEX);
                }
                switch (item.getType()) {
                    case 0: {
                        return -1;
                    }
                    case 1: {
                        return StringItem.comparableQualifier(this.value).compareTo(StringItem.comparableQualifier(((StringItem)item).value));
                    }
                    case 2: {
                        return -1;
                    }
                }
                throw new RuntimeException("invalid item: " + item.getClass());
            }

            public String toString() {
                return this.value;
            }

            static {
                ALIASES.put("ga", "");
                ALIASES.put("final", "");
                ALIASES.put("cr", "rc");
                RELEASE_VERSION_INDEX = String.valueOf(_QUALIFIERS.indexOf(""));
            }
        }

        private static class IntegerItem
        implements Item {
            private static final BigInteger BigInteger_ZERO = new BigInteger("0");
            private final BigInteger value;
            public static final IntegerItem ZERO = new IntegerItem();

            private IntegerItem() {
                this.value = BigInteger_ZERO;
            }

            public IntegerItem(String str) {
                this.value = new BigInteger(str);
            }

            @Override
            public int getType() {
                return 0;
            }

            @Override
            public boolean isNull() {
                return BigInteger_ZERO.equals(this.value);
            }

            @Override
            public int compareTo(Item item) {
                if (item == null) {
                    return BigInteger_ZERO.equals(this.value) ? 0 : 1;
                }
                switch (item.getType()) {
                    case 0: {
                        return this.value.compareTo(((IntegerItem)item).value);
                    }
                    case 1: {
                        return 1;
                    }
                    case 2: {
                        return 1;
                    }
                }
                throw new RuntimeException("invalid item: " + item.getClass());
            }

            public String toString() {
                return this.value.toString();
            }
        }

        private static interface Item {
            public static final int INTEGER_ITEM = 0;
            public static final int STRING_ITEM = 1;
            public static final int LIST_ITEM = 2;

            public int compareTo(Item var1);

            public int getType();

            public boolean isNull();
        }
    }

    private static class VersionRange {
        private String lowerBound;
        private String upperBound;
        private boolean lowerInclusive;
        private boolean upperInclusive;
        private boolean fixed;

        private VersionRange(String version) {
            this.parse(version);
        }

        private void parse(String version) {
            if ("LATEST".equals(version) || "RELEASE".equals(version)) {
                this.fixed = false;
                this.lowerBound = "1.0";
                this.upperBound = null;
                this.lowerInclusive = true;
                this.upperInclusive = false;
                return;
            }
            if (version.charAt(0) != '(' && version.charAt(0) != '[') {
                this.fixed = true;
                this.lowerBound = version;
                this.upperBound = version;
                this.lowerInclusive = true;
                this.upperInclusive = true;
                return;
            }
            this.lowerInclusive = version.charAt(0) == '[';
            this.upperInclusive = version.charAt(version.length() - 1) == ']';
            int commaPos = version.indexOf(44);
            if (commaPos < 0) {
                this.fixed = true;
                this.upperBound = this.lowerBound = version.substring(1, version.length() - 1);
            } else {
                if (commaPos > 1) {
                    this.lowerBound = version.substring(1, commaPos);
                }
                if (commaPos < version.length() - 2) {
                    this.upperBound = version.substring(commaPos + 1, version.length() - 1);
                }
            }
        }
    }

    private static class KieModuleRepo {
        private final Map<String, TreeMap<ComparableVersion, KieModule>> kieModules = new HashMap<String, TreeMap<ComparableVersion, KieModule>>();

        private KieModuleRepo() {
        }

        void store(KieModule kieModule) {
            ReleaseId releaseId = kieModule.getReleaseId();
            String ga = releaseId.getGroupId() + ":" + releaseId.getArtifactId();
            TreeMap<ComparableVersion, Object> artifactMap = this.kieModules.get(ga);
            if (artifactMap == null) {
                artifactMap = new TreeMap();
                this.kieModules.put(ga, artifactMap);
            }
            artifactMap.put(new ComparableVersion(releaseId.getVersion()), kieModule);
        }

        KieModule load(ReleaseId releaseId, VersionRange versionRange) {
            Map.Entry<ComparableVersion, KieModule> entry;
            String ga = releaseId.getGroupId() + ":" + releaseId.getArtifactId();
            TreeMap<ComparableVersion, KieModule> artifactMap = this.kieModules.get(ga);
            if (artifactMap == null) {
                return null;
            }
            if (versionRange.fixed) {
                return artifactMap.get(new ComparableVersion(releaseId.getVersion()));
            }
            if (versionRange.upperBound == null) {
                return artifactMap.lastEntry().getValue();
            }
            Map.Entry<ComparableVersion, KieModule> entry2 = entry = versionRange.upperInclusive ? artifactMap.ceilingEntry(new ComparableVersion(versionRange.upperBound)) : artifactMap.lowerEntry(new ComparableVersion(versionRange.upperBound));
            if (entry == null) {
                return null;
            }
            if (versionRange.lowerBound == null) {
                return entry.getValue();
            }
            int versionComparison = entry.getKey().compareTo(new ComparableVersion(versionRange.lowerBound));
            return versionComparison > 0 || versionComparison == 0 && versionRange.lowerInclusive ? entry.getValue() : null;
        }
    }

    private static class DummyKieScanner
    implements InternalKieScanner {
        private DummyKieScanner() {
        }

        @Override
        public KieModule loadArtifact(ReleaseId releaseId) {
            return null;
        }

        public void start(long pollingInterval) {
        }

        public void stop() {
        }

        public void scanNow() {
        }

        @Override
        public void setKieContainer(KieContainer kieContainer) {
        }

        @Override
        public KieModule loadArtifact(ReleaseId releaseId, InputStream pomXML) {
            return null;
        }
    }
}

