/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.kproject.models;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.drools.compiler.kproject.models.KieBaseModelImpl;
import org.drools.compiler.kproject.models.KieSessionModelImpl;
import org.drools.compiler.kproject.models.ListenerModelImpl;
import org.drools.compiler.kproject.models.QualifierModelImpl;
import org.drools.compiler.kproject.models.WorkItemHandlerModelImpl;
import org.drools.core.util.AbstractXStreamConverter;
import org.drools.core.util.IoUtils;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieModuleModel;
import org.xml.sax.SAXException;

public class KieModuleModelImpl
implements KieModuleModel {
    public static String KMODULE_JAR_PATH = "META-INF/kmodule.xml";
    public static String KMODULE_INFO_JAR_PATH = "META-INF/kmodule.info";
    public static String KMODULE_SRC_PATH = "src/main/resources/" + KMODULE_JAR_PATH;
    private Map<String, KieBaseModel> kBases = new HashMap<String, KieBaseModel>();
    private static final String KMODULE_XSD = "<kmodule xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \n         xmlns=\"http://jboss.org/kie/6.0.0/kmodule\"";
    private static final kModuleMarshaller MARSHALLER = new kModuleMarshaller();

    public KieBaseModel newKieBaseModel(String name) {
        KieBaseModelImpl kbase = new KieBaseModelImpl(this, name);
        HashMap<String, KieBaseModel> newMap = new HashMap<String, KieBaseModel>();
        newMap.putAll(this.kBases);
        newMap.put(kbase.getName(), kbase);
        this.setKBases(newMap);
        return kbase;
    }

    public void removeKieBaseModel(String qName) {
        HashMap<String, KieBaseModel> newMap = new HashMap<String, KieBaseModel>();
        newMap.putAll(this.kBases);
        newMap.remove(qName);
        this.setKBases(newMap);
    }

    public void moveKBase(String oldQName, String newQName) {
        HashMap<String, KieBaseModel> newMap = new HashMap<String, KieBaseModel>();
        newMap.putAll(this.kBases);
        KieBaseModel kieBaseModel = (KieBaseModel)newMap.remove(oldQName);
        newMap.put(newQName, kieBaseModel);
        this.setKBases(newMap);
    }

    public Map<String, KieBaseModel> getKieBaseModels() {
        return Collections.unmodifiableMap(this.kBases);
    }

    public Map<String, KieBaseModel> getRawKieBaseModels() {
        return this.kBases;
    }

    private void setKBases(Map<String, KieBaseModel> kBases) {
        this.kBases = kBases;
    }

    void changeKBaseName(KieBaseModel kieBase, String oldName, String newName) {
        this.kBases.remove(oldName);
        this.kBases.put(newName, kieBase);
    }

    public String toString() {
        return "KieModuleModel [kbases=" + this.kBases + "]";
    }

    public String toXML() {
        String xml = MARSHALLER.toXML(this);
        return KMODULE_XSD + xml.substring("<kmodule".length());
    }

    public static KieModuleModel fromXML(InputStream kModuleStream) {
        return MARSHALLER.fromXML(kModuleStream);
    }

    public static KieModuleModel fromXML(File kModuleFile) {
        return MARSHALLER.fromXML(kModuleFile);
    }

    public static KieModuleModel fromXML(URL kModuleUrl) {
        return MARSHALLER.fromXML(kModuleUrl);
    }

    public static KieModuleModel fromXML(String kModuleString) {
        return MARSHALLER.fromXML(kModuleString);
    }

    private static class KieModuleValidator {
        private static final Schema schema = KieModuleValidator.loadSchema();

        private KieModuleValidator() {
        }

        private static Schema loadSchema() {
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            try {
                URL url = KieModuleModel.class.getClassLoader().getResource("org/kie/api/kmodule.xsd");
                return factory.newSchema(url);
            }
            catch (SAXException ex) {
                throw new RuntimeException("Unable to load XSD", ex);
            }
        }

        private static void validate(InputStream kModuleStream) {
            KieModuleValidator.validate(new StreamSource(kModuleStream));
        }

        private static void validate(File kModuleFile) {
            KieModuleValidator.validate(new StreamSource(kModuleFile));
        }

        private static void validate(URL kModuleUrl) {
            try {
                KieModuleValidator.validate(new StreamSource(kModuleUrl.toURI().toString()));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }

        private static void validate(String kModuleString) {
            KieModuleValidator.validate(new StreamSource(new ByteArrayInputStream(kModuleString.getBytes())));
        }

        private static void validate(Source source) {
            try {
                schema.newValidator().validate(source);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public static class kModuleConverter
    extends AbstractXStreamConverter {
        public kModuleConverter() {
            super(KieModuleModelImpl.class);
        }

        public void marshal(Object value, HierarchicalStreamWriter writer, MarshallingContext context) {
            KieModuleModelImpl kModule = (KieModuleModelImpl)value;
            for (KieBaseModel kBaseModule : kModule.getKieBaseModels().values()) {
                this.writeObject(writer, context, "kbase", kBaseModule);
            }
        }

        public Object unmarshal(HierarchicalStreamReader reader, final UnmarshallingContext context) {
            final KieModuleModelImpl kModule = new KieModuleModelImpl();
            this.readNodes(reader, new AbstractXStreamConverter.NodeReader(){

                public void onNode(HierarchicalStreamReader reader, String name, String value) {
                    if ("kbase".equals(name)) {
                        KieBaseModelImpl kBaseModule = (KieBaseModelImpl)kModuleConverter.this.readObject(reader, context, KieBaseModelImpl.class);
                        kModule.getRawKieBaseModels().put(kBaseModule.getName(), kBaseModule);
                        kBaseModule.setKModule(kModule);
                    }
                }
            });
            return kModule;
        }
    }

    private static class kModuleMarshaller {
        private final XStream xStream = new XStream((HierarchicalStreamDriver)new DomDriver());

        private kModuleMarshaller() {
            this.xStream.registerConverter((Converter)new kModuleConverter());
            this.xStream.registerConverter((Converter)new KieBaseModelImpl.KBaseConverter());
            this.xStream.registerConverter((Converter)new KieSessionModelImpl.KSessionConverter());
            this.xStream.registerConverter((Converter)new ListenerModelImpl.ListenerConverter());
            this.xStream.registerConverter((Converter)new QualifierModelImpl.QualifierConverter());
            this.xStream.registerConverter((Converter)new WorkItemHandlerModelImpl.WorkItemHandelerConverter());
            this.xStream.alias("kmodule", KieModuleModelImpl.class);
            this.xStream.alias("kbase", KieBaseModelImpl.class);
            this.xStream.alias("ksession", KieSessionModelImpl.class);
            this.xStream.alias("listener", ListenerModelImpl.class);
            this.xStream.alias("qualifier", QualifierModelImpl.class);
            this.xStream.alias("workItemHandler", WorkItemHandlerModelImpl.class);
            this.xStream.setClassLoader(KieModuleModelImpl.class.getClassLoader());
        }

        public String toXML(KieModuleModel kieProject) {
            return this.xStream.toXML((Object)kieProject);
        }

        public KieModuleModel fromXML(InputStream kModuleStream) {
            byte[] bytes = null;
            try {
                bytes = IoUtils.readBytesFromInputStream((InputStream)kModuleStream);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            KieModuleValidator.validate(new ByteArrayInputStream(bytes));
            return (KieModuleModel)this.xStream.fromXML((InputStream)new ByteArrayInputStream(bytes));
        }

        public KieModuleModel fromXML(File kModuleFile) {
            KieModuleValidator.validate(kModuleFile);
            return (KieModuleModel)this.xStream.fromXML(kModuleFile);
        }

        public KieModuleModel fromXML(URL kModuleUrl) {
            KieModuleValidator.validate(kModuleUrl);
            return (KieModuleModel)this.xStream.fromXML(kModuleUrl);
        }

        public KieModuleModel fromXML(String kModuleString) {
            KieModuleValidator.validate(kModuleString);
            return (KieModuleModel)this.xStream.fromXML(kModuleString);
        }
    }
}

