/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.builder.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.builder.impl.TypeDeclarationBuilder;
import org.drools.compiler.builder.impl.TypeDefinition;
import org.drools.compiler.compiler.BPMN2ProcessFactory;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.compiler.lang.descr.AbstractClassTypeDeclarationDescr;
import org.drools.compiler.lang.descr.CompositePackageDescr;
import org.drools.compiler.lang.descr.ImportDescr;
import org.drools.compiler.lang.descr.PackageDescr;
import org.drools.compiler.lang.descr.TypeDeclarationDescr;
import org.drools.core.builder.conf.impl.JaxbConfigurationImpl;
import org.drools.core.util.StringUtils;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceConfiguration;
import org.kie.api.io.ResourceType;
import org.kie.internal.builder.ChangeType;
import org.kie.internal.builder.CompositeKnowledgeBuilder;
import org.kie.internal.builder.ResourceChange;
import org.kie.internal.builder.ResourceChangeSet;

public class CompositeKnowledgeBuilderImpl
implements CompositeKnowledgeBuilder {
    private final KnowledgeBuilderImpl kBuilder;
    private final Map<ResourceType, List<ResourceDescr>> resourcesByType = new HashMap<ResourceType, List<ResourceDescr>>();
    private RuntimeException buildException = null;
    public ResourceType currentType = null;
    private static final ResourceToPkgDescrMapper DRL_TO_PKG_DESCR = new ResourceToPkgDescrMapper(){

        @Override
        public PackageDescr map(KnowledgeBuilderImpl kBuilder, ResourceDescr resourceDescr) throws Exception {
            return kBuilder.drlToPackageDescr(resourceDescr.resource);
        }
    };
    private static final ResourceToPkgDescrMapper DSLR_TO_PKG_DESCR = new ResourceToPkgDescrMapper(){

        @Override
        public PackageDescr map(KnowledgeBuilderImpl kBuilder, ResourceDescr resourceDescr) throws Exception {
            return kBuilder.dslrToPackageDescr(resourceDescr.resource);
        }
    };
    private static final ResourceToPkgDescrMapper XML_TO_PKG_DESCR = new ResourceToPkgDescrMapper(){

        @Override
        public PackageDescr map(KnowledgeBuilderImpl kBuilder, ResourceDescr resourceDescr) throws Exception {
            return kBuilder.xmlToPackageDescr(resourceDescr.resource);
        }
    };
    private static final ResourceToPkgDescrMapper DTABLE_TO_PKG_DESCR = new ResourceToPkgDescrMapper(){

        @Override
        public PackageDescr map(KnowledgeBuilderImpl kBuilder, ResourceDescr resourceDescr) throws Exception {
            return kBuilder.decisionTableToPackageDescr(resourceDescr.resource, resourceDescr.configuration);
        }
    };
    private static final ResourceToPkgDescrMapper SCARD_TO_PKG_DESCR = new ResourceToPkgDescrMapper(){

        @Override
        public PackageDescr map(KnowledgeBuilderImpl kBuilder, ResourceDescr resourceDescr) throws Exception {
            return kBuilder.scoreCardToPackageDescr(resourceDescr.resource, resourceDescr.configuration);
        }
    };

    public CompositeKnowledgeBuilderImpl(KnowledgeBuilderImpl kBuilder) {
        this.kBuilder = kBuilder;
    }

    public CompositeKnowledgeBuilder type(ResourceType type) {
        this.currentType = type;
        return this;
    }

    public CompositeKnowledgeBuilder add(Resource resource) {
        if (this.currentType == null) {
            throw new RuntimeException("You must declare the type of the resource");
        }
        return this.add(resource, this.currentType);
    }

    public CompositeKnowledgeBuilder add(Resource resource, ResourceType type) {
        return this.add(resource, type, resource.getConfiguration());
    }

    public CompositeKnowledgeBuilder add(Resource resource, ResourceType type, ResourceChangeSet changes) {
        return this.add(resource, type, resource.getConfiguration(), changes);
    }

    public CompositeKnowledgeBuilder add(Resource resource, ResourceType type, ResourceConfiguration configuration) {
        return this.add(resource, type, configuration, null);
    }

    public CompositeKnowledgeBuilder add(Resource resource, ResourceType type, ResourceConfiguration configuration, ResourceChangeSet changes) {
        ResourceDescr resourceDescr = new ResourceDescr(configuration, resource, changes);
        List<ResourceDescr> resourceDescrs = this.resourcesByType.get(type);
        if (resourceDescrs == null) {
            resourceDescrs = new ArrayList<ResourceDescr>();
            this.resourcesByType.put(type, resourceDescrs);
        }
        resourceDescrs.add(resourceDescr);
        return this;
    }

    private List<Resource> getResources() {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (List<ResourceDescr> resourceDescrs : this.resourcesByType.values()) {
            for (ResourceDescr resourceDescr : resourceDescrs) {
                resources.add(resourceDescr.resource);
            }
        }
        return resources;
    }

    public void build() {
        this.buildException = null;
        this.kBuilder.registerBuildResources(this.getResources());
        this.registerDSL();
        this.buildResources();
        this.buildPackages();
        this.buildOthers();
        this.resourcesByType.clear();
        if (this.buildException != null) {
            throw this.buildException;
        }
    }

    private void buildPackages() {
        Collection<CompositePackageDescr> packages = this.buildPackageDescr();
        this.buildTypeDeclarations(packages);
        this.buildOtherDeclarations(packages);
        this.buildRules(packages);
    }

    private void registerDSL() {
        List<ResourceDescr> resourcesByType = this.resourcesByType.remove(ResourceType.DSL);
        if (resourcesByType != null) {
            for (ResourceDescr resourceDescr : resourcesByType) {
                try {
                    this.kBuilder.setAssetFilter(resourceDescr.getFilter());
                    this.kBuilder.addDsl(resourceDescr.resource);
                    this.kBuilder.setAssetFilter(null);
                }
                catch (RuntimeException e) {
                    if (this.buildException != null) continue;
                    this.buildException = e;
                }
                catch (Exception e) {
                    if (this.buildException != null) continue;
                    this.buildException = new RuntimeException(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildResources() {
        List<ResourceDescr> resourcesByType = this.resourcesByType.remove(ResourceType.DRF);
        if (resourcesByType != null) {
            for (ResourceDescr resourceDescr : resourcesByType) {
                try {
                    this.kBuilder.setAssetFilter(resourceDescr.getFilter());
                    this.kBuilder.addProcessFromXml(resourceDescr.resource);
                }
                catch (RuntimeException e) {
                    if (this.buildException != null) continue;
                    this.buildException = e;
                }
                catch (Exception e) {
                    if (this.buildException != null) continue;
                    this.buildException = new RuntimeException(e);
                }
                finally {
                    this.kBuilder.setAssetFilter(null);
                }
            }
        }
        if ((resourcesByType = this.resourcesByType.remove(ResourceType.BPMN2)) != null) {
            for (ResourceDescr resourceDescr : resourcesByType) {
                try {
                    BPMN2ProcessFactory.configurePackageBuilder(this.kBuilder);
                    this.kBuilder.setAssetFilter(resourceDescr.getFilter());
                    this.kBuilder.addProcessFromXml(resourceDescr.resource);
                }
                catch (RuntimeException e) {
                    if (this.buildException != null) continue;
                    this.buildException = e;
                }
                catch (Exception e) {
                    if (this.buildException != null) continue;
                    this.buildException = new RuntimeException(e);
                }
                finally {
                    this.kBuilder.setAssetFilter(null);
                }
            }
        }
        if ((resourcesByType = this.resourcesByType.remove(ResourceType.PKG)) != null) {
            for (ResourceDescr resourceDescr : resourcesByType) {
                try {
                    this.kBuilder.setAssetFilter(resourceDescr.getFilter());
                    this.kBuilder.addPackageFromInputStream(resourceDescr.resource);
                }
                catch (RuntimeException e) {
                    if (this.buildException != null) continue;
                    this.buildException = e;
                }
                catch (Exception e) {
                    if (this.buildException != null) continue;
                    this.buildException = new RuntimeException(e);
                }
                finally {
                    this.kBuilder.setAssetFilter(null);
                }
            }
        }
        if ((resourcesByType = this.resourcesByType.remove(ResourceType.CHANGE_SET)) != null) {
            for (ResourceDescr resourceDescr : resourcesByType) {
                try {
                    this.kBuilder.setAssetFilter(resourceDescr.getFilter());
                    this.kBuilder.addPackageFromChangeSet(resourceDescr.resource);
                }
                catch (RuntimeException e) {
                    if (this.buildException != null) continue;
                    this.buildException = e;
                }
                catch (Exception e) {
                    if (this.buildException != null) continue;
                    this.buildException = new RuntimeException(e);
                }
                finally {
                    this.kBuilder.setAssetFilter(null);
                }
            }
        }
        if ((resourcesByType = this.resourcesByType.remove(ResourceType.XSD)) != null) {
            for (ResourceDescr resourceDescr : resourcesByType) {
                try {
                    this.kBuilder.setAssetFilter(resourceDescr.getFilter());
                    this.kBuilder.addPackageFromXSD(resourceDescr.resource, (JaxbConfigurationImpl)resourceDescr.configuration);
                }
                catch (RuntimeException e) {
                    if (this.buildException != null) continue;
                    this.buildException = e;
                }
                catch (Exception e) {
                    if (this.buildException != null) continue;
                    this.buildException = new RuntimeException(e);
                }
                finally {
                    this.kBuilder.setAssetFilter(null);
                }
            }
        }
        if ((resourcesByType = this.resourcesByType.remove(ResourceType.PMML)) != null) {
            for (ResourceDescr resourceDescr : resourcesByType) {
                try {
                    this.kBuilder.setAssetFilter(resourceDescr.getFilter());
                    this.kBuilder.addPackageFromPMML(resourceDescr.resource, ResourceType.PMML, resourceDescr.configuration);
                }
                catch (RuntimeException e) {
                    if (this.buildException != null) continue;
                    this.buildException = e;
                }
                catch (Exception e) {
                    if (this.buildException != null) continue;
                    this.buildException = new RuntimeException(e);
                }
                finally {
                    this.kBuilder.setAssetFilter(null);
                }
            }
        }
    }

    private void buildOthers() {
        try {
            for (Map.Entry<ResourceType, List<ResourceDescr>> entry : this.resourcesByType.entrySet()) {
                for (ResourceDescr resourceDescr : entry.getValue()) {
                    this.kBuilder.setAssetFilter(resourceDescr.getFilter());
                    this.kBuilder.addPackageForExternalType(resourceDescr.resource, entry.getKey(), resourceDescr.configuration);
                    this.kBuilder.setAssetFilter(null);
                }
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void buildOtherDeclarations(Collection<CompositePackageDescr> packages) {
        for (CompositePackageDescr packageDescr : packages) {
            this.kBuilder.setAssetFilter(packageDescr.getFilter());
            PackageRegistry pkgRegistry = this.kBuilder.getPackageRegistry(packageDescr.getNamespace());
            this.kBuilder.processOtherDeclarations(pkgRegistry, packageDescr);
            this.kBuilder.setAssetFilter(null);
        }
    }

    private void buildRules(Collection<CompositePackageDescr> packages) {
        for (CompositePackageDescr packageDescr : packages) {
            this.kBuilder.setAssetFilter(packageDescr.getFilter());
            PackageRegistry pkgRegistry = this.kBuilder.getPackageRegistry(packageDescr.getNamespace());
            this.kBuilder.compileAllRules(packageDescr, pkgRegistry);
            this.kBuilder.setAssetFilter(null);
        }
    }

    private void buildTypeDeclarations(Collection<CompositePackageDescr> packages) {
        ArrayList<TypeDeclarationDescr> allDescrs = new ArrayList<TypeDeclarationDescr>();
        for (CompositePackageDescr packageDescr : packages) {
            for (TypeDeclarationDescr typeDeclarationDescr : packageDescr.getTypeDeclarations()) {
                if (StringUtils.isEmpty((CharSequence)typeDeclarationDescr.getNamespace())) {
                    typeDeclarationDescr.setNamespace(packageDescr.getNamespace());
                }
                this.kBuilder.getTypeBuilder().registerGeneratedType(typeDeclarationDescr);
                allDescrs.add(typeDeclarationDescr);
            }
        }
        HashMap<String, TypeDeclarationDescr> unprocesseableDescrs = new HashMap<String, TypeDeclarationDescr>();
        ArrayList<TypeDefinition> unresolvedTypes = new ArrayList<TypeDefinition>();
        for (CompositePackageDescr packageDescr : packages) {
            this.buildTypeDeclarations(packageDescr, unresolvedTypes, unprocesseableDescrs);
        }
        if (!unprocesseableDescrs.isEmpty()) {
            Collection<AbstractClassTypeDeclarationDescr> sortedDescrs = TypeDeclarationBuilder.sortByHierarchy(this.kBuilder, unprocesseableDescrs.values());
            for (AbstractClassTypeDeclarationDescr descr : sortedDescrs) {
                unprocesseableDescrs.remove(descr.getType().getFullName());
                PackageRegistry pkg = this.kBuilder.getPackageRegistry().get(descr.getType().getNamespace());
                this.kBuilder.getTypeBuilder().processTypeDeclaration(pkg, descr, sortedDescrs, unresolvedTypes, unprocesseableDescrs);
            }
        }
        for (TypeDefinition unresolvedType : unresolvedTypes) {
            this.kBuilder.getTypeBuilder().processUnresolvedType(this.kBuilder.getPackageRegistry(unresolvedType.getNamespace()), unresolvedType);
        }
        if (!this.kBuilder.hasErrors()) {
            int j = 0;
            for (AbstractClassTypeDeclarationDescr descr : TypeDeclarationBuilder.sortByHierarchy(this.kBuilder, allDescrs)) {
                this.kBuilder.getPackageRegistry(descr.getNamespace()).getPackage().getTypeDeclaration(descr.getTypeName()).setOrder(j++);
            }
        }
        for (CompositePackageDescr packageDescr : packages) {
            for (ImportDescr importDescr : packageDescr.getImports()) {
                this.kBuilder.getPackageRegistry(packageDescr.getNamespace()).addImport(importDescr);
            }
        }
    }

    private List<TypeDefinition> buildTypeDeclarations(CompositePackageDescr packageDescr, List<TypeDefinition> unresolvedTypes, Map<String, TypeDeclarationDescr> unprocessableDescrs) {
        this.kBuilder.setAssetFilter(packageDescr.getFilter());
        PackageRegistry pkgRegistry = this.kBuilder.createPackageRegistry(packageDescr);
        if (pkgRegistry == null) {
            return null;
        }
        this.kBuilder.processEntryPointDeclarations(pkgRegistry, packageDescr);
        List<TypeDefinition> defsWithUnresolvedTypes = this.kBuilder.getTypeBuilder().processTypeDeclarations(pkgRegistry, packageDescr, unresolvedTypes, unprocessableDescrs);
        this.kBuilder.setAssetFilter(null);
        return defsWithUnresolvedTypes;
    }

    private Collection<CompositePackageDescr> buildPackageDescr() {
        HashMap<String, CompositePackageDescr> packages = new HashMap<String, CompositePackageDescr>();
        this.buildResource(packages, ResourceType.DRL, DRL_TO_PKG_DESCR);
        this.buildResource(packages, ResourceType.GDRL, DRL_TO_PKG_DESCR);
        this.buildResource(packages, ResourceType.RDRL, DRL_TO_PKG_DESCR);
        this.buildResource(packages, ResourceType.DESCR, DRL_TO_PKG_DESCR);
        this.buildResource(packages, ResourceType.DSLR, DSLR_TO_PKG_DESCR);
        this.buildResource(packages, ResourceType.RDSLR, DSLR_TO_PKG_DESCR);
        this.buildResource(packages, ResourceType.XDRL, XML_TO_PKG_DESCR);
        this.buildResource(packages, ResourceType.DTABLE, DTABLE_TO_PKG_DESCR);
        this.buildResource(packages, ResourceType.SCARD, SCARD_TO_PKG_DESCR);
        return packages.values();
    }

    private void buildResource(Map<String, CompositePackageDescr> packages, ResourceType resourceType, ResourceToPkgDescrMapper mapper) {
        List<ResourceDescr> resourcesByType = this.resourcesByType.remove(resourceType);
        if (resourcesByType != null) {
            for (ResourceDescr resourceDescr : resourcesByType) {
                try {
                    this.registerPackageDescr(resourceDescr, packages, resourceDescr.resource, mapper.map(this.kBuilder, resourceDescr));
                }
                catch (RuntimeException e) {
                    if (this.buildException != null) continue;
                    this.buildException = e;
                }
                catch (Exception e) {
                    if (this.buildException != null) continue;
                    this.buildException = new RuntimeException(e);
                }
            }
        }
    }

    private void registerPackageDescr(ResourceDescr resourceDescr, Map<String, CompositePackageDescr> packages, Resource resource, PackageDescr packageDescr) {
        if (packageDescr != null) {
            CompositePackageDescr compositePackageDescr = packages.get(packageDescr.getNamespace());
            if (compositePackageDescr == null) {
                compositePackageDescr = new CompositePackageDescr(resource, packageDescr);
                packages.put(packageDescr.getNamespace(), compositePackageDescr);
            } else {
                compositePackageDescr.addPackageDescr(resource, packageDescr);
            }
            compositePackageDescr.addFilter(resourceDescr.getFilter());
        }
    }

    private static interface ResourceToPkgDescrMapper {
        public PackageDescr map(KnowledgeBuilderImpl var1, ResourceDescr var2) throws Exception;
    }

    private static class ResourceDescr {
        final Resource resource;
        final ResourceConfiguration configuration;
        final ResourceChangeSet changes;
        final Map<String, ResourceChange> changeMap;

        private ResourceDescr(ResourceConfiguration configuration, Resource resource, ResourceChangeSet changes) {
            this.configuration = configuration;
            this.resource = resource;
            this.changes = changes;
            if (changes != null) {
                this.changeMap = new HashMap<String, ResourceChange>();
                for (ResourceChange c : changes.getChanges()) {
                    this.changeMap.put(c.getName(), c);
                }
            } else {
                this.changeMap = null;
            }
        }

        public KnowledgeBuilderImpl.AssetFilter getFilter() {
            return this.changeMap == null ? null : new ChangeSetAssetFilter();
        }

        private class ChangeSetAssetFilter
        implements KnowledgeBuilderImpl.AssetFilter {
            private ChangeSetAssetFilter() {
            }

            @Override
            public KnowledgeBuilderImpl.AssetFilter.Action accept(String pkgName, String assetName) {
                ResourceChange change = ResourceDescr.this.changeMap.get(assetName);
                if (change == null) {
                    return KnowledgeBuilderImpl.AssetFilter.Action.DO_NOTHING;
                }
                if (change.getChangeType().equals((Object)ChangeType.ADDED)) {
                    return KnowledgeBuilderImpl.AssetFilter.Action.ADD;
                }
                if (change.getChangeType().equals((Object)ChangeType.REMOVED)) {
                    return KnowledgeBuilderImpl.AssetFilter.Action.REMOVE;
                }
                if (change.getChangeType().equals((Object)ChangeType.UPDATED)) {
                    return KnowledgeBuilderImpl.AssetFilter.Action.UPDATE;
                }
                return KnowledgeBuilderImpl.AssetFilter.Action.DO_NOTHING;
            }
        }
    }
}

