/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.builder.impl;

import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.compiler.compiler.TypeDeclarationError;
import org.drools.compiler.lang.descr.AbstractClassTypeDeclarationDescr;
import org.drools.core.common.ProjectClassLoader;
import org.drools.core.factmodel.ClassBuilder;
import org.drools.core.factmodel.ClassDefinition;
import org.drools.core.rule.JavaDialectRuntimeData;
import org.drools.core.rule.TypeDeclaration;
import org.drools.core.util.ClassUtils;

public class DeclaredClassBuilder {
    protected final KnowledgeBuilderImpl kbuilder;

    public DeclaredClassBuilder(KnowledgeBuilderImpl kbuilder) {
        this.kbuilder = kbuilder;
    }

    public void generateBeanFromDefinition(AbstractClassTypeDeclarationDescr typeDescr, TypeDeclaration type, PackageRegistry pkgRegistry, ClassDefinition def) {
        if (type.isNovel()) {
            String fullName = typeDescr.getType().getFullName();
            JavaDialectRuntimeData dialect = (JavaDialectRuntimeData)pkgRegistry.getDialectRuntimeRegistry().getDialectData("java");
            switch (type.getKind()) {
                case TRAIT: {
                    try {
                        this.buildClass(def, fullName, dialect, this.kbuilder.getBuilderConfiguration().getClassBuilderFactory().getTraitBuilder());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.kbuilder.addBuilderResult(new TypeDeclarationError(typeDescr, "Unable to compile declared trait " + fullName + ": " + e.getMessage() + ";"));
                    }
                    break;
                }
                case ENUM: {
                    try {
                        this.buildClass(def, fullName, dialect, (ClassBuilder)this.kbuilder.getBuilderConfiguration().getClassBuilderFactory().getEnumClassBuilder());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.kbuilder.addBuilderResult(new TypeDeclarationError(typeDescr, "Unable to compile declared enum " + fullName + ": " + e.getMessage() + ";"));
                    }
                    break;
                }
                default: {
                    try {
                        this.buildClass(def, fullName, dialect, this.kbuilder.getBuilderConfiguration().getClassBuilderFactory().getBeanClassBuilder());
                        break;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.kbuilder.addBuilderResult(new TypeDeclarationError(typeDescr, "Unable to create a class for declared type " + fullName + ": " + e.getMessage() + ";"));
                    }
                }
            }
        }
    }

    protected void buildClass(ClassDefinition def, String fullName, JavaDialectRuntimeData dialect, ClassBuilder cb) throws Exception {
        byte[] bytecode = cb.buildClass(def, this.kbuilder.getRootClassLoader());
        String resourceName = ClassUtils.convertClassToResourcePath((String)fullName);
        dialect.putClassDefinition(resourceName, bytecode);
        if (this.kbuilder.getKnowledgeBase() != null) {
            this.kbuilder.getKnowledgeBase().registerAndLoadTypeDefinition(fullName, bytecode);
        } else if (this.kbuilder.getRootClassLoader() instanceof ProjectClassLoader) {
            ((ProjectClassLoader)this.kbuilder.getRootClassLoader()).defineClass(fullName, resourceName, bytecode);
        } else {
            dialect.write(resourceName, bytecode);
        }
    }
}

