/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.rule.builder;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class XpathAnalysis
implements Iterable<XpathPart> {
    private final List<XpathPart> parts;

    public XpathAnalysis(List<XpathPart> parts) {
        this.parts = parts;
    }

    @Override
    public Iterator<XpathPart> iterator() {
        return this.parts.iterator();
    }

    public static XpathAnalysis analyze(String xpath) {
        if (xpath.charAt(0) != '/') {
            return null;
        }
        boolean iterate = true;
        ArrayList<XpathPart> parts = new ArrayList<XpathPart>();
        ArrayList<String> constraints = new ArrayList<String>();
        String inlineCast = null;
        int lastStart = 1;
        int nestedParam = 0;
        int nestedSquare = 0;
        boolean isQuoted = false;
        String field = null;
        block9: for (int i = 1; i < xpath.length(); ++i) {
            switch (xpath.charAt(i)) {
                case '.': 
                case '/': {
                    if (isQuoted || nestedParam != 0 || nestedSquare != 0) continue block9;
                    if (field == null) {
                        field = xpath.substring(lastStart, i).trim();
                    }
                    parts.add(new XpathPart(field, iterate, constraints, inlineCast));
                    iterate = xpath.charAt(i) == '/';
                    constraints = new ArrayList();
                    inlineCast = null;
                    lastStart = i + 1;
                    field = null;
                    continue block9;
                }
                case '(': 
                case '{': {
                    if (isQuoted) continue block9;
                    ++nestedParam;
                    continue block9;
                }
                case ')': 
                case '}': {
                    if (isQuoted) continue block9;
                    --nestedParam;
                    continue block9;
                }
                case '[': {
                    if (isQuoted || nestedParam != 0) continue block9;
                    if (nestedSquare == 0) {
                        field = xpath.substring(lastStart, i).trim();
                        lastStart = i + 1;
                    }
                    ++nestedSquare;
                    continue block9;
                }
                case ']': {
                    if (isQuoted || nestedParam != 0 || --nestedSquare != 0) continue block9;
                    String constraint = xpath.substring(lastStart, i).trim();
                    if (constraint.startsWith("#")) {
                        inlineCast = constraint.substring(1);
                        continue block9;
                    }
                    constraints.add(constraint);
                    continue block9;
                }
                case ',': {
                    if (isQuoted || nestedParam != 0 || nestedSquare != 1) continue block9;
                    String constraint = xpath.substring(lastStart, i).trim();
                    if (constraint.startsWith("#")) {
                        inlineCast = constraint.substring(1);
                    } else {
                        constraints.add(constraint);
                    }
                    lastStart = i + 1;
                    continue block9;
                }
                case '\"': 
                case '\'': {
                    isQuoted = !isQuoted;
                }
            }
        }
        if (field == null) {
            field = xpath.substring(lastStart).trim();
        }
        parts.add(new XpathPart(field, iterate, constraints, inlineCast));
        return new XpathAnalysis(parts);
    }

    public static class XpathPart {
        private final String field;
        private final boolean iterate;
        private final List<String> constraints;
        private final String inlineCast;

        public XpathPart(String field, boolean iterate, List<String> constraints, String inlineCast) {
            this.field = field;
            this.iterate = iterate;
            this.constraints = constraints;
            this.inlineCast = inlineCast;
        }

        public String getField() {
            return this.field;
        }

        public boolean isIterate() {
            return this.iterate;
        }

        public List<String> getConstraints() {
            return this.constraints;
        }

        public String getInlineCast() {
            return this.inlineCast;
        }

        public void addInlineCastConstraint(Class<?> clazz) {
            this.constraints.add(0, "this instanceof " + clazz.getCanonicalName());
        }
    }
}

