/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.builder.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.drools.compiler.builder.impl.ClassDefinitionFactory;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.builder.impl.TypeDeclarationConfigurator;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.compiler.compiler.TypeDeclarationError;
import org.drools.compiler.lang.descr.PackageDescr;
import org.drools.core.factmodel.ClassDefinition;
import org.drools.core.factmodel.FieldDefinition;
import org.drools.core.factmodel.traits.Thing;
import org.drools.core.factmodel.traits.Trait;
import org.drools.core.rule.Annotated;
import org.drools.core.rule.TypeDeclaration;
import org.drools.core.util.BitMaskUtil;
import org.drools.core.util.ClassUtils;
import org.kie.api.definition.type.Modifies;
import org.kie.api.definition.type.Position;
import org.kie.api.io.Resource;
import org.kie.api.runtime.rule.Match;
import org.kie.internal.builder.conf.PropertySpecificOption;

public class TypeDeclarationCache {
    private KnowledgeBuilderImpl kbuilder;
    private Map<String, TypeDeclaration> cacheTypes = new HashMap<String, TypeDeclaration>();

    TypeDeclarationCache(KnowledgeBuilderImpl kbuilder) {
        this.kbuilder = kbuilder;
        this.initBuiltinTypeDeclarations();
    }

    private void initBuiltinTypeDeclarations() {
        this.initBuiltinTypeDeclaration(Collection.class);
        this.initBuiltinTypeDeclaration(Map.class);
        this.initBuiltinTypeDeclaration(Match.class);
        this.initBuiltinTypeDeclaration(Thing.class).setKind(TypeDeclaration.Kind.TRAIT);
    }

    private TypeDeclaration initBuiltinTypeDeclaration(Class<?> cls) {
        TypeDeclaration type = new TypeDeclaration(cls.getSimpleName());
        type.setTypesafe(false);
        type.setTypeClass(cls);
        this.setClassDefinitionOnTypeDeclaration(cls, type);
        this.cacheTypes.put(cls.getCanonicalName(), type);
        return type;
    }

    public TypeDeclaration getAndRegisterTypeDeclaration(Class<?> cls, String packageName) {
        if (cls.isPrimitive() || cls.isArray()) {
            return null;
        }
        TypeDeclaration typeDeclaration = this.getCachedTypeDeclaration(cls);
        if (typeDeclaration != null) {
            this.registerTypeDeclaration(packageName, typeDeclaration);
            return typeDeclaration;
        }
        typeDeclaration = this.getExistingTypeDeclaration(cls);
        if (typeDeclaration != null) {
            this.initTypeDeclaration(cls, typeDeclaration);
            return typeDeclaration;
        }
        typeDeclaration = this.createTypeDeclarationForBean(cls);
        this.initTypeDeclaration(cls, typeDeclaration);
        this.registerTypeDeclaration(packageName, typeDeclaration);
        return typeDeclaration;
    }

    TypeDeclaration getTypeDeclaration(Class<?> cls) {
        if (cls.isPrimitive() || cls.isArray()) {
            return null;
        }
        TypeDeclaration tdecl = this.getCachedTypeDeclaration(cls);
        return tdecl != null ? tdecl : this.createTypeDeclaration(cls);
    }

    private void registerTypeDeclaration(String packageName, TypeDeclaration typeDeclaration) {
        if (typeDeclaration.getNature() == TypeDeclaration.Nature.DECLARATION || packageName.equals(typeDeclaration.getTypeClass().getPackage().getName())) {
            PackageRegistry packageRegistry = this.kbuilder.getPackageRegistry(packageName);
            if (packageRegistry != null) {
                packageRegistry.getPackage().addTypeDeclaration(typeDeclaration);
            } else {
                this.kbuilder.newPackage(new PackageDescr(packageName, ""));
                this.kbuilder.getPackageRegistry(packageName).getPackage().addTypeDeclaration(typeDeclaration);
            }
        }
    }

    private TypeDeclaration createTypeDeclaration(Class<?> cls) {
        TypeDeclaration typeDeclaration = this.getExistingTypeDeclaration(cls);
        if (typeDeclaration == null) {
            typeDeclaration = this.createTypeDeclarationForBean(cls);
        }
        this.initTypeDeclaration(cls, typeDeclaration);
        return typeDeclaration;
    }

    public TypeDeclaration getCachedTypeDeclaration(Class<?> cls) {
        return this.getCachedTypeDeclaration(cls.getName());
    }

    public TypeDeclaration getCachedTypeDeclaration(String className) {
        return this.cacheTypes.get(className);
    }

    private TypeDeclaration getExistingTypeDeclaration(Class<?> cls) {
        TypeDeclaration typeDeclaration = null;
        PackageRegistry pkgReg = this.kbuilder.getPackageRegistry(ClassUtils.getPackage(cls));
        if (pkgReg != null) {
            String className = cls.getName();
            String typeName = className.substring(className.lastIndexOf(".") + 1);
            typeDeclaration = pkgReg.getPackage().getTypeDeclaration(typeName);
        }
        return typeDeclaration;
    }

    private void initTypeDeclaration(Class<?> cls, TypeDeclaration typeDeclaration) {
        ClassDefinition clsDef = typeDeclaration.getTypeClassDef();
        if (clsDef == null) {
            clsDef = this.setClassDefinitionOnTypeDeclaration(cls, typeDeclaration);
        } else {
            this.processFieldsPosition(cls, clsDef, typeDeclaration);
        }
        if (typeDeclaration.isPropertyReactive()) {
            this.processModifiedProps(cls, clsDef);
        }
        LinkedHashSet<TypeDeclaration> tdecls = new LinkedHashSet<TypeDeclaration>();
        tdecls.add(typeDeclaration);
        this.buildTypeDeclarations(cls, tdecls);
        TypeDeclaration[] tarray = tdecls.toArray(new TypeDeclaration[tdecls.size()]);
        for (int i = tarray.length - 1; i >= 0; --i) {
            TypeDeclaration currentTDecl = tarray[i];
            if (!BitMaskUtil.isSet((long)typeDeclaration.getSetMask(), (long)1L) && BitMaskUtil.isSet((long)currentTDecl.getSetMask(), (long)1L)) {
                typeDeclaration.setRole(currentTDecl.getRole());
            }
            if (!BitMaskUtil.isSet((long)typeDeclaration.getSetMask(), (long)4L) && BitMaskUtil.isSet((long)currentTDecl.getSetMask(), (long)4L)) {
                typeDeclaration.setFormat(currentTDecl.getFormat());
            }
            if (BitMaskUtil.isSet((long)typeDeclaration.getSetMask(), (long)2L) || !BitMaskUtil.isSet((long)currentTDecl.getSetMask(), (long)2L)) continue;
            typeDeclaration.setTypesafe(currentTDecl.isTypesafe());
        }
        this.cacheTypes.put(cls.getName(), typeDeclaration);
    }

    private ClassDefinition setClassDefinitionOnTypeDeclaration(Class<?> cls, TypeDeclaration typeDeclaration) {
        ClassDefinition clsDef = new ClassDefinition();
        ClassDefinitionFactory.populateDefinitionFromClass(clsDef, typeDeclaration.getResource(), cls, cls.getAnnotation(Trait.class) != null);
        typeDeclaration.setTypeClassDef(clsDef);
        return clsDef;
    }

    private void processFieldsPosition(Class<?> cls, ClassDefinition clsDef, TypeDeclaration typeDeclaration) {
        LinkedList fields = new LinkedList();
        for (Class<?> tempKlass = cls; tempKlass != null && tempKlass != Object.class; tempKlass = tempKlass.getSuperclass()) {
            Collections.addAll(fields, tempKlass.getDeclaredFields());
        }
        FieldDefinition[] orderedFields = new FieldDefinition[fields.size()];
        for (Field fld : fields) {
            Position pos = fld.getAnnotation(Position.class);
            if (pos == null) continue;
            if (pos.value() < 0 || pos.value() >= fields.size()) {
                this.kbuilder.addBuilderResult(new TypeDeclarationError(typeDeclaration, "Out of range position " + pos.value() + " for field '" + fld.getName() + "' on class " + cls.getName()));
                continue;
            }
            if (orderedFields[pos.value()] != null) {
                this.kbuilder.addBuilderResult(new TypeDeclarationError(typeDeclaration, "Duplicated position " + pos.value() + " for field '" + fld.getName() + "' on class " + cls.getName()));
                continue;
            }
            FieldDefinition fldDef = clsDef.getField(fld.getName());
            if (fldDef == null) {
                fldDef = new FieldDefinition(fld.getName(), fld.getType().getName());
            }
            fldDef.setIndex(pos.value());
            orderedFields[pos.value()] = fldDef;
        }
        for (FieldDefinition fld : orderedFields) {
            if (fld == null) continue;
            clsDef.addField(fld);
        }
    }

    private void processModifiedProps(Class<?> cls, ClassDefinition clsDef) {
        for (Method method : cls.getDeclaredMethods()) {
            Modifies modifies = method.getAnnotation(Modifies.class);
            if (modifies == null) continue;
            String[] props = modifies.value();
            ArrayList<String> properties = new ArrayList<String>(props.length);
            for (String prop : props) {
                properties.add(prop.trim());
            }
            clsDef.addModifiedPropsByMethod(method, properties);
        }
    }

    private TypeDeclaration createTypeDeclarationForBean(Class<?> cls) {
        Annotated.ClassAdapter annotated = new Annotated.ClassAdapter(cls);
        TypeDeclaration typeDeclaration = TypeDeclaration.createTypeDeclarationForBean(cls, (Annotated)annotated, (PropertySpecificOption)this.kbuilder.getBuilderConfiguration().getPropertySpecificOption());
        String namespace = ClassUtils.getPackage(cls);
        PackageRegistry pkgRegistry = this.kbuilder.getPackageRegistry(namespace);
        if (pkgRegistry == null) {
            pkgRegistry = this.kbuilder.createPackageRegistry(new PackageDescr(namespace));
        }
        TypeDeclarationConfigurator.processMvelBasedAccessors(this.kbuilder, pkgRegistry, (Annotated)annotated, typeDeclaration);
        return typeDeclaration;
    }

    private void buildTypeDeclarations(Class<?> cls, Set<TypeDeclaration> tdecls) {
        Class<?>[] intfs;
        for (Class<?> intf : intfs = cls.getInterfaces()) {
            this.buildTypeDeclarationInterfaces(intf, tdecls);
        }
        for (cls = cls.getSuperclass(); cls != null && cls != Object.class && this.buildTypeDeclarationInterfaces(cls, tdecls); cls = cls.getSuperclass()) {
        }
    }

    private boolean buildTypeDeclarationInterfaces(Class cls, Set<TypeDeclaration> tdecls) {
        Class<?>[] intfs;
        PackageRegistry pkgReg;
        TypeDeclaration tdecl = this.cacheTypes.get(cls.getName());
        if (tdecl == null && (pkgReg = this.kbuilder.getPackageRegistry(ClassUtils.getPackage((Class)cls))) != null) {
            tdecl = pkgReg.getPackage().getTypeDeclaration(cls.getSimpleName());
        }
        if (tdecl != null && !tdecls.add(tdecl)) {
            return false;
        }
        for (Class<?> intf : intfs = cls.getInterfaces()) {
            pkgReg = this.kbuilder.getPackageRegistry(ClassUtils.getPackage(intf));
            if (pkgReg != null) {
                tdecl = pkgReg.getPackage().getTypeDeclaration(intf.getSimpleName());
            }
            if (tdecl == null) continue;
            tdecls.add(tdecl);
        }
        for (Class<?> intf : intfs) {
            if (this.buildTypeDeclarationInterfaces(intf, tdecls)) continue;
            return false;
        }
        return true;
    }

    void removeTypesGeneratedFromResource(Resource resource) {
        if (this.cacheTypes != null) {
            ArrayList typesToBeRemoved = new ArrayList();
            for (Map.Entry<String, TypeDeclaration> type : this.cacheTypes.entrySet()) {
                if (!resource.equals(type.getValue().getResource())) continue;
                typesToBeRemoved.add(type.getKey());
            }
            for (Map.Entry<String, TypeDeclaration> type : typesToBeRemoved) {
                this.cacheTypes.remove(type);
            }
        }
    }
}

