/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.kie.builder.impl;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.appformer.maven.support.AFReleaseId;
import org.appformer.maven.support.AFReleaseIdImpl;
import org.appformer.maven.support.DependencyFilter;
import org.appformer.maven.support.PomModel;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.compiler.commons.jci.compilers.CompilationResult;
import org.drools.compiler.commons.jci.compilers.EclipseJavaCompiler;
import org.drools.compiler.commons.jci.compilers.JavaCompiler;
import org.drools.compiler.commons.jci.compilers.JavaCompilerFactory;
import org.drools.compiler.commons.jci.problems.CompilationProblem;
import org.drools.compiler.commons.jci.readers.DiskResourceReader;
import org.drools.compiler.commons.jci.readers.ResourceReader;
import org.drools.compiler.compiler.io.memory.MemoryFileSystem;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieBuilderSetImpl;
import org.drools.compiler.kie.builder.impl.KieFileSystemImpl;
import org.drools.compiler.kie.builder.impl.KieMetaInfoBuilder;
import org.drools.compiler.kie.builder.impl.KieModuleKieProject;
import org.drools.compiler.kie.builder.impl.KieProject;
import org.drools.compiler.kie.builder.impl.KieRepositoryImpl;
import org.drools.compiler.kie.builder.impl.MemoryKieModule;
import org.drools.compiler.kie.builder.impl.ResultsImpl;
import org.drools.compiler.kproject.ReleaseIdImpl;
import org.drools.compiler.kproject.models.KieModuleModelImpl;
import org.drools.compiler.rule.builder.dialect.java.JavaDialectConfiguration;
import org.drools.core.builder.conf.impl.ResourceConfigurationImpl;
import org.drools.core.util.IoUtils;
import org.drools.core.util.StringUtils;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.KieRepository;
import org.kie.api.builder.Message;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.Results;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.builder.model.KieSessionModel;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceConfiguration;
import org.kie.api.io.ResourceType;
import org.kie.internal.builder.IncrementalResults;
import org.kie.internal.builder.InternalKieBuilder;
import org.kie.internal.builder.KieBuilderSet;

public class KieBuilderImpl
implements InternalKieBuilder {
    static final String RESOURCES_ROOT = "src/main/resources/";
    static final String JAVA_ROOT = "src/main/java/";
    static final String JAVA_TEST_ROOT = "src/test/java/";
    private static final String RESOURCES_ROOT_DOT_SEPARATOR = "src/main/resources/".replace('/', '.');
    private static final String SPRING_BOOT_ROOT = "BOOT-INF.classes.";
    private static final String[] SUPPORTED_RESOURCES_ROOTS = new String[]{RESOURCES_ROOT_DOT_SEPARATOR, "BOOT-INF.classes."};
    private ResultsImpl results;
    private final ResourceReader srcMfs;
    private MemoryFileSystem trgMfs;
    private MemoryKieModule kModule;
    private byte[] pomXml;
    private AFReleaseId releaseId;
    private byte[] kModuleModelXml;
    private KieModuleModel kModuleModel;
    private Collection<KieModule> kieDependencies;
    private KieBuilderSetImpl kieBuilderSet;
    private ClassLoader classLoader;
    private PomModel pomModel;

    public KieBuilderImpl(File file) {
        this.srcMfs = new DiskResourceReader(file);
    }

    public KieBuilderImpl(KieFileSystem kieFileSystem) {
        this(kieFileSystem, null);
    }

    public KieBuilderImpl(KieFileSystem kieFileSystem, ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.srcMfs = ((KieFileSystemImpl)kieFileSystem).asMemoryFileSystem();
    }

    public KieBuilder setDependencies(KieModule ... dependencies) {
        this.kieDependencies = Arrays.asList(dependencies);
        return this;
    }

    public KieBuilder setDependencies(Resource ... resources) {
        KieRepositoryImpl kr = (KieRepositoryImpl)KieServices.Factory.get().getRepository();
        ArrayList<KieModule> list = new ArrayList<KieModule>();
        for (Resource res : resources) {
            InternalKieModule depKieMod = (InternalKieModule)kr.getKieModule(res);
            list.add(depKieMod);
        }
        this.kieDependencies = list;
        return this;
    }

    private PomModel init() {
        KieServices ks = KieServices.Factory.get();
        this.results = new ResultsImpl();
        PomModel pomModel = this.getPomModel();
        this.buildKieModuleModel();
        if (pomModel != null) {
            this.releaseId = pomModel.getReleaseId();
            KieRepositoryImpl repository = (KieRepositoryImpl)ks.getRepository();
            for (AFReleaseId dep : pomModel.getDependencies(DependencyFilter.COMPILE_FILTER)) {
                KieModule depModule = repository.getKieModule(ReleaseIdImpl.adapt(dep), pomModel);
                if (depModule == null) continue;
                this.addKieDependency(depModule);
            }
        } else {
            this.releaseId = KieServices.Factory.get().getRepository().getDefaultReleaseId();
        }
        return pomModel;
    }

    private void addKieDependency(KieModule depModule) {
        if (this.kieDependencies == null) {
            this.kieDependencies = new ArrayList<KieModule>();
        }
        this.kieDependencies.add(depModule);
    }

    public KieBuilder buildAll() {
        return this.buildAll(KieModuleKieProject::new, o -> true);
    }

    public KieBuilder buildAll(Predicate<String> classFilter) {
        return this.buildAll(KieModuleKieProject::new, classFilter);
    }

    public KieBuilder buildAll(BiFunction<InternalKieModule, ClassLoader, KieProject> kprojectSupplier) {
        return this.buildAll(kprojectSupplier, o -> true);
    }

    public KieBuilder buildAll(BiFunction<InternalKieModule, ClassLoader, KieProject> kprojectSupplier, Predicate<String> classFilter) {
        PomModel pomModel = this.init();
        if (!this.isBuilt() && this.kModuleModel != null) {
            this.trgMfs = new MemoryFileSystem();
            this.writePomAndKModule();
            this.addKBasesFilesToTrg();
            this.markSource();
            this.kModule = new MemoryKieModule(ReleaseIdImpl.adapt(this.releaseId), this.kModuleModel, this.trgMfs);
            if (this.kieDependencies != null && !this.kieDependencies.isEmpty()) {
                for (KieModule kieModule : this.kieDependencies) {
                    this.kModule.addKieDependency((InternalKieModule)kieModule);
                }
            }
            if (pomModel != null) {
                this.kModule.setPomModel(pomModel);
            }
            KieProject kProject = kprojectSupplier.apply(this.kModule, this.classLoader);
            for (ReleaseId unresolvedDep : this.kModule.getUnresolvedDependencies()) {
                this.results.addMessage(Message.Level.ERROR, "pom.xml", "Unresolved dependency " + unresolvedDep);
            }
            this.compileJavaClasses(kProject.getClassLoader(), classFilter);
            KieBuilderImpl.buildKieProject(this.kModule, this.results, kProject, this.trgMfs);
        }
        return this;
    }

    void markSource() {
        this.srcMfs.mark();
    }

    Collection<String> getModifiedResourcesSinceLastMark() {
        return this.srcMfs.getModifiedResourcesSinceLastMark();
    }

    void updateKieModuleMetaInfo() {
        new KieMetaInfoBuilder(this.kModule).writeKieModuleMetaInfo(this.trgMfs);
    }

    public static String getCompilationCachePath(AFReleaseId releaseId, String kbaseName) {
        return ((AFReleaseIdImpl)releaseId).getCompilationCachePathPrefix() + kbaseName.replace('.', '/') + "/kbase.cache";
    }

    public static void buildKieModule(InternalKieModule kModule, ResultsImpl messages) {
        KieBuilderImpl.buildKieProject(kModule, messages, new KieModuleKieProject(kModule), null);
    }

    private static void buildKieProject(InternalKieModule kModule, ResultsImpl messages, KieProject kProject, MemoryFileSystem trgMfs) {
        kProject.init();
        kProject.verify(messages);
        if (messages.filterMessages(Message.Level.ERROR).isEmpty()) {
            if (trgMfs != null) {
                new KieMetaInfoBuilder(kModule).writeKieModuleMetaInfo(trgMfs);
                kProject.writeProjectOutput(trgMfs);
            }
            KieRepository kieRepository = KieServices.Factory.get().getRepository();
            kieRepository.addKieModule((KieModule)kModule);
            for (InternalKieModule kDep : kModule.getKieDependencies().values()) {
                kieRepository.addKieModule((KieModule)kDep);
            }
        }
    }

    private void addKBasesFilesToTrg() {
        for (KieBaseModel kieBaseModel : this.kModuleModel.getKieBaseModels().values()) {
            this.addKBaseFilesToTrg(kieBaseModel);
        }
    }

    private void addKBaseFilesToTrg(KieBaseModel kieBase) {
        for (String fileName : this.srcMfs.getFileNames()) {
            if (!(fileName = fileName.replace(File.separatorChar, '/')).startsWith(RESOURCES_ROOT) || !KieBuilderImpl.isFileInKieBase(kieBase, fileName)) continue;
            this.copySourceToTarget(fileName);
        }
    }

    String copySourceToTarget(String fileName) {
        if (!fileName.startsWith(RESOURCES_ROOT)) {
            return null;
        }
        byte[] bytes = this.srcMfs.getBytes(fileName);
        String trgFileName = fileName.substring(RESOURCES_ROOT.length());
        if (bytes != null) {
            this.trgMfs.write(trgFileName, bytes, true);
        } else {
            this.trgMfs.remove(trgFileName);
        }
        return trgFileName;
    }

    public void setkModule(MemoryKieModule kModule) {
        this.kModule = kModule;
    }

    public MemoryKieModule getkModule() {
        return this.kModule;
    }

    public void setTrgMfs(MemoryFileSystem trgMfs) {
        this.trgMfs = trgMfs;
    }

    public MemoryFileSystem getTrgMfs() {
        return this.trgMfs;
    }

    void cloneKieModuleForIncrementalCompilation() {
        if (!Arrays.equals(this.pomXml, KieBuilderImpl.getOrGeneratePomXml(this.srcMfs))) {
            this.pomModel = null;
        }
        this.trgMfs = this.trgMfs.clone();
        this.init();
        this.kModule = this.kModule.cloneForIncrementalCompilation(ReleaseIdImpl.adapt(this.releaseId), this.kModuleModel, this.trgMfs);
    }

    private void addMetaInfBuilder() {
        for (String fileName : this.srcMfs.getFileNames()) {
            if (!fileName.startsWith(RESOURCES_ROOT) || KieBuilderImpl.isKieExtension(fileName)) continue;
            byte[] bytes = this.srcMfs.getBytes(fileName);
            this.trgMfs.write(fileName.substring(RESOURCES_ROOT.length() - 1), bytes, true);
        }
    }

    private static ResourceType getResourceType(InternalKieModule kieModule, String fileName) {
        return KieBuilderImpl.getResourceType(kieModule.getResourceConfiguration(fileName));
    }

    private static ResourceType getResourceType(ResourceConfiguration conf) {
        return conf instanceof ResourceConfigurationImpl ? ((ResourceConfigurationImpl)conf).getResourceType() : null;
    }

    public static boolean filterFileInKBase(InternalKieModule kieModule, KieBaseModel kieBase, String fileName) {
        return KieBuilderImpl.isFileInKieBase(kieBase, fileName) && (KieBuilderImpl.isKieExtension(fileName) || KieBuilderImpl.getResourceType(kieModule, fileName) != null);
    }

    private static boolean isKieExtension(String fileName) {
        return !KieBuilderImpl.isJavaSourceFile(fileName) && ResourceType.determineResourceType((String)fileName) != null;
    }

    private static boolean isFileInKieBase(KieBaseModel kieBase, String fileName) {
        String pkgNameForFile;
        int lastSep = fileName.lastIndexOf("/");
        if (lastSep + 1 < fileName.length() && fileName.charAt(lastSep + 1) == '.') {
            return false;
        }
        if (kieBase.getPackages().isEmpty()) {
            return true;
        }
        String string = pkgNameForFile = lastSep > 0 ? fileName.substring(0, lastSep) : "";
        if (pkgNameForFile.startsWith(RESOURCES_ROOT)) {
            pkgNameForFile = pkgNameForFile.substring(RESOURCES_ROOT.length());
        }
        pkgNameForFile = pkgNameForFile.replace('/', '.');
        for (String pkgName : kieBase.getPackages()) {
            String pkgNameNoWildcard;
            boolean isNegative = pkgName.startsWith("!");
            if (isNegative) {
                pkgName = pkgName.substring(1);
            }
            if (pkgName.equals("*") || pkgNameForFile.equals(pkgName) || pkgNameForFile.endsWith("." + pkgName)) {
                return !isNegative;
            }
            if (!pkgName.endsWith(".*")) continue;
            String relativePkgNameForFile = KieBuilderImpl.getRelativePackageName(pkgNameForFile);
            if (relativePkgNameForFile.equals(pkgNameNoWildcard = pkgName.substring(0, pkgName.length() - 2)) || relativePkgNameForFile.startsWith(pkgNameNoWildcard + ".")) {
                return !isNegative;
            }
            if (!relativePkgNameForFile.startsWith(kieBase.getName() + ".") || !(relativePkgNameForFile = relativePkgNameForFile.substring(kieBase.getName().length() + 1)).equals(pkgNameNoWildcard) && !relativePkgNameForFile.startsWith(pkgNameNoWildcard + ".")) continue;
            return !isNegative;
        }
        return false;
    }

    private static String getRelativePackageName(String pkgNameForFile) {
        for (String root : SUPPORTED_RESOURCES_ROOTS) {
            if (!pkgNameForFile.startsWith(root)) continue;
            return pkgNameForFile.substring(root.length());
        }
        return pkgNameForFile;
    }

    public Results getResults() {
        if (!this.isBuilt()) {
            this.buildAll();
        }
        return this.results;
    }

    public KieModule getKieModule() {
        return this.getKieModule(false);
    }

    public KieModule getKieModuleIgnoringErrors() {
        return this.getKieModule(true);
    }

    private KieModule getKieModule(boolean ignoreErrors) {
        if (!this.isBuilt()) {
            this.buildAll();
        }
        if (!ignoreErrors && (this.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR}) || this.kModule == null)) {
            throw new RuntimeException("Unable to get KieModule, Errors Existed");
        }
        return this.kModule;
    }

    private boolean isBuilt() {
        return this.kModule != null;
    }

    private void buildKieModuleModel() {
        if (this.srcMfs.isAvailable("src/main/resources/META-INF/kmodule.xml")) {
            this.kModuleModelXml = this.srcMfs.getBytes("src/main/resources/META-INF/kmodule.xml");
            try {
                this.kModuleModel = KieModuleModelImpl.fromXML(new ByteArrayInputStream(this.kModuleModelXml));
            }
            catch (Exception e) {
                this.results.addMessage(Message.Level.ERROR, "kmodule.xml", "kmodule.xml found, but unable to read\n" + e.getMessage());
            }
        } else {
            this.kModuleModel = KieServices.Factory.get().newKieModuleModel();
        }
        if (KieBuilderImpl.setDefaultsforEmptyKieModule(this.kModuleModel)) {
            this.kModuleModelXml = this.kModuleModel.toXML().getBytes(IoUtils.UTF8_CHARSET);
        }
    }

    public static boolean setDefaultsforEmptyKieModule(KieModuleModel kModuleModel) {
        if (kModuleModel != null && kModuleModel.getKieBaseModels().isEmpty()) {
            KieBaseModel kieBaseModel = kModuleModel.newKieBaseModel("defaultKieBase").addPackage("*").setDefault(true);
            kieBaseModel.newKieSessionModel("defaultKieSession").setDefault(true);
            kieBaseModel.newKieSessionModel("defaultStatelessKieSession").setType(KieSessionModel.KieSessionType.STATELESS).setDefault(true);
            return true;
        }
        return false;
    }

    public PomModel getPomModel() {
        if (this.pomModel == null) {
            this.pomModel = this.buildPomModel();
        }
        return this.pomModel;
    }

    public void setPomModel(PomModel pomModel) {
        this.pomModel = pomModel;
        if (this.srcMfs.isAvailable("pom.xml")) {
            this.pomXml = this.srcMfs.getBytes("pom.xml");
        }
    }

    private PomModel buildPomModel() {
        this.pomXml = KieBuilderImpl.getOrGeneratePomXml(this.srcMfs);
        if (this.pomXml == null) {
            return null;
        }
        try {
            PomModel tempPomModel = PomModel.Parser.parse((String)"pom.xml", (InputStream)new ByteArrayInputStream(this.pomXml));
            KieBuilderImpl.validatePomModel(tempPomModel);
            return tempPomModel;
        }
        catch (Exception e) {
            this.results.addMessage(Message.Level.ERROR, "pom.xml", "maven pom.xml found, but unable to read\n" + e.getMessage());
            return null;
        }
    }

    public static void validatePomModel(PomModel pomModel) {
        AFReleaseId pomReleaseId = pomModel.getReleaseId();
        if (StringUtils.isEmpty((CharSequence)pomReleaseId.getGroupId()) || StringUtils.isEmpty((CharSequence)pomReleaseId.getArtifactId()) || StringUtils.isEmpty((CharSequence)pomReleaseId.getVersion())) {
            throw new RuntimeException("Maven pom.properties exists but ReleaseId content is malformed");
        }
    }

    public static byte[] getOrGeneratePomXml(ResourceReader mfs) {
        if (mfs.isAvailable("pom.xml")) {
            return mfs.getBytes("pom.xml");
        }
        return KieBuilderImpl.generatePomXml((AFReleaseId)KieServices.Factory.get().getRepository().getDefaultReleaseId()).getBytes(IoUtils.UTF8_CHARSET);
    }

    public void writePomAndKModule() {
        this.addMetaInfBuilder();
        if (this.pomXml != null) {
            AFReleaseIdImpl g = (AFReleaseIdImpl)this.releaseId;
            this.trgMfs.write(g.getPomXmlPath(), this.pomXml, true);
            this.trgMfs.write(g.getPomPropertiesPath(), KieBuilderImpl.generatePomProperties(this.releaseId).getBytes(IoUtils.UTF8_CHARSET), true);
        }
        if (this.kModuleModelXml != null) {
            this.trgMfs.write("META-INF/kmodule.xml", this.kModuleModel.toXML().getBytes(IoUtils.UTF8_CHARSET), true);
        }
    }

    public static String generatePomXml(AFReleaseId releaseId) {
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \n");
        sBuilder.append("         xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\"> \n");
        sBuilder.append("    <modelVersion>4.0.0</modelVersion> \n");
        sBuilder.append("    <groupId>");
        sBuilder.append(releaseId.getGroupId());
        sBuilder.append("</groupId> \n");
        sBuilder.append("    <artifactId>");
        sBuilder.append(releaseId.getArtifactId());
        sBuilder.append("</artifactId> \n");
        sBuilder.append("    <version>");
        sBuilder.append(releaseId.getVersion());
        sBuilder.append("</version> \n");
        sBuilder.append("    <packaging>jar</packaging> \n");
        sBuilder.append("    <name>Default</name> \n");
        sBuilder.append("</project>  \n");
        return sBuilder.toString();
    }

    public static String generatePomProperties(AFReleaseId releaseId) {
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("groupId=");
        sBuilder.append(releaseId.getGroupId());
        sBuilder.append("\n");
        sBuilder.append("artifactId=");
        sBuilder.append(releaseId.getArtifactId());
        sBuilder.append("\n");
        sBuilder.append("version=");
        sBuilder.append(releaseId.getVersion());
        sBuilder.append("\n");
        return sBuilder.toString();
    }

    private void compileJavaClasses(ClassLoader classLoader, Predicate<String> classFilter) {
        ArrayList<String> classFiles = new ArrayList<String>();
        for (String fileName : this.srcMfs.getFileNames()) {
            if (!fileName.endsWith(".class")) continue;
            this.trgMfs.write(fileName, this.srcMfs.getBytes(fileName), true);
            classFiles.add(fileName.substring(0, fileName.length() - ".class".length()));
        }
        ArrayList<String> javaFiles = new ArrayList<String>();
        ArrayList<String> javaTestFiles = new ArrayList<String>();
        for (String fileName : this.srcMfs.getFileNames()) {
            if (!KieBuilderImpl.isJavaSourceFile(fileName) || !KieBuilderImpl.noClassFileForGivenSourceFile(classFiles, fileName) || !KieBuilderImpl.notVetoedByFilter(classFilter, fileName)) continue;
            if (!(fileName = fileName.replace(File.separatorChar, '/')).startsWith(JAVA_ROOT) && !fileName.startsWith(JAVA_TEST_ROOT)) {
                this.results.addMessage(Message.Level.WARNING, fileName, "Found Java file out of the Java source folder: \"" + fileName + "\"");
                continue;
            }
            if (fileName.substring(JAVA_ROOT.length()).indexOf(47) < 0) {
                this.results.addMessage(Message.Level.ERROR, fileName, "A Java class must have a package: " + fileName.substring(JAVA_ROOT.length()) + " is not allowed");
                continue;
            }
            if (fileName.startsWith(JAVA_ROOT)) {
                javaFiles.add(fileName);
                continue;
            }
            javaTestFiles.add(fileName);
        }
        if (!javaFiles.isEmpty() || !javaTestFiles.isEmpty()) {
            KnowledgeBuilderConfigurationImpl kconf = new KnowledgeBuilderConfigurationImpl(classLoader);
            JavaDialectConfiguration javaConf = (JavaDialectConfiguration)kconf.getDialectConfiguration("java");
            this.compileJavaClasses(javaConf, classLoader, javaFiles, JAVA_ROOT);
            this.compileJavaClasses(javaConf, classLoader, javaTestFiles, JAVA_TEST_ROOT);
        }
    }

    private static boolean notVetoedByFilter(Predicate<String> classFilter, String sourceFileName) {
        return classFilter.test(sourceFileName);
    }

    private static boolean noClassFileForGivenSourceFile(List<String> classFiles, String sourceFileName) {
        return !classFiles.contains(sourceFileName.substring(0, sourceFileName.length() - ".java".length()));
    }

    private static boolean isJavaSourceFile(String fileName) {
        return fileName.endsWith(".java");
    }

    private void compileJavaClasses(JavaDialectConfiguration javaConf, ClassLoader classLoader, List<String> javaFiles, String rootFolder) {
        if (!javaFiles.isEmpty()) {
            String[] sourceFiles = javaFiles.toArray(new String[javaFiles.size()]);
            JavaCompiler javaCompiler = this.createCompiler(javaConf, rootFolder);
            CompilationResult res = javaCompiler.compile(sourceFiles, this.srcMfs, this.trgMfs, classLoader);
            for (CompilationProblem problem : res.getErrors()) {
                this.results.addMessage(problem);
            }
            for (CompilationProblem problem : res.getWarnings()) {
                this.results.addMessage(problem);
            }
        }
    }

    private JavaCompiler createCompiler(JavaDialectConfiguration javaConf, String prefix) {
        JavaCompiler javaCompiler = JavaCompilerFactory.getInstance().loadCompiler(javaConf);
        if (javaCompiler instanceof EclipseJavaCompiler) {
            ((EclipseJavaCompiler)javaCompiler).setPrefix(prefix);
        }
        return javaCompiler;
    }

    public static String findPomProperties(ZipFile zipFile) {
        Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
        while (zipEntries.hasMoreElements()) {
            ZipEntry zipEntry = zipEntries.nextElement();
            String fileName = zipEntry.getName();
            if (!fileName.endsWith("pom.properties") || !fileName.startsWith("META-INF/maven/")) continue;
            return fileName;
        }
        return null;
    }

    public static File findPomProperties(File root) {
        File mavenRoot = new File(root, "META-INF/maven");
        return KieBuilderImpl.recurseToPomProperties(mavenRoot);
    }

    public static File recurseToPomProperties(File file) {
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                if (child.isDirectory()) {
                    File returnedFile = KieBuilderImpl.recurseToPomProperties(child);
                    if (returnedFile == null) continue;
                    return returnedFile;
                }
                if (!child.getName().endsWith("pom.properties")) continue;
                return child;
            }
        }
        return null;
    }

    public KieBuilderSet createFileSet(String ... files) {
        if (this.kieBuilderSet == null) {
            this.kieBuilderSet = new KieBuilderSetImpl(this);
        }
        return this.kieBuilderSet.setFiles(files);
    }

    public IncrementalResults incrementalBuild() {
        return new KieBuilderSetImpl(this).build();
    }
}

