/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.rule.builder.dialect.mvel;

import java.util.Arrays;
import java.util.Map;
import org.drools.compiler.compiler.BoundIdentifiers;
import org.drools.compiler.compiler.DescrBuildError;
import org.drools.compiler.rule.builder.RuleBuildContext;
import org.drools.compiler.rule.builder.SalienceBuilder;
import org.drools.compiler.rule.builder.dialect.DialectUtil;
import org.drools.compiler.rule.builder.dialect.mvel.MVELAnalysisResult;
import org.drools.compiler.rule.builder.dialect.mvel.MVELDialect;
import org.drools.core.base.mvel.MVELCompilationUnit;
import org.drools.core.base.mvel.MVELCompileable;
import org.drools.core.base.mvel.MVELSalienceExpression;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.MVELDialectRuntimeData;
import org.drools.core.rule.RuleConditionElement;
import org.drools.core.spi.DeclarationScopeResolver;
import org.drools.core.spi.KnowledgeHelper;
import org.drools.core.spi.Salience;
import org.drools.core.spi.Wireable;
import org.kie.internal.security.KiePolicyHelper;

public class MVELSalienceBuilder
implements SalienceBuilder {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void build(RuleBuildContext context) {
        boolean typesafe = context.isTypesafe();
        context.getDeclarationResolver().pushOnBuildStack((RuleConditionElement)context.getRule().getLhs());
        try {
            MVELDialect dialect = (MVELDialect)context.getDialect("mvel");
            Map decls = context.getDeclarationResolver().getDeclarations(context.getRule());
            MVELAnalysisResult analysis = (MVELAnalysisResult)dialect.analyzeExpression(context, context.getRuleDescr(), context.getRuleDescr().getSalience(), new BoundIdentifiers(DeclarationScopeResolver.getDeclarationClasses((Map)decls), context));
            context.setTypesafe(analysis.isTypesafe());
            BoundIdentifiers usedIdentifiers = analysis.getBoundIdentifiers();
            int i = usedIdentifiers.getDeclrClasses().keySet().size();
            Declaration[] previousDeclarations = new Declaration[i];
            i = 0;
            for (String id : usedIdentifiers.getDeclrClasses().keySet()) {
                previousDeclarations[i++] = (Declaration)decls.get(id);
            }
            Arrays.sort(previousDeclarations, RuleTerminalNode.SortDeclarations.instance);
            MVELCompilationUnit unit = dialect.getMVELCompilationUnit(context.getRuleDescr().getSalience(), analysis, previousDeclarations, null, null, context, "drools", KnowledgeHelper.class, false, MVELCompilationUnit.Scope.EXPRESSION);
            MVELSalienceExpression expr = new MVELSalienceExpression(unit, dialect.getId());
            context.getRule().setSalience((Salience)(KiePolicyHelper.isPolicyEnabled() ? new RuleImpl.SafeSalience((Salience)expr) : expr));
            MVELDialectRuntimeData data = (MVELDialectRuntimeData)context.getPkg().getDialectRuntimeRegistry().getDialectData("mvel");
            data.addCompileable((Wireable)context.getRule(), (MVELCompileable)expr);
            expr.compile(data, context.getRule());
        }
        catch (Exception e) {
            DialectUtil.copyErrorLocation(e, context.getRuleDescr());
            context.addError(new DescrBuildError(context.getParentDescr(), context.getRuleDescr(), null, "Unable to build expression for 'salience' : " + e.getMessage() + "'" + context.getRuleDescr().getSalience() + "'"));
        }
        finally {
            context.setTypesafe(typesafe);
        }
    }
}

