/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.kie.builder.impl;

import java.util.Map;
import org.drools.compiler.commons.jci.stores.ResourceStore;
import org.drools.compiler.kie.builder.impl.AbstractKieModule;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieMetaInfoBuilder;
import org.kie.api.internal.utils.ServiceRegistry;

public interface CompilationCacheProvider {
    public static CompilationCacheProvider get() {
        return Holder.INSTANCE;
    }

    public InternalKieModule.CompilationCache getCompilationCache(AbstractKieModule var1, Map<String, InternalKieModule.CompilationCache> var2, String var3);

    public void writeKieModuleMetaInfo(InternalKieModule var1, ResourceStore var2);

    public static enum DefaultCompilationCacheProvider implements CompilationCacheProvider
    {
        INSTANCE;


        @Override
        public InternalKieModule.CompilationCache getCompilationCache(AbstractKieModule kieModule, Map<String, InternalKieModule.CompilationCache> compilationCache, String kbaseName) {
            return null;
        }

        @Override
        public void writeKieModuleMetaInfo(InternalKieModule kModule, ResourceStore trgMfs) {
            new KieMetaInfoBuilder(kModule).writeKieModuleMetaInfo(trgMfs);
        }
    }

    public static class Holder {
        private static final CompilationCacheProvider INSTANCE = Holder.getCompilationCacheProvider();

        private static CompilationCacheProvider getCompilationCacheProvider() {
            CompilationCacheProvider provider = (CompilationCacheProvider)ServiceRegistry.getService(CompilationCacheProvider.class);
            return provider != null ? provider : DefaultCompilationCacheProvider.INSTANCE;
        }
    }
}

