/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.lang.descr;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import org.drools.compiler.lang.descr.DescrVisitor;
import org.drools.core.rule.Namespaceable;
import org.kie.api.io.Resource;

public class BaseDescr
implements Externalizable,
Namespaceable {
    private static final long serialVersionUID = 510L;
    private int startCharacter = -1;
    private int endCharacter = -1;
    private int line = -1;
    private int column = -1;
    private int endLine = -1;
    private int endColumn = -1;
    private String text = "";
    private Resource resource;
    private String namespace = "";

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.startCharacter = in.readInt();
        this.endCharacter = in.readInt();
        this.line = in.readInt();
        this.column = in.readInt();
        this.endLine = in.readInt();
        this.endColumn = in.readInt();
        this.text = (String)in.readObject();
        this.resource = (Resource)in.readObject();
        this.namespace = in.readUTF();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.startCharacter);
        out.writeInt(this.endCharacter);
        out.writeInt(this.line);
        out.writeInt(this.column);
        out.writeInt(this.endLine);
        out.writeInt(this.endColumn);
        out.writeObject(this.text);
        out.writeObject(this.resource);
        out.writeUTF(this.namespace);
    }

    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        if (resource != null) {
            this.resource = resource;
        }
    }

    public void setNamespace(String namespace) {
        Objects.requireNonNull(namespace);
        this.namespace = namespace;
    }

    public final String getNamespace() {
        return this.namespace;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setLocation(int line, int column) {
        this.line = line;
        this.column = column;
    }

    public void setEndLocation(int line, int column) {
        this.endLine = line;
        this.endColumn = column;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public int getEndColumn() {
        return this.endColumn;
    }

    public int getEndCharacter() {
        return this.endCharacter;
    }

    public void setEndCharacter(int endCharacter) {
        this.endCharacter = endCharacter;
    }

    public int getStartCharacter() {
        return this.startCharacter;
    }

    public void setStartCharacter(int startCharacter) {
        this.startCharacter = startCharacter;
    }

    public void copyLocation(BaseDescr d) {
        this.setLocation(d.getLine(), d.getColumn());
        this.setEndLocation(d.getEndLine(), d.getEndColumn());
        this.setStartCharacter(d.getStartCharacter());
        this.setEndCharacter(d.getEndCharacter());
    }

    public String positionAsString() {
        return "[Line: " + this.getLine() + ", Column: " + this.getColumn() + "]";
    }

    public BaseDescr replaceVariable(String oldVar, String newVar) {
        throw new UnsupportedOperationException();
    }

    public void accept(DescrVisitor visitor) {
        visitor.visit(this);
    }

    public BaseDescr negate() {
        throw new UnsupportedOperationException();
    }

    public boolean isNegated() {
        return false;
    }
}

