/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.rule.builder.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.kie.api.runtime.rule.AccumulateFunction;
import org.kie.internal.utils.ChainedProperties;

public class AccumulateUtil {
    public static String getFunctionName(Supplier<Class<?>> exprClassSupplier, String functionName) {
        Class<?> exprClass;
        if (functionName.equals("sum")) {
            Class<?> exprClass2 = exprClassSupplier.get();
            if (exprClass2 == Integer.TYPE || exprClass2 == Integer.class) {
                functionName = "sumI";
            } else if (exprClass2 == Long.TYPE || exprClass2 == Long.class) {
                functionName = "sumL";
            } else if (exprClass2 == BigInteger.class) {
                functionName = "sumBI";
            } else if (exprClass2 == BigDecimal.class) {
                functionName = "sumBD";
            }
        } else if (functionName.equals("average") && (exprClass = exprClassSupplier.get()) == BigDecimal.class) {
            functionName = "averageBD";
        }
        return functionName;
    }

    public static AccumulateFunction loadAccumulateFunction(ClassLoader classLoader, String identifier, String className) {
        try {
            Class<?> clazz = classLoader.loadClass(className);
            return (AccumulateFunction)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Error loading accumulate function for identifier " + identifier + ". Class " + className + " not found", e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Error loading accumulate function for identifier " + identifier + ". Instantiation failed for class " + className, e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error loading accumulate function for identifier " + identifier + ". Illegal access to class " + className, e);
        }
    }

    public static Map<String, AccumulateFunction> buildAccumulateFunctionsMap(ChainedProperties chainedProperties, ClassLoader typesClassLoader) {
        HashMap<String, AccumulateFunction> accumulateFunctions = new HashMap<String, AccumulateFunction>();
        HashMap temp = new HashMap();
        chainedProperties.mapStartsWith(temp, "drools.accumulate.function.", true);
        int index = "drools.accumulate.function.".length();
        for (Map.Entry entry : temp.entrySet()) {
            String identifier = ((String)entry.getKey()).trim().substring(index);
            accumulateFunctions.put(identifier, AccumulateUtil.loadAccumulateFunction(typesClassLoader, identifier, (String)entry.getValue()));
        }
        return accumulateFunctions;
    }
}

