/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.kie.builder.impl;

import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.drools.compiler.kie.builder.impl.AbstractKieScanner;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieContainerImpl;
import org.drools.core.impl.InternalKieContainer;
import org.kie.api.builder.KieScanner;
import org.kie.api.builder.ReleaseIdComparator;
import org.kie.api.runtime.KieContainer;

public class KieFileSystemScannerImpl
extends AbstractKieScanner<InternalKieModule>
implements KieScanner {
    private final File repositoryFolder;
    private final String kjarFileHead;
    private final VersionComparator versionComparator;

    public KieFileSystemScannerImpl(KieContainer kieContainer, String repositoryFolder) {
        this.kieContainer = (InternalKieContainer)kieContainer;
        this.kjarFileHead = kieContainer.getReleaseId().getArtifactId() + "-";
        this.versionComparator = new VersionComparator(this.kjarFileHead.length());
        this.repositoryFolder = new File(repositoryFolder);
    }

    @Override
    protected InternalKieModule internalScan() {
        File newKJar = this.findNewFile();
        return newKJar == null ? null : InternalKieModule.createKieModule(this.kieContainer.getReleaseId(), newKJar);
    }

    @Override
    protected void internalUpdate(InternalKieModule kmodule) {
        ((KieContainerImpl)this.kieContainer).updateToKieModule(kmodule);
    }

    private File findNewFile() {
        File[] files = this.repositoryFolder.listFiles((dir, name) -> name.startsWith(this.kjarFileHead) && name.endsWith(".jar"));
        if (files == null || files.length == 0) {
            return null;
        }
        File candidateNew = this.getCandidateNew(files);
        int versionComparison = KieFileSystemScannerImpl.compareVersion(KieFileSystemScannerImpl.getVersionFromFile(candidateNew, this.kjarFileHead.length()), this.kieContainer.getReleaseId().getVersion());
        return versionComparison > 0 || versionComparison == 0 && this.kieContainer.getReleaseId().isSnapshot() ? candidateNew : null;
    }

    private File getCandidateNew(File[] files) {
        if (files.length == 1) {
            return files[0];
        }
        List<File> jarFiles = Arrays.asList(files);
        jarFiles.sort(this.versionComparator.reversed());
        return jarFiles.get(0);
    }

    private static int compareVersion(String v1, String v2) {
        return new ReleaseIdComparator.ComparableVersion(v1).compareTo(new ReleaseIdComparator.ComparableVersion(v2));
    }

    private static String getVersionFromFile(File f, int headLength) {
        String name = f.getName();
        return name.substring(headLength, name.length() - 4);
    }

    private static class VersionComparator
    implements Comparator<File> {
        private final int headLength;

        private VersionComparator(int headLength) {
            this.headLength = headLength;
        }

        @Override
        public int compare(File f1, File f2) {
            return KieFileSystemScannerImpl.compareVersion(KieFileSystemScannerImpl.getVersionFromFile(f1, this.headLength), KieFileSystemScannerImpl.getVersionFromFile(f2, this.headLength));
        }
    }
}

