/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.kie.builder.impl;

import java.util.List;
import org.drools.compiler.builder.InternalKnowledgeBuilder;
import org.drools.compiler.compiler.DroolsError;
import org.drools.compiler.compiler.PackageBuilderErrors;
import org.drools.compiler.kie.builder.impl.AbstractKieModule;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieBaseUpdater;
import org.drools.compiler.kie.builder.impl.KieBaseUpdaterImplContext;
import org.drools.compiler.kie.builder.impl.KieBuilderImpl;
import org.drools.core.base.ClassObjectType;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.InternalWorkingMemoryEntryPoint;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.definitions.impl.KnowledgePackageImpl;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.impl.KieBaseUpdate;
import org.drools.core.io.internal.InternalResource;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.rule.DialectRuntimeData;
import org.drools.core.spi.ObjectType;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.io.Resource;
import org.kie.api.runtime.rule.EntryPoint;
import org.kie.internal.builder.ChangeType;
import org.kie.internal.builder.CompositeKnowledgeBuilder;
import org.kie.internal.builder.ResourceChange;
import org.kie.internal.builder.ResourceChangeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieBaseUpdaterImpl
implements KieBaseUpdater {
    private static final Logger log = LoggerFactory.getLogger(KieBaseUpdaterImpl.class);
    protected final KieBaseUpdaterImplContext ctx;

    public KieBaseUpdaterImpl(KieBaseUpdaterImplContext ctx) {
        this.ctx = ctx;
    }

    @Override
    public void run() {
        InternalKnowledgeBuilder kbuilder = this.ctx.kbuilder;
        CompositeKnowledgeBuilder ckbuilder = kbuilder.batch();
        boolean shouldRebuild = this.applyResourceChanges(kbuilder, ckbuilder);
        this.removeResources(kbuilder);
        if (this.ctx.modifyingUsedClass) {
            for (Class clazz : this.ctx.modifiedClasses) {
                this.clearInstancesOfModifiedClass(clazz);
            }
            for (InternalKnowledgePackage internalKnowledgePackage : this.ctx.kBase.getPackagesMap().values()) {
                DialectRuntimeData mvel = internalKnowledgePackage.getDialectRuntimeRegistry().getDialectData("mvel");
                if (mvel == null) continue;
                mvel.resetParserConfiguration();
            }
        }
        if (shouldRebuild) {
            for (String string : this.ctx.unchangedResources) {
                if (!this.isFileInKBase(this.ctx.newKM, this.ctx.newKieBaseModel, string)) continue;
                this.ctx.newKM.addResourceToCompiler(ckbuilder, this.ctx.newKieBaseModel, string);
            }
            KieBaseUpdate kieBaseUpdate = this.createKieBaseUpdate();
            this.ctx.kBase.beforeIncrementalUpdate(kieBaseUpdate);
            this.rebuildAll(kbuilder, ckbuilder);
            this.ctx.kBase.afterIncrementalUpdate(kieBaseUpdate);
        }
        this.ctx.kBase.setResolvedReleaseId(this.ctx.newReleaseId);
        for (InternalWorkingMemory internalWorkingMemory : this.ctx.kBase.getWorkingMemories()) {
            internalWorkingMemory.notifyWaitOnRest();
        }
    }

    private KieBaseUpdate createKieBaseUpdate() {
        KieBaseUpdate kieBaseUpdate = new KieBaseUpdate();
        for (ResourceChangeSet changeSet : this.ctx.cs.getChanges().values()) {
            if (!KieBaseUpdaterImpl.isPackageInKieBase(this.ctx.newKieBaseModel, changeSet.getPackageName())) continue;
            InternalKnowledgePackage currentPkg = this.ctx.currentKM.getPackage(changeSet.getPackageName());
            InternalKnowledgePackage newPkg = this.ctx.newKM.getPackage(changeSet.getPackageName());
            for (ResourceChange change : changeSet.getChanges()) {
                if (change.getType() != ResourceChange.Type.RULE) continue;
                switch (change.getChangeType()) {
                    case ADDED: {
                        kieBaseUpdate.registerRuleToBeAdded(newPkg.getRule(change.getName()));
                        break;
                    }
                    case REMOVED: {
                        kieBaseUpdate.registerRuleToBeRemoved(currentPkg.getRule(change.getName()));
                        break;
                    }
                    case UPDATED: {
                        kieBaseUpdate.registerRuleToBeAdded(newPkg.getRule(change.getName()));
                        kieBaseUpdate.registerRuleToBeRemoved(currentPkg.getRule(change.getName()));
                    }
                }
            }
        }
        return kieBaseUpdate;
    }

    protected void removeResources(InternalKnowledgeBuilder kBuilder) {
        for (ResourceChangeSet rcs : this.ctx.cs.getChanges().values()) {
            String resourceName;
            if (rcs.getChangeType() != ChangeType.REMOVED || (resourceName = rcs.getResourceName()).endsWith(".properties") || !this.isFileInKBase(this.ctx.currentKM, this.ctx.currentKieBaseModel, resourceName)) continue;
            kBuilder.removeObjectsGeneratedFromResource((Resource)this.ctx.currentKM.getResource(resourceName));
        }
    }

    private void rebuildAll(InternalKnowledgeBuilder kbuilder, CompositeKnowledgeBuilder ckbuilder) {
        ckbuilder.build();
        PackageBuilderErrors errors = (PackageBuilderErrors)kbuilder.getErrors();
        if (!errors.isEmpty()) {
            for (DroolsError error : errors.getErrors()) {
                this.ctx.results.addMessage(error).setKieBaseName(this.ctx.newKieBaseModel.getName());
            }
            log.error("Unable to update KieBase: " + this.ctx.newKieBaseModel.getName() + " to release " + this.ctx.newReleaseId + "\n" + errors.toString());
        }
        if (this.ctx.modifyingUsedClass) {
            kbuilder.rewireAllClassObjectTypes();
        }
    }

    private boolean applyResourceChanges(InternalKnowledgeBuilder kbuilder, CompositeKnowledgeBuilder ckbuilder) {
        boolean shouldRebuild = this.ctx.modifyingUsedClass;
        if (this.ctx.modifyingUsedClass) {
            this.invalidateAccessorForOldClass();
            this.updateAllResources(kbuilder, ckbuilder);
        } else {
            shouldRebuild = this.updateResourcesIncrementally(kbuilder, ckbuilder) > 0;
        }
        return shouldRebuild;
    }

    protected void invalidateAccessorForOldClass() {
        for (Class<?> cls : this.ctx.modifiedClasses) {
            InternalKnowledgePackage kpackage = (InternalKnowledgePackage)this.ctx.kBase.getKiePackage(cls.getPackage().getName());
            if (kpackage == null) continue;
            kpackage.removeClass(cls);
        }
    }

    private int updateResourcesIncrementally(InternalKnowledgeBuilder kbuilder, CompositeKnowledgeBuilder ckbuilder) {
        int fileCount = this.ctx.modifiedClasses.size();
        for (ResourceChangeSet rcs : this.ctx.cs.getChanges().values()) {
            fileCount += this.updateResource(kbuilder, ckbuilder, rcs);
        }
        return fileCount;
    }

    protected int updateResource(InternalKnowledgeBuilder kbuilder, CompositeKnowledgeBuilder ckbuilder, ResourceChangeSet rcs) {
        String resourceName;
        int fileCount = 0;
        if (rcs.getChangeType() != ChangeType.REMOVED && !(resourceName = rcs.getResourceName()).endsWith(".properties") && this.isFileInKBase(this.ctx.newKM, this.ctx.newKieBaseModel, resourceName)) {
            List changes = rcs.getChanges();
            if (!changes.isEmpty()) {
                fileCount += AbstractKieModule.updateResource(ckbuilder, this.ctx.newKM, resourceName, rcs) ? 1 : 0;
            } else {
                if (rcs.getChangeType() == ChangeType.UPDATED) {
                    InternalResource resource = this.ctx.currentKM.getResource(resourceName);
                    kbuilder.removeObjectsGeneratedFromResource((Resource)resource);
                }
                fileCount += this.ctx.newKM.addResourceToCompiler(ckbuilder, this.ctx.newKieBaseModel, resourceName, rcs) ? 1 : 0;
            }
        }
        for (ResourceChangeSet.RuleLoadOrder loadOrder : rcs.getLoadOrder()) {
            RuleImpl rule;
            KnowledgePackageImpl pkg = (KnowledgePackageImpl)this.ctx.kBase.getKiePackage(loadOrder.getPkgName());
            if (pkg == null || (rule = pkg.getRule(loadOrder.getRuleName())) == null) continue;
            rule.setLoadOrder(loadOrder.getLoadOrder());
        }
        return fileCount;
    }

    private boolean isFileInKBase(InternalKieModule kieModule, KieBaseModel kieBase, String fileName) {
        if (kieModule.isFileInKBase(kieBase, fileName)) {
            return true;
        }
        for (String include : this.ctx.kProject.getTransitiveIncludes(kieBase)) {
            InternalKieModule includeModule = this.ctx.kProject.getKieModuleForKBase(include);
            if (includeModule == null || !includeModule.isFileInKBase(this.ctx.kProject.getKieBaseModel(include), fileName)) continue;
            return true;
        }
        return false;
    }

    protected void updateAllResources(InternalKnowledgeBuilder kbuilder, CompositeKnowledgeBuilder ckbuilder) {
        for (String resourceName : this.ctx.currentKM.getFileNames()) {
            if (resourceName.endsWith(".properties") || !this.isFileInKBase(this.ctx.currentKM, this.ctx.newKieBaseModel, resourceName)) continue;
            InternalResource resource = this.ctx.currentKM.getResource(resourceName);
            kbuilder.removeObjectsGeneratedFromResource((Resource)resource);
        }
        for (String resourceName : this.ctx.newKM.getFileNames()) {
            if (resourceName.endsWith(".properties") || !this.isFileInKBase(this.ctx.newKM, this.ctx.newKieBaseModel, resourceName)) continue;
            this.ctx.newKM.addResourceToCompiler(ckbuilder, this.ctx.newKieBaseModel, resourceName);
        }
    }

    protected void clearInstancesOfModifiedClass(Class<?> cls) {
        ClassObjectType objectType = new ClassObjectType(cls);
        for (EntryPointNode epn : this.ctx.kBase.getRete().getEntryPointNodes().values()) {
            epn.removeObjectType((ObjectType)objectType);
        }
        for (InternalWorkingMemory wm : this.ctx.kBase.getWorkingMemories()) {
            for (EntryPoint ep : wm.getEntryPoints()) {
                InternalWorkingMemoryEntryPoint wmEp = (InternalWorkingMemoryEntryPoint)wm.getEntryPoint(ep.getEntryPointId());
                if (!wmEp.getObjectStore().clearClassStore(cls)) continue;
                log.warn("Class " + cls.getName() + " has been modified and therfore its old instances will no longer match");
            }
        }
    }

    protected static boolean isPackageInKieBase(KieBaseModel kieBaseModel, String pkgName) {
        return pkgName != null && (kieBaseModel.getPackages().isEmpty() || KieBuilderImpl.isPackageInKieBase(kieBaseModel, pkgName));
    }
}

