/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.builder;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.drools.compiler.builder.DroolsAssemblerContext;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.compiler.PackageBuilderErrors;
import org.drools.compiler.compiler.PackageBuilderResults;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.rule.TypeDeclaration;
import org.drools.core.spi.ObjectType;
import org.drools.drl.ast.descr.PackageDescr;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.kie.api.KieBase;
import org.kie.api.definition.KiePackage;
import org.kie.api.internal.io.ResourceTypePackage;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceConfiguration;
import org.kie.api.io.ResourceType;
import org.kie.internal.builder.AssemblerContext;
import org.kie.internal.builder.CompositeKnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderError;
import org.kie.internal.builder.KnowledgeBuilderErrors;
import org.kie.internal.builder.KnowledgeBuilderResults;
import org.kie.internal.builder.ResultSeverity;

public interface InternalKnowledgeBuilder
extends KnowledgeBuilder,
DroolsAssemblerContext,
AssemblerContext {
    public ResourceRemovalResult removeObjectsGeneratedFromResource(Resource var1);

    public void addPackage(PackageDescr var1);

    public InternalKnowledgePackage getPackage(String var1);

    public void rewireAllClassObjectTypes();

    public static class Empty
    implements InternalKnowledgeBuilder {
        private final ClassLoader rootClassLoader;
        private final Supplier<KnowledgeBuilderImpl> lazyBuilder;
        private KnowledgeBuilderImpl knowledgeBuilder;

        public Empty(ClassLoader rootClassLoader, Supplier<KnowledgeBuilderImpl> lazyBuilder) {
            this.rootClassLoader = rootClassLoader;
            this.lazyBuilder = lazyBuilder;
        }

        public Collection<KiePackage> getKnowledgePackages() {
            return this.withKnowledgeBuilder(KnowledgeBuilder::getKnowledgePackages, Collections.emptyList());
        }

        public boolean hasErrors() {
            return this.withKnowledgeBuilder(KnowledgeBuilder::hasErrors, false);
        }

        @Override
        public KnowledgeBuilderErrors getErrors() {
            return this.withKnowledgeBuilder(DroolsAssemblerContext::getErrors, new PackageBuilderErrors());
        }

        public KnowledgeBuilderResults getResults(ResultSeverity ... severities) {
            return this.withKnowledgeBuilder(kb -> kb.getResults(severities), new PackageBuilderResults());
        }

        public boolean hasResults(ResultSeverity ... severities) {
            return this.withKnowledgeBuilder(kb -> kb.hasResults(severities), false);
        }

        @Override
        public ClassLoader getRootClassLoader() {
            return this.rootClassLoader;
        }

        @Override
        public void rewireAllClassObjectTypes() {
            this.withKnowledgeBuilder(InternalKnowledgeBuilder::rewireAllClassObjectTypes);
        }

        @Override
        public Map<String, Class<?>> getGlobals() {
            return this.withKnowledgeBuilder(DroolsAssemblerContext::getGlobals, Collections.emptyMap());
        }

        public KieBase newKieBase() {
            return this.withKnowledgeBuilder(KnowledgeBuilder::newKieBase, null);
        }

        public void undo() {
            this.withKnowledgeBuilder(KnowledgeBuilder::undo);
        }

        public void reportError(KnowledgeBuilderError error) {
            this.withKnowledgeBuilder(kb -> kb.reportError(error));
        }

        @Override
        public ResourceRemovalResult removeObjectsGeneratedFromResource(Resource resource) {
            return this.getOrCreateKnowledgeBuilder().removeObjectsGeneratedFromResource(resource);
        }

        @Override
        public InternalKnowledgePackage getPackage(String name) {
            return this.withKnowledgeBuilder(kb -> kb.getPackage(name), null);
        }

        @Override
        public KnowledgeBuilderConfigurationImpl getBuilderConfiguration() {
            return this.withKnowledgeBuilder(DroolsAssemblerContext::getBuilderConfiguration, null);
        }

        @Override
        public TypeDeclaration getAndRegisterTypeDeclaration(Class<?> cls, String name) {
            return this.withKnowledgeBuilder(kb -> kb.getAndRegisterTypeDeclaration(cls, name), null);
        }

        @Override
        public TypeDeclaration getTypeDeclaration(Class<?> typeClass) {
            return this.withKnowledgeBuilder(kb -> kb.getTypeDeclaration(typeClass), null);
        }

        @Override
        public TypeDeclaration getTypeDeclaration(ObjectType objectType) {
            return this.withKnowledgeBuilder(kb -> kb.getTypeDeclaration(objectType), null);
        }

        @Override
        public List<PackageDescr> getPackageDescrs(String namespace) {
            return this.withKnowledgeBuilder(kb -> kb.getPackageDescrs(namespace), Collections.emptyList());
        }

        @Override
        public PackageRegistry getPackageRegistry(String packageName) {
            return this.withKnowledgeBuilder(kb -> kb.getPackageRegistry(packageName), null);
        }

        @Override
        public InternalKnowledgeBase getKnowledgeBase() {
            return this.withKnowledgeBuilder(DroolsAssemblerContext::getKnowledgeBase, null);
        }

        private synchronized void withKnowledgeBuilder(Consumer<InternalKnowledgeBuilder> f) {
            if (this.knowledgeBuilder != null) {
                f.accept(this.knowledgeBuilder);
            }
        }

        private synchronized <T> T withKnowledgeBuilder(Function<InternalKnowledgeBuilder, T> f, T defaultValue) {
            return this.knowledgeBuilder != null ? f.apply(this.knowledgeBuilder) : defaultValue;
        }

        @Override
        public void addPackage(PackageDescr packageDescr) {
            this.getOrCreateKnowledgeBuilder().addPackage(packageDescr);
        }

        public void add(Resource resource, ResourceType type) {
            this.getOrCreateKnowledgeBuilder().add(resource, type);
        }

        public void add(Resource resource, ResourceType type, ResourceConfiguration configuration) {
            this.getOrCreateKnowledgeBuilder().add(resource, type, configuration);
        }

        public <T extends ResourceTypePackage<?>> T computeIfAbsent(ResourceType resourceType, String namespace, Function<? super ResourceType, T> mappingFunction) {
            return this.getOrCreateKnowledgeBuilder().computeIfAbsent(resourceType, namespace, mappingFunction);
        }

        public CompositeKnowledgeBuilder batch() {
            return this.getOrCreateKnowledgeBuilder().batch();
        }

        private synchronized KnowledgeBuilderImpl getOrCreateKnowledgeBuilder() {
            if (this.knowledgeBuilder == null) {
                this.knowledgeBuilder = this.lazyBuilder.get();
            }
            return this.knowledgeBuilder;
        }
    }

    public static class ResourceRemovalResult {
        private boolean modified;
        private Collection<String> removedTypes;

        public ResourceRemovalResult() {
            this(false, Collections.emptyList());
        }

        public ResourceRemovalResult(boolean modified, Collection<String> removedTypes) {
            this.modified = modified;
            this.removedTypes = removedTypes;
        }

        public void add(ResourceRemovalResult other) {
            this.mergeModified(other.modified);
            if (this.removedTypes.isEmpty()) {
                this.removedTypes = other.removedTypes;
            } else {
                this.removedTypes.addAll(other.removedTypes);
            }
        }

        public void mergeModified(boolean otherModified) {
            this.modified = this.modified || otherModified;
        }

        public boolean isModified() {
            return this.modified;
        }

        public Collection<String> getRemovedTypes() {
            return this.removedTypes;
        }
    }
}

